/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker$WhenMappings;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\f\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0010\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u000eH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationUseSiteTargetChecker;", "", "()V", "check", "", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkDeclaration", "checkIfDelegatedProperty", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIfHasBackingField", "checkIfMutableProperty", "checkIfProperty", "", "useSiteDescription", "", "frontend"})
public final class AnnotationUseSiteTargetChecker {
    public static final AnnotationUseSiteTargetChecker INSTANCE;

    public final void check(@NotNull KtAnnotated annotated, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)annotated, (String)"annotated");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.checkDeclaration(trace, annotated, descriptor2);
        if (annotated instanceof KtFunction) {
            for (KtParameter parameter : ((KtFunction)annotated).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                if (parameter.hasValOrVar()) continue;
                if ((VariableDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter) == null) {
                    continue;
                }
                KtParameter ktParameter = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                KtAnnotated ktAnnotated = ktParameter;
                VariableDescriptor variableDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor, (String)"parameterDescriptor");
                this.checkDeclaration(trace, ktAnnotated, variableDescriptor);
            }
        }
    }

    private final void checkDeclaration(@NotNull BindingTrace $receiver, KtAnnotated annotated, DeclarationDescriptor descriptor2) {
        Iterator<KtAnnotationEntry> iterator2 = annotated.getAnnotationEntries().iterator();
        block9: while (iterator2.hasNext()) {
            KtAnnotationEntry annotation2;
            KtAnnotationEntry ktAnnotationEntry = annotation2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"annotation");
            KtAnnotationUseSiteTarget useSiteTarget = ktAnnotationEntry.getUseSiteTarget();
            Object object = useSiteTarget;
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null) {
                continue;
            }
            Object target = object;
            switch (AnnotationUseSiteTargetChecker$WhenMappings.$EnumSwitchMapping$0[((Enum)target).ordinal()]) {
                case 1: {
                    this.checkIfHasBackingField($receiver, annotated, descriptor2, annotation2);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    this.checkIfDelegatedProperty($receiver, annotated, annotation2);
                    break;
                }
                case 5: {
                    this.checkIfMutableProperty($receiver, annotated, annotation2);
                    break;
                }
                case 6: {
                    DeclarationDescriptor containingDeclaration;
                    if (!(annotated instanceof KtParameter)) {
                        $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on((PsiElement)annotation2));
                        break;
                    }
                    VariableDescriptor variableDescriptor = (VariableDescriptor)$receiver.getBindingContext().get(BindingContext.VALUE_PARAMETER, annotated);
                    DeclarationDescriptor declarationDescriptor = containingDeclaration = variableDescriptor != null ? variableDescriptor.getContainingDeclaration() : null;
                    if (!(containingDeclaration instanceof ConstructorDescriptor) || !((ConstructorDescriptor)containingDeclaration).isPrimary()) {
                        $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on((PsiElement)annotation2));
                        break;
                    }
                    if (((KtParameter)annotated).hasValOrVar()) continue block9;
                    $receiver.report(Errors.REDUNDANT_ANNOTATION_TARGET.on((PsiElement)annotation2, ((AnnotationUseSiteTarget)((Object)target)).getRenderName()));
                    break;
                }
                case 7: {
                    this.checkIfMutableProperty($receiver, annotated, annotation2);
                    break;
                }
                case 8: {
                    SimpleDiagnostic<KtAnnotationUseSiteTarget> simpleDiagnostic = Errors.INAPPLICABLE_FILE_TARGET.on((KtAnnotationUseSiteTarget)((PsiElement)useSiteTarget));
                    Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"INAPPLICABLE_FILE_TARGET.on(useSiteTarget)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($receiver, simpleDiagnostic);
                }
            }
        }
    }

    private final void checkIfDelegatedProperty(@NotNull BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && !((KtProperty)annotated).hasDelegate() || annotated instanceof KtParameter && ((KtParameter)annotated).hasValOrVar()) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE.on((PsiElement)annotation2));
        }
    }

    private final void checkIfHasBackingField(@NotNull BindingTrace $receiver, KtAnnotated annotated, DeclarationDescriptor descriptor2, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && ((KtProperty)annotated).hasDelegate() && descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((Boolean)$receiver.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2)), (Object)true) ^ true) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD.on((PsiElement)annotation2));
        }
    }

    private final String useSiteDescription(@NotNull KtAnnotationEntry $receiver) {
        Object object = $receiver.getUseSiteTarget();
        if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null || (object = ((AnnotationUseSiteTarget)((Object)object)).getRenderName()) == null) {
            object = "unknown target";
        }
        return object;
    }

    private final void checkIfMutableProperty(@NotNull BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isMutable;
        if (!this.checkIfProperty($receiver, annotated, annotation2)) {
            return;
        }
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? ((KtProperty)annotated).isVar() : (isMutable = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).isMutable() : false);
        if (!isMutable) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_IMMUTABLE.on((PsiElement)annotation2, this.useSiteDescription(annotation2)));
        }
    }

    private final boolean checkIfProperty(@NotNull BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isProperty;
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? !((KtProperty)annotated).isLocal() : (isProperty = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).hasValOrVar() : false);
        if (!isProperty) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_ON_PROPERTY.on((PsiElement)annotation2, this.useSiteDescription(annotation2)));
        }
        return isProperty;
    }

    private AnnotationUseSiteTargetChecker() {
    }

    static {
        AnnotationUseSiteTargetChecker annotationUseSiteTargetChecker;
        INSTANCE = annotationUseSiteTargetChecker = new AnnotationUseSiteTargetChecker();
    }
}

