/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import icons.GradleIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.GradlePluginDescriptionsExtension;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginActionHandler;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class AddGradleDslPluginAction
extends CodeInsightAction {
    public static final String ID = "AddGradleDslPluginAction";
    static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private final List<Pair<String, String>> myPlugins;

    public AddGradleDslPluginAction() {
        this.getTemplatePresentation().setDescription(GradleBundle.message("gradle.codeInsight.action.apply_plugin.description", new Object[0]));
        this.getTemplatePresentation().setText(GradleBundle.message("gradle.codeInsight.action.apply_plugin.text", new Object[0]));
        this.getTemplatePresentation().setIcon(GradleIcons.GradlePlugin);
        this.myPlugins = new ArrayList<Pair<String, String>>();
        for (GradlePluginDescriptionsExtension extension : (GradlePluginDescriptionsExtension[])GradlePluginDescriptionsExtension.EP_NAME.getExtensions()) {
            for (Map.Entry<String, String> pluginDescription : extension.getPluginDescriptions().entrySet()) {
                this.myPlugins.add((Pair<String, String>)Pair.pair((Object)pluginDescription.getKey(), (Object)pluginDescription.getValue()));
            }
        }
        this.myPlugins.sort((o1, o2) -> ((String)o1.first).compareTo((String)o2.first));
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        AddGradleDslPluginActionHandler addGradleDslPluginActionHandler = new AddGradleDslPluginActionHandler(this.myPlugins);
        if (addGradleDslPluginActionHandler == null) {
            AddGradleDslPluginAction.$$$reportNull$$$0(0);
        }
        return addGradleDslPluginActionHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            AddGradleDslPluginAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            AddGradleDslPluginAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            AddGradleDslPluginAction.$$$reportNull$$$0(3);
        }
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        if (!GroovyFileType.GROOVY_FILE_TYPE.equals(file.getFileType())) {
            return false;
        }
        return !"settings.gradle".equals(file.getName()) && file.getName().endsWith("gradle");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

