/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectSerializer;

public class ExternalProjectDataCache {
    private static final Logger LOG = Logger.getInstance(ExternalProjectDataCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Pair<ProjectSystemId, File>, ExternalProject> myExternalRootProjects;

    public static ExternalProjectDataCache getInstance(@NotNull Project project) {
        if (project == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(0);
        }
        return (ExternalProjectDataCache)ServiceManager.getService((Project)project, ExternalProjectDataCache.class);
    }

    public ExternalProjectDataCache(@NotNull Project project) {
        if (project == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myExternalRootProjects = ConcurrentFactoryMap.createMap(key -> new ExternalProjectSerializer().load((ProjectSystemId)key.first, (File)key.second), () -> ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)ExternalSystemUtil.HASHING_STRATEGY));
    }

    @Nullable
    public ExternalProject getRootExternalProject(@NotNull ProjectSystemId systemId, @NotNull File projectRootDir) {
        if (systemId == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(2);
        }
        if (projectRootDir == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(3);
        }
        ExternalProject externalProject = this.myExternalRootProjects.get(Pair.create((Object)systemId, (Object)projectRootDir));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Can not find data for project at: " + projectRootDir);
            LOG.debug("Existing imported projects paths: " + ContainerUtil.map(this.myExternalRootProjects.entrySet(), entry -> {
                if (!(entry.getValue() instanceof ExternalProject)) {
                    return null;
                }
                return Pair.create(entry.getKey(), (Object)((ExternalProject)entry.getValue()).getProjectDir());
            }));
        }
        return externalProject;
    }

    public void saveExternalProject(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(4);
        }
        DefaultExternalProject value = new DefaultExternalProject(externalProject);
        new ExternalProjectSerializer().save((ExternalProject)value);
        this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)Pair.create((Object)new ProjectSystemId(externalProject.getExternalSystemId()), (Object)externalProject.getProjectDir()), (ExternalProject)value);
    }

    @NotNull
    public Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull Module module) {
        if (parentProject == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(5);
        }
        if (module == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(6);
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        boolean isSourceSet = "sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module));
        Map<String, ExternalSourceSet> map = externalProjectId != null ? ExternalProjectDataCache.findExternalProject(parentProject, externalProjectId, isSourceSet) : Collections.emptyMap();
        if (map == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    private static Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull String externalProjectId, boolean isSourceSet) {
        if (parentProject == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(8);
        }
        if (externalProjectId == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(9);
        }
        LinkedList queue = ContainerUtil.newLinkedList();
        queue.add(parentProject);
        while (!queue.isEmpty()) {
            ExternalProject externalProject = (ExternalProject)queue.remove();
            String projectId = externalProject.getId();
            boolean isRelatedProject = projectId.equals(externalProjectId);
            HashMap result = ContainerUtil.newHashMap();
            for (Map.Entry sourceSetEntry : externalProject.getSourceSets().entrySet()) {
                String sourceSetName = (String)sourceSetEntry.getKey();
                String sourceSetId = projectId + ":" + sourceSetName;
                if (!isRelatedProject && (!isSourceSet || !externalProjectId.equals(sourceSetId))) continue;
                result.put(sourceSetName, sourceSetEntry.getValue());
            }
            if (!result.isEmpty() || isRelatedProject) {
                HashMap hashMap = result;
                if (hashMap == null) {
                    ExternalProjectDataCache.$$$reportNull$$$0(10);
                }
                return hashMap;
            }
            queue.addAll(externalProject.getChildProjects().values());
        }
        Map<String, ExternalSourceSet> map = Collections.emptyMap();
        if (map == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(11);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentProject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataCache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataCache";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootExternalProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveExternalProject";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findExternalProject";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

