/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.mapping;

import com.intellij.gwt.uiBinder.mapping.UiTemplateInterfaceJamElement;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UiBinderMappingService {
    public static UiBinderMappingService getInstance(@NotNull Module module) {
        if (module == null) {
            UiBinderMappingService.$$$reportNull$$$0(0);
        }
        return (UiBinderMappingService)ModuleServiceManager.getService((Module)module, UiBinderMappingService.class);
    }

    @NotNull
    public abstract List<PsiClass> getBoundClasses(@NotNull PsiFile var1);

    @NotNull
    public abstract List<XmlFile> getUiXmlFiles(@NotNull PsiClass var1);

    @Nullable
    public abstract XmlFile getUiXmlFile(@NotNull PsiClass var1);

    public abstract boolean isUiRendererComponent(@NotNull PsiClass var1);

    @NotNull
    public static List<PsiClass> getBoundClassesForFile(@NotNull PsiFile file) {
        Module module;
        if (file == null) {
            UiBinderMappingService.$$$reportNull$$$0(1);
        }
        List<PsiClass> list = (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null ? UiBinderMappingService.getInstance(module).getBoundClasses(file) : Collections.emptyList();
        if (list == null) {
            UiBinderMappingService.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<XmlFile> getUiXmlFilesForClass(@NotNull PsiClass psiClass) {
        Module module;
        if (psiClass == null) {
            UiBinderMappingService.$$$reportNull$$$0(3);
        }
        List<XmlFile> list = (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) != null ? UiBinderMappingService.getInstance(module).getUiXmlFiles(psiClass) : Collections.emptyList();
        if (list == null) {
            UiBinderMappingService.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static String deduceTemplateFileUrl(@NotNull PsiClass binderClass) {
        UiTemplateInterfaceJamElement element;
        if (binderClass == null) {
            UiBinderMappingService.$$$reportNull$$$0(5);
        }
        XmlFile xmlFile = (element = UiTemplateInterfaceJamElement.getElement(binderClass)) == null ? UiBinderMappingService.getDefaultTemplateFile(binderClass) : UiBinderMappingService.getAnnotationTemplateFile(element.getUiTemplateValue(), binderClass);
        VirtualFile virtualFile = xmlFile == null ? null : xmlFile.getVirtualFile();
        return virtualFile == null ? null : virtualFile.getUrl();
    }

    @Nullable
    public static XmlFile getDefaultTemplateFile(@NotNull PsiClass aClass) {
        PsiClass containingClass;
        if (aClass == null) {
            UiBinderMappingService.$$$reportNull$$$0(6);
        }
        if ((containingClass = aClass.getContainingClass()) != null) {
            aClass = containingClass;
        }
        Project project = aClass.getProject();
        String packageName = JavaHierarchyUtil.getPackageName((PsiClass)aClass);
        if (packageName == null) {
            return null;
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (psiPackage == null) {
            return null;
        }
        String fileName = aClass.getName() + ".ui.xml";
        return UiBinderMappingService.findTemplateXmlFile(psiPackage, fileName, aClass.getResolveScope());
    }

    @Nullable
    private static XmlFile getAnnotationTemplateFile(@Nullable String uiTemplateValue, @NotNull PsiClass binderClass) {
        String fileName;
        String packageName;
        if (binderClass == null) {
            UiBinderMappingService.$$$reportNull$$$0(7);
        }
        if (uiTemplateValue == null) {
            return null;
        }
        if (!uiTemplateValue.endsWith(".ui.xml")) {
            return null;
        }
        String unsuffixed = StringUtil.trimEnd((String)uiTemplateValue, (String)".ui.xml");
        if (unsuffixed.contains(".")) {
            packageName = StringUtil.getPackageName((String)unsuffixed);
            fileName = StringUtil.getShortName((String)unsuffixed);
        } else {
            String templateName = JavaHierarchyUtil.getPackageName((PsiClass)binderClass) + "." + unsuffixed.replace('/', '.');
            packageName = StringUtil.getPackageName((String)templateName);
            fileName = StringUtil.getShortName((String)templateName);
        }
        fileName = fileName.replace('$', '.');
        Project project = binderClass.getProject();
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (psiPackage == null) {
            return null;
        }
        return UiBinderMappingService.findTemplateXmlFile(psiPackage, fileName, binderClass.getResolveScope());
    }

    @Nullable
    private static XmlFile findTemplateXmlFile(@NotNull PsiPackage psiPackage, @NotNull String fileName, @NotNull GlobalSearchScope searchScope) {
        if (psiPackage == null) {
            UiBinderMappingService.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            UiBinderMappingService.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            UiBinderMappingService.$$$reportNull$$$0(10);
        }
        if (!fileName.endsWith(".ui.xml")) {
            fileName = fileName + ".ui.xml";
        }
        for (PsiDirectory psiDirectory : psiPackage.getDirectories(searchScope)) {
            PsiFile xmlFile = psiDirectory.findFile(fileName);
            if (!(xmlFile instanceof XmlFile)) continue;
            return (XmlFile)xmlFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binderClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundClassesForFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiXmlFilesForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBoundClassesForFile";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUiXmlFilesForClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deduceTemplateFileUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTemplateFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTemplateFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateXmlFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

