/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.admin;

import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.oss.admin.DeploymentStatusWrapper;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallback;
import com.intellij.javaee.oss.admin.JavaeeAdminServerBase;
import com.intellij.javaee.oss.admin.JavaeeAdminStartCallback;
import com.intellij.javaee.oss.agent.AgentCallback;
import com.intellij.javaee.oss.agent.AgentDeploymentCallback;
import com.intellij.javaee.oss.agent.AgentDeploymentCallbackExtension;
import com.intellij.javaee.oss.agent.AgentExtension;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.ParametersMapImpl;
import com.intellij.javaee.oss.agent.VendorSpecificAgent;
import com.intellij.javaee.util.ILogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.agent.RemoteAgentManager;
import com.intellij.remoteServer.agent.RemoteAgentProxyFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeAgentAdminServerBase
extends JavaeeAdminServerBase {
    private static final Logger LOG = Logger.getInstance(JavaeeAgentAdminServerBase.class);
    public static final Map<String, DeploymentStatus> WRAPPED_NAME_2_STATUS = new HashMap<String, DeploymentStatus>();
    private final VendorSpecificAgent myAgentProxy;
    private final Map<String, DeploymentModel> myDeploymentName2Model = new HashMap<String, DeploymentModel>();

    protected JavaeeAgentAdminServerBase(AgentProxyFactory agentProxyFactory, List<File> instanceLibraries, List<Class<?>> commonJarClasses, String specificsRuntimeModuleName, String specificsBuildJarPath, String agentClassName) throws Exception {
        ArrayList allCommonJarClasses = new ArrayList(commonJarClasses);
        allCommonJarClasses.add(ILogger.class);
        this.myAgentProxy = (VendorSpecificAgent)RemoteAgentManager.getInstance().createAgent((RemoteAgentProxyFactory)agentProxyFactory, instanceLibraries, allCommonJarClasses, specificsRuntimeModuleName, specificsBuildJarPath, VendorSpecificAgent.class, agentClassName, this.getClass());
    }

    protected AgentExtension getAgentExtension() {
        return this.myAgentProxy.getExtension();
    }

    @Override
    public void start(String host, int port, String username, String password, final JavaeeAdminStartCallback callback) throws Exception {
        super.start(host, port, username, password, callback);
        ParametersMapImpl initParameters = new ParametersMapImpl();
        this.setupInitParameters(initParameters);
        this.myAgentProxy.init(host, port, username, password, initParameters, new AgentCallback(){

            private ILogger getLogger() {
                return callback.getLogger();
            }

            public void debugEx(Exception e) {
                this.getLogger().debugEx(e);
            }

            public void errorEx(Exception e) {
                this.getLogger().errorEx(e);
            }

            public void debug(String message) {
                this.getLogger().debug(message);
            }

            public void error(String message) {
                this.getLogger().error(message);
            }

            public void info(String message) {
                this.getLogger().info(message);
            }

            @Override
            public void fireUpdateDeploymentStatus() {
                callback.updateDeploymentStatus();
            }
        });
    }

    protected void setupInitParameters(ParametersMap initParameters) {
    }

    @Override
    public void shutdown() {
        this.myAgentProxy.destroy();
    }

    @Override
    public boolean doConnect() {
        return this.myAgentProxy.connect();
    }

    @Override
    public void doDisconnect() {
        this.myAgentProxy.disconnect();
    }

    @Override
    public void startDeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        new DeploymentJob(){

            @Override
            protected void doJob(String deploymentName, DeploymentModel deployment, File source, AgentDeploymentCallback callback) throws Exception {
                ParametersMapImpl deployParameters = new ParametersMapImpl();
                JavaeeAgentAdminServerBase.this.setupDeployParameters(deployment, source, deployParameters);
                JavaeeAgentAdminServerBase.this.myAgentProxy.startDeploy(deploymentName, source, deployParameters, callback);
            }
        }.perform(deployment, source, DeploymentStatus.FAILED, callback);
    }

    @Override
    public void startUndeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        new DeploymentJob(){

            @Override
            protected void doJob(String deploymentName, DeploymentModel deployment, File source, AgentDeploymentCallback callback) {
                JavaeeAgentAdminServerBase.this.myAgentProxy.startUndeploy(deploymentName, callback);
            }
        }.perform(deployment, source, DeploymentStatus.UNKNOWN, callback);
    }

    @Override
    public void startUpdateDeploymentStatus(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        new DeploymentJob(){

            @Override
            protected void doJob(String deploymentName, DeploymentModel deployment, File source, AgentDeploymentCallback callback) {
                JavaeeAgentAdminServerBase.this.myAgentProxy.updateDeploymentStatus(deploymentName, callback);
            }
        }.perform(deployment, source, DeploymentStatus.UNKNOWN, callback);
    }

    protected AgentDeploymentCallback createDeploymentCallback(DeploymentModel deployment, JavaeeAdminDeployCallback adminCallback) {
        return new AgentDeploymentCallbackBase(adminCallback);
    }

    protected VendorSpecificAgent getAgent() {
        return this.myAgentProxy;
    }

    protected abstract void setupDeployParameters(DeploymentModel var1, File var2, ParametersMap var3) throws Exception;

    @NotNull
    protected abstract String getDeploymentName(DeploymentModel var1, File var2) throws Exception;

    static {
        WRAPPED_NAME_2_STATUS.put(DeploymentStatusWrapper.STATUS_ACTIVATING.getName(), DeploymentStatus.ACTIVATING);
        WRAPPED_NAME_2_STATUS.put(DeploymentStatusWrapper.STATUS_FAILED.getName(), DeploymentStatus.FAILED);
        WRAPPED_NAME_2_STATUS.put(DeploymentStatusWrapper.STATUS_UNKNOWN.getName(), DeploymentStatus.UNKNOWN);
        WRAPPED_NAME_2_STATUS.put(DeploymentStatusWrapper.STATUS_NOT_DEPLOYED.getName(), DeploymentStatus.NOT_DEPLOYED);
        WRAPPED_NAME_2_STATUS.put(DeploymentStatusWrapper.STATUS_DEPLOYED.getName(), DeploymentStatus.DEPLOYED);
    }

    protected class AgentDeploymentCallbackBase
    implements AgentDeploymentCallback {
        private JavaeeAdminDeployCallback myAdminCallback;

        public AgentDeploymentCallbackBase(JavaeeAdminDeployCallback callback) {
            this.myAdminCallback = callback;
        }

        @Override
        public void setDeploymentStatus(String deploymentName, String statusName) {
            this.myAdminCallback.setDeploymentStatus((DeploymentModel)JavaeeAgentAdminServerBase.this.myDeploymentName2Model.get(deploymentName), WRAPPED_NAME_2_STATUS.get(statusName));
        }

        @Override
        public void setDeploymentStatusWithMessage(String deploymentName, String statusName, String message) {
            this.myAdminCallback.setDeploymentStatus((DeploymentModel)JavaeeAgentAdminServerBase.this.myDeploymentName2Model.get(deploymentName), WRAPPED_NAME_2_STATUS.get(statusName), message);
        }

        @Override
        public void setDeploymentStatusWithError(String deploymentName, String statusName, Exception error) {
            this.myAdminCallback.setDeploymentStatus((DeploymentModel)JavaeeAgentAdminServerBase.this.myDeploymentName2Model.get(deploymentName), WRAPPED_NAME_2_STATUS.get(statusName), error);
        }

        @Override
        public AgentDeploymentCallbackExtension getExtension() {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class DeploymentJob {
        private DeploymentJob() {
        }

        public void perform(DeploymentModel deployment, File source, DeploymentStatus statusOnError, JavaeeAdminDeployCallback callback) {
            try {
                String deploymentName = JavaeeAgentAdminServerBase.this.getDeploymentName(deployment, source);
                JavaeeAgentAdminServerBase.this.myDeploymentName2Model.put(deploymentName, deployment);
                this.doJob(deploymentName, deployment, source, JavaeeAgentAdminServerBase.this.createDeploymentCallback(deployment, callback));
            }
            catch (Exception e) {
                callback.setDeploymentStatus(deployment, statusOnError);
                LOG.error((Throwable)e);
            }
        }

        protected abstract void doJob(String var1, DeploymentModel var2, File var3, AgentDeploymentCallback var4) throws Exception;
    }
}

