/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.ide.DataManager;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.UnitSettingMapConfigurable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignDataSourcesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        PersistenceFacet facet;
        if (e == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext())) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PersistenceFacet facet;
        if (e == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(1);
        }
        if ((facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext())) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)facet.getModule().getProject()).commitAllDocuments();
        AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet);
    }

    public static void showUnitDataSourceMappingDialog(@NotNull PersistenceFacet facet) {
        if (facet == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(2);
        }
        ShowSettingsUtil.getInstance().editConfigurable(facet.getModule().getProject(), (Configurable)new MyComponent(facet));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/actions/AssignDataSourcesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showUnitDataSourceMappingDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyComponent
    extends UnitSettingMapConfigurable<PersistenceFacet, DatabaseSystem>
    implements DataProvider {
        private final DbPsiFacade myManager;
        private final DatabaseSystem myMissingValue = new LocalDataSource("Missing data source", null, null, null, null);

        public MyComponent(PersistenceFacet facet) {
            super(facet);
            this.myManager = DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject());
            DataManager.registerDataProvider((JComponent)this.getComponent(), (DataProvider)this);
        }

        protected UnitSettingMapConfigurable.MyRenderer createComboBoxTableRenderer() {
            ArrayList copy = ContainerUtil.newArrayList((Iterable)DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject()).getDataSources());
            Collections.sort(copy, (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
            LocalDataSource nullValue = new LocalDataSource("", null, null, null, null);
            copy.add(0, nullValue);
            UnitSettingMapConfigurable.MyRenderer renderer = new UnitSettingMapConfigurable.MyRenderer(copy.toArray(new DatabaseSystem[copy.size()]), (DatabaseSystem)nullValue){
                final /* synthetic */ DatabaseSystem val$nullValue;
                {
                    this.val$nullValue = databaseSystem;
                    super((UnitSettingMapConfigurable)this$0, (Object[])x0);
                }

                public String getTextFor(@NotNull DatabaseSystem value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return value == this.val$nullValue ? "Default or no data source" : value.getName();
                }

                protected Icon getIconFor(@NotNull DatabaseSystem value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return value instanceof DbDataSource ? ((DbDataSource)value).getIcon() : EmptyIcon.ICON_16;
                }

                protected void customizeComponent(DatabaseSystem value, JTable table, boolean isSelected) {
                    super.customizeComponent((Object)value, table, isSelected);
                    if (value == myMissingValue) {
                        this.setForeground((Color)JBColor.RED);
                    } else if (!isSelected && !(value instanceof DbDataSource)) {
                        this.setForeground(UIUtil.getComboBoxDisabledForeground());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "value";
                    objectArray2[1] = "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getTextFor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getIconFor";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            renderer.setFont(UIUtil.getLabelFont());
            return renderer;
        }

        public void apply() throws ConfigurationException {
            super.apply();
            Project project = this.myFacet.getModule().getProject();
            DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        @NotNull
        protected String getValueColumnName() {
            if ("Data Source" == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            return "Data Source";
        }

        @Nullable
        protected DatabaseSystem getSettingValue(PersistencePackage unit) {
            String id = this.myFacet.getDataSourceId(unit);
            DbDataSource result = this.myManager.findDataSource(id);
            return result == null && id != null ? this.myMissingValue : result;
        }

        protected void setSettingValue(PersistencePackage unit, DatabaseSystem value) {
            this.myFacet.setDataSourceId(unit, value instanceof DbDataSource ? value.getUniqueId() : null);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                DatabaseSystem value = (DatabaseSystem)this.getSelectedValue();
                return ObjectUtils.tryCast((Object)value, DbDataSource.class);
            }
            if (DatabaseDataKeys.DB_PSI_FACADE.is(dataId)) {
                return this.myManager;
            }
            return null;
        }

        @Nls
        public String getDisplayName() {
            return JpaHighlightingMessages.message("fix.edit.unit.datasource.name", new Object[0]);
        }

        @Nullable
        public String getHelpTopic() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent", "getValueColumnName"));
        }
    }
}

