/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.AnimatedComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class Choreographer
implements ActionListener {
    private static final int DEFAULT_FPS = 60;
    private static final float NANOSECONDS_IN_SECOND = 1.0E9f;
    private static final float DEFAULT_FRAME_LENGTH = 0.016666668f;
    private final List<Animatable> mComponents;
    private List<Animatable> mToRegister;
    private List<Animatable> mToUnregister;
    private final Timer mTimer;
    private boolean mUpdate;
    private long mFrameTime;
    private boolean mReset;
    @NotNull
    private final JComponent mParentContainer;
    private boolean mUpdating;

    public Choreographer(int fps, @NotNull JComponent parent) {
        if (parent == null) {
            Choreographer.$$$reportNull$$$0(0);
        }
        this.mParentContainer = parent;
        this.mComponents = new LinkedList<Animatable>();
        this.mToRegister = new LinkedList<Animatable>();
        this.mToUnregister = new LinkedList<Animatable>();
        this.mUpdate = true;
        this.mUpdating = false;
        this.mTimer = new Timer(1000 / fps, this);
        if (fps >= 0) {
            this.mTimer.start();
        }
    }

    public Choreographer(@NotNull JComponent parent) {
        if (parent == null) {
            Choreographer.$$$reportNull$$$0(1);
        }
        this(60, parent);
    }

    public void register(Animatable animatable) {
        if (this.mUpdating) {
            this.mToRegister.add(animatable);
        } else {
            this.mComponents.add(animatable);
        }
    }

    public void register(@NotNull List<Animatable> animatables) {
        if (animatables == null) {
            Choreographer.$$$reportNull$$$0(2);
        }
        for (Animatable animatable : animatables) {
            this.register(animatable);
        }
    }

    public void unregister(@NotNull Animatable animatable) {
        if (animatable == null) {
            Choreographer.$$$reportNull$$$0(3);
        }
        if (this.mUpdating) {
            this.mToUnregister.add(animatable);
        } else {
            this.mComponents.remove(animatable);
        }
    }

    public void stop() {
        if (this.mTimer.isRunning()) {
            this.mTimer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        long now = System.nanoTime();
        float frame = (float)(now - this.mFrameTime) / 1.0E9f;
        this.mFrameTime = now;
        if (!this.mUpdate) {
            return;
        }
        this.step(frame);
    }

    @Deprecated
    public static void animate(AnimatedComponent component) {
        Choreographer choreographer = new Choreographer(30, component);
        choreographer.register(component);
        HierarchyListener listener = event -> {
            if (choreographer.mTimer.isRunning() && !component.isShowing()) {
                choreographer.mTimer.stop();
            } else if (!choreographer.mTimer.isRunning() && component.isShowing()) {
                choreographer.mTimer.start();
            }
        };
        listener.hierarchyChanged(null);
        component.addHierarchyListener(listener);
    }

    public void setUpdate(boolean update) {
        this.mUpdate = update;
    }

    public void step() {
        this.step(0.016666668f);
    }

    public void reset() {
        this.mReset = true;
    }

    private void step(float frameLength) {
        this.mUpdating = true;
        if (this.mReset) {
            this.mComponents.forEach(Animatable::reset);
            this.mReset = false;
        }
        this.mComponents.forEach(component -> component.animate(frameLength));
        this.mComponents.forEach(Animatable::postAnimate);
        this.mUpdating = false;
        this.mToUnregister.forEach(this::unregister);
        this.mToRegister.forEach(this::register);
        this.mToUnregister.clear();
        this.mToRegister.clear();
        this.mParentContainer.repaint();
    }

    public static float lerp(float from, float to, float fraction, float frameLength, float threshold) {
        if (Math.abs(to - from) < threshold) {
            return to;
        }
        float q = (float)Math.pow(1.0f - fraction, frameLength);
        return from * q + to * (1.0f - q);
    }

    public static double lerp(double from, double to, float fraction, float frameLength, float threshold) {
        if (Math.abs(to - from) < (double)threshold) {
            return to;
        }
        double q = Math.pow(1.0f - fraction, frameLength);
        return from * q + to * (1.0 - q);
    }

    public static float lerp(float from, float to, float fraction, float frameLength) {
        return Choreographer.lerp(from, to, fraction, frameLength, 0.0f);
    }

    public static double lerp(double from, double to, float fraction, float frameLength) {
        return Choreographer.lerp(from, to, fraction, frameLength, 0.0f);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "animatables";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "animatable";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/Choreographer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "unregister";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

