/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.DocumentAccessor;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class LabelWithEditLink
extends JPanel
implements DocumentAccessor {
    private static final String EDIT_TEXT = "<html><a>Edit</a></html>";
    private static final String DONE_TEXT = "<html><a>Done</a></html>";
    private final HyperlinkLabel myLinkLabel = new HyperlinkLabel();
    private final JTextField myTextField = new JTextField(){

        @Override
        public Border getBorder() {
            return this.isEnabled() ? super.getBorder() : BorderFactory.createEmptyBorder();
        }

        @Override
        public Color getBackground() {
            return this.isEnabled() || this.getParent() == null ? super.getBackground() : this.getParent().getBackground();
        }
    };

    public LabelWithEditLink() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.myTextField);
        this.add((Component)this.myLinkLabel);
        this.myLinkLabel.setHtmlText(EDIT_TEXT);
        this.myTextField.setEnabled(false);
        this.myLinkLabel.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                this.toggleEdit();
            }
        });
        this.setFont(UIUtil.getLabelFont());
    }

    private void toggleEdit() {
        boolean isEnabled = this.myTextField.isEnabled();
        this.myLinkLabel.setHtmlText(isEnabled ? EDIT_TEXT : DONE_TEXT);
        this.myTextField.setEnabled(!isEnabled);
        if (!isEnabled) {
            this.myTextField.requestFocusInWindow();
        }
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            LabelWithEditLink.$$$reportNull$$$0(0);
        }
        this.myTextField.setText(text);
    }

    @NotNull
    public String getText() {
        String string = this.myTextField.getText();
        if (string == null) {
            LabelWithEditLink.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font != null && this.myLinkLabel != null) {
            this.myTextField.setFont(font);
            float smallFontSize = font.getSize() - 1;
            Font smallerFont = smallFontSize <= 0.0f ? font : font.deriveFont(smallFontSize);
            this.myLinkLabel.setFont(smallerFont);
        }
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myTextField.getDocument();
        if (document == null) {
            LabelWithEditLink.$$$reportNull$$$0(2);
        }
        return document;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/LabelWithEditLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/LabelWithEditLink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

