/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.SourcesFinder;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JSR45PositionManager<Scope>
implements PositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.JSR45PositionManager");
    protected final DebugProcess myDebugProcess;
    protected final Scope myScope;
    private final String myStratumId;
    protected final SourcesFinder<Scope> mySourcesFinder;
    protected final String GENERATED_CLASS_PATTERN;
    protected Matcher myGeneratedClassPatternMatcher;
    private final Set<LanguageFileType> myFileTypes;

    public JSR45PositionManager(DebugProcess debugProcess, Scope scope, String stratumId, LanguageFileType[] acceptedFileTypes, SourcesFinder<Scope> sourcesFinder) {
        this.myDebugProcess = debugProcess;
        this.myScope = scope;
        this.myStratumId = stratumId;
        this.myFileTypes = Collections.unmodifiableSet(new HashSet<LanguageFileType>(Arrays.asList(acceptedFileTypes)));
        this.mySourcesFinder = sourcesFinder;
        String generatedClassPattern = this.getGeneratedClassesPackage();
        generatedClassPattern = generatedClassPattern.length() == 0 ? this.getGeneratedClassesNamePattern() : generatedClassPattern + "." + this.getGeneratedClassesNamePattern();
        this.GENERATED_CLASS_PATTERN = generatedClassPattern;
        this.myGeneratedClassPatternMatcher = Pattern.compile(generatedClassPattern.replaceAll("\\*", ".*")).matcher("");
    }

    @NonNls
    protected abstract String getGeneratedClassesPackage();

    protected String getGeneratedClassesNamePattern() {
        return "*";
    }

    public final String getStratumId() {
        return this.myStratumId;
    }

    @Override
    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        SourcePosition sourcePosition = null;
        try {
            String sourcePath = this.getRelativeSourcePathByLocation(location);
            PsiFile file = this.mySourcesFinder.findSourceFile(sourcePath, this.myDebugProcess.getProject(), this.myScope);
            if (file != null) {
                int lineNumber = this.getLineNumber(location);
                sourcePosition = SourcePosition.createFromLine(file, lineNumber - 1);
            }
        }
        catch (AbsentInformationException sourcePath) {
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        if (sourcePosition == null) {
            throw NoDataException.INSTANCE;
        }
        return sourcePosition;
    }

    protected String getRelativeSourcePathByLocation(Location location) throws AbsentInformationException {
        return this.getRelativePath(location.sourcePath(this.myStratumId));
    }

    protected int getLineNumber(Location location) {
        return location.lineNumber(this.myStratumId);
    }

    @Override
    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) throws NoDataException {
        if (classPosition == null) {
            JSR45PositionManager.$$$reportNull$$$0(0);
        }
        this.checkSourcePositionFileType(classPosition);
        List<ReferenceType> referenceTypes = this.myDebugProcess.getVirtualMachineProxy().allClasses();
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>();
        for (ReferenceType referenceType : referenceTypes) {
            List<Location> locations;
            this.myGeneratedClassPatternMatcher.reset(referenceType.name());
            if (!this.myGeneratedClassPatternMatcher.matches() || (locations = this.locationsOfClassAt(referenceType, classPosition)) == null || locations.size() <= 0) continue;
            result.add(referenceType);
        }
        ArrayList<ReferenceType> arrayList = result;
        if (arrayList == null) {
            JSR45PositionManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public Set<LanguageFileType> getAcceptedFileTypes() {
        Set<LanguageFileType> set = this.myFileTypes;
        if (set == null) {
            JSR45PositionManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    private void checkSourcePositionFileType(SourcePosition classPosition) throws NoDataException {
        FileType fileType = classPosition.getFile().getFileType();
        if (!this.myFileTypes.contains(fileType)) {
            throw NoDataException.INSTANCE;
        }
    }

    @Override
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        List<Location> locations;
        if (type == null) {
            JSR45PositionManager.$$$reportNull$$$0(3);
        }
        if (position == null) {
            JSR45PositionManager.$$$reportNull$$$0(4);
        }
        List<Location> list = (locations = this.locationsOfClassAt(type, position)) != null ? locations : Collections.emptyList();
        if (list == null) {
            JSR45PositionManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    private List<Location> locationsOfClassAt(final ReferenceType type, final SourcePosition position) throws NoDataException {
        this.checkSourcePositionFileType(position);
        return ApplicationManager.getApplication().runReadAction(new Computable<List<Location>>(){

            public List<Location> compute() {
                try {
                    List<String> relativePaths = JSR45PositionManager.this.getRelativeSourePathsByType(type);
                    for (String relativePath : relativePaths) {
                        PsiFile file = JSR45PositionManager.this.mySourcesFinder.findSourceFile(relativePath, JSR45PositionManager.this.myDebugProcess.getProject(), JSR45PositionManager.this.myScope);
                        if (file == null || !file.equals(position.getFile())) continue;
                        return JSR45PositionManager.this.getLocationsOfLine(type, this.getSourceName(file.getName(), type), relativePath, position.getLine() + 1);
                    }
                }
                catch (AbsentInformationException | ClassNotPreparedException | ObjectCollectedException relativePaths) {
                }
                catch (InternalError ignored) {
                    JSR45PositionManager.this.myDebugProcess.printToConsole(DebuggerBundle.message("internal.error.locations.of.line", type.name()));
                }
                return null;
            }

            private String getSourceName(String name, ReferenceType type2) throws AbsentInformationException {
                for (String sourceNameFromType : type2.sourceNames(JSR45PositionManager.this.myStratumId)) {
                    if (!sourceNameFromType.contains(name)) continue;
                    return sourceNameFromType;
                }
                return name;
            }
        });
    }

    protected List<String> getRelativeSourePathsByType(ReferenceType type) throws AbsentInformationException {
        return type.sourcePaths(this.myStratumId).stream().map(this::getRelativePath).collect(Collectors.toList());
    }

    protected List<Location> getLocationsOfLine(ReferenceType type, String fileName, String relativePath, int lineNumber) throws AbsentInformationException {
        return type.locationsOfLine(this.myStratumId, fileName, lineNumber);
    }

    @Override
    public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            JSR45PositionManager.$$$reportNull$$$0(6);
        }
        if (position == null) {
            JSR45PositionManager.$$$reportNull$$$0(7);
        }
        this.checkSourcePositionFileType(position);
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(new ClassPrepareRequestor(){

            @Override
            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                JSR45PositionManager.this.onClassPrepare(debuggerProcess, referenceType, position, requestor);
            }
        }, this.GENERATED_CLASS_PATTERN);
    }

    protected void onClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType, SourcePosition position, ClassPrepareRequestor requestor) {
        try {
            if (this.locationsOfClassAt(referenceType, position) != null) {
                requestor.processClassPrepare(debuggerProcess, referenceType);
            }
        }
        catch (NoDataException noDataException) {
            // empty catch block
        }
    }

    protected String getRelativePath(String sourcePath) {
        String generatedClassesPackage;
        String prefix;
        if (sourcePath != null && (sourcePath = sourcePath.trim()).startsWith(prefix = (generatedClassesPackage = this.getGeneratedClassesPackage()).replace('.', File.separatorChar)) && (sourcePath = sourcePath.substring(prefix.length())).startsWith(File.separator)) {
            sourcePath = sourcePath.substring(1);
        }
        return sourcePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPosition";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JSR45PositionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JSR45PositionManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedFileTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

