/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaExecutionUtil {
    private JavaExecutionUtil() {
    }

    public static boolean executeRun(@NotNull Project project, String contentName, Icon icon, DataContext dataContext) throws ExecutionException {
        if (project == null) {
            JavaExecutionUtil.$$$reportNull$$$0(0);
        }
        return JavaExecutionUtil.executeRun(project, contentName, icon, dataContext, null);
    }

    public static boolean executeRun(@NotNull Project project, String contentName, Icon icon, DataContext dataContext, Filter[] filters) throws ExecutionException {
        if (project == null) {
            JavaExecutionUtil.$$$reportNull$$$0(1);
        }
        JavaParameters cmdLine = JavaParameters.JAVA_PARAMETERS.getData(dataContext);
        DefaultRunProfile profile = new DefaultRunProfile(project, cmdLine, contentName, icon, filters);
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull(project, DefaultRunExecutor.getRunExecutorInstance(), profile);
        if (builder != null) {
            builder.buildAndExecute();
            return true;
        }
        return false;
    }

    public static Module findModule(Module contextModule, Set<String> patterns, Project project, Condition<PsiClass> isTestMethod) {
        Module nextModule;
        HashSet<Module> modules = new HashSet<Module>();
        for (String className : patterns) {
            PsiClass psiClass = JavaExecutionUtil.findMainClass(project, className.contains(",") ? className.substring(0, className.indexOf(44)) : className, GlobalSearchScope.allScope(project));
            if (psiClass == null || !isTestMethod.value((Object)psiClass)) continue;
            modules.add(ModuleUtilCore.findModuleForPsiElement(psiClass));
        }
        if (modules.size() == 1 && (nextModule = (Module)modules.iterator().next()) != null) {
            return nextModule;
        }
        if (contextModule != null && modules.size() > 1) {
            HashSet<Module> moduleDependencies = new HashSet<Module>();
            ModuleUtilCore.getDependencies(contextModule, moduleDependencies);
            if (moduleDependencies.containsAll(modules)) {
                return contextModule;
            }
        }
        return null;
    }

    @Nullable
    public static String getRuntimeQualifiedName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaExecutionUtil.$$$reportNull$$$0(2);
        }
        return ClassUtil.getJVMClassName(aClass);
    }

    @Nullable
    public static String getPresentableClassName(@Nullable String rtClassName) {
        return JavaExecutionUtil.getPresentableClassName(rtClassName, null);
    }

    @Deprecated
    @Nullable
    public static String getPresentableClassName(@Nullable String rtClassName, JavaRunConfigurationModule configurationModule) {
        if (StringUtil.isEmpty((String)rtClassName)) {
            return null;
        }
        int lastDot = rtClassName.lastIndexOf(46);
        return lastDot == -1 || lastDot == rtClassName.length() - 1 ? rtClassName : rtClassName.substring(lastDot + 1, rtClassName.length());
    }

    public static Module findModule(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaExecutionUtil.$$$reportNull$$$0(3);
        }
        return ModuleUtilCore.findModuleForPsiElement(psiClass);
    }

    @Nullable
    public static PsiClass findMainClass(Module module, String mainClassName) {
        return JavaExecutionUtil.findMainClass(module.getProject(), mainClassName, module.getModuleRuntimeScope(true));
    }

    @Nullable
    public static PsiClass findMainClass(Project project, String mainClassName, GlobalSearchScope scope) {
        if (project.isDefault() || DumbService.isDumb(project) && !DumbService.getInstance(project).isAlternativeResolveEnabled()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        String shortName = StringUtil.getShortName((String)mainClassName);
        String packageName = StringUtil.getPackageName((String)mainClassName);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(psiManager.getProject());
        PsiClass psiClass = psiFacade.findClass(StringUtil.getQualifiedName((String)packageName, (String)shortName.replace('$', '.')), scope);
        return psiClass == null ? psiFacade.findClass(mainClassName, scope) : psiClass;
    }

    public static boolean isNewName(String name) {
        return name == null || name.startsWith(ExecutionBundle.message("run.configuration.unnamed.name.prefix", new Object[0]));
    }

    public static Location stepIntoSingleClass(@NotNull Location location) {
        PsiClassOwner psiFile;
        PsiClass[] classes;
        Object element;
        if (location == null) {
            JavaExecutionUtil.$$$reportNull$$$0(4);
        }
        if (!((element = location.getPsiElement()) instanceof PsiClassOwner)) {
            if (PsiTreeUtil.getParentOfType(element, PsiClass.class) != null) {
                return location;
            }
            if ((element = PsiTreeUtil.getParentOfType(element, PsiClassOwner.class)) == null) {
                return location;
            }
        }
        if ((classes = (psiFile = (PsiClassOwner)element).getClasses()).length != 1) {
            return location;
        }
        if (classes[0].getTextRange() == null) {
            return location;
        }
        return PsiLocation.fromPsiElement(classes[0]);
    }

    public static String getShortClassName(@Nullable String fqName) {
        return fqName == null ? "" : StringUtil.getShortName((String)fqName);
    }

    public static void showExecutionErrorMessage(ExecutionException e, String title, Project project) {
        ExecutionErrorDialog.show(e, title, project);
    }

    public static boolean isRunnableClass(PsiClass aClass) {
        return PsiClassUtil.isRunnableClass(aClass, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/JavaExecutionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRuntimeQualifiedName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "stepIntoSingleClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DefaultRunProfile
    implements RunProfile {
        private final JavaParameters myParameters;
        private final String myContentName;
        private final Filter[] myFilters;
        private final Project myProject;
        private final Icon myIcon;

        public DefaultRunProfile(Project project, JavaParameters parameters, String contentName, Icon icon, Filter[] filters) {
            this.myProject = project;
            this.myParameters = parameters;
            this.myContentName = contentName;
            this.myFilters = filters;
            this.myIcon = icon;
        }

        @Override
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
            if (executor == null) {
                DefaultRunProfile.$$$reportNull$$$0(0);
            }
            if (env == null) {
                DefaultRunProfile.$$$reportNull$$$0(1);
            }
            JavaCommandLineState state = new JavaCommandLineState(env){

                @Override
                protected JavaParameters createJavaParameters() {
                    return myParameters;
                }
            };
            TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
            if (this.myFilters != null) {
                builder.filters(this.myFilters);
            }
            state.setConsoleBuilder(builder);
            return state;
        }

        @Override
        public String getName() {
            return this.myContentName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "env";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/JavaExecutionUtil$DefaultRunProfile";
            objectArray[2] = "getState";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

