/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.ScriptingLibraryProperties;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptingLibraryManager {
    private final Project myProject;
    private final PersistentLibraryKind myLibraryKind;
    private volatile ScriptingLibraryTable myLibTable;
    private final Object myLock;

    protected ScriptingLibraryManager(@NotNull Project project, @NotNull PersistentLibraryKind libraryKind) {
        if (project == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(0);
        }
        if (libraryKind == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myProject = project;
        this.myLibraryKind = libraryKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ScriptingLibraryTable getScriptingLibraryTable() {
        ScriptingLibraryTable libraryTable = this.myLibTable;
        if (libraryTable == null) {
            Object object = this.myLock;
            synchronized (object) {
                libraryTable = this.myLibTable;
                if (libraryTable == null) {
                    this.myLibTable = libraryTable = this.readLibraryTable();
                }
            }
        }
        ScriptingLibraryTable scriptingLibraryTable = libraryTable;
        if (scriptingLibraryTable == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(2);
        }
        return scriptingLibraryTable;
    }

    @NotNull
    private ScriptingLibraryTable readLibraryTable() {
        ScriptingLibraryTable scriptingLibraryTable = (ScriptingLibraryTable)ReadAction.compute(() -> {
            ScriptingLibraryTable libraryTable = new ScriptingLibraryTable(this.myLibraryKind, this.myProject);
            libraryTable.readFrom(this.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL));
            libraryTable.readFrom(this.getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT));
            this.initPredefinedLibraries(libraryTable);
            return libraryTable;
        });
        if (scriptingLibraryTable == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(3);
        }
        return scriptingLibraryTable;
    }

    public void commitChanges() {
        if (this.myLibTable != null) {
            this.updateLibraries(ScriptingLibraryModel.LibraryLevel.GLOBAL);
            this.updateLibraries(ScriptingLibraryModel.LibraryLevel.PROJECT);
            this.myLibTable = null;
        }
        this.getLibraryMappings().updateMappings();
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true);
    }

    private void updateLibraries(@NotNull ScriptingLibraryModel.LibraryLevel libraryLevel) {
        if (libraryLevel == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(4);
        }
        LibraryTable libTable = this.getLibraryTable(libraryLevel);
        ScriptingLibraryTable scriptingLibTable = this.getScriptingLibraryTable();
        LibraryTable.ModifiableModel libTableModel = libTable.getModifiableModel();
        for (Library library : libTableModel.getLibraries()) {
            if (!(library instanceof LibraryEx)) continue;
            PersistentLibraryKind<?> libKind = ((LibraryEx)library).getKind();
            String libraryName = library.getName();
            if (libKind != this.myLibraryKind || libraryName == null) continue;
            ScriptingLibraryModel scriptingLibModel = scriptingLibTable.getModel(library);
            if (scriptingLibModel == null) {
                this.removeLibraryAndDependencies(libTableModel, library);
                continue;
            }
            if (scriptingLibModel.getLibraryLevel() != libraryLevel) {
                scriptingLibModel.setOriginalLibrary(null);
                this.removeLibraryAndDependencies(libTableModel, library);
                continue;
            }
            Library.ModifiableModel libModel = library.getModifiableModel();
            libModel.setName(scriptingLibModel.getName());
            ScriptingLibraryManager.copyRoots(scriptingLibModel, libModel);
            libModel.commit();
            this.updateModuleDependencies(scriptingLibModel);
        }
        for (ScriptingLibraryModel scriptingLibModel : scriptingLibTable.getLibraries(libraryLevel)) {
            Library library = scriptingLibModel.getOriginalLibrary();
            if (library == null) {
                library = libTableModel.createLibrary(scriptingLibModel.getName(), this.myLibraryKind);
                scriptingLibModel.setOriginalLibrary(library);
                Library.ModifiableModel platformLibModel = library.getModifiableModel();
                ScriptingLibraryManager.copyRoots(scriptingLibModel, platformLibModel);
                platformLibModel.commit();
            }
            this.updateModuleDependencies(scriptingLibModel);
        }
        libTableModel.commit();
    }

    private static void copyRoots(ScriptingLibraryModel source, Library.ModifiableModel target) {
        for (VirtualFile libRoot : target.getFiles(OrderRootType.SOURCES)) {
            target.removeRoot(libRoot.getUrl(), OrderRootType.SOURCES);
        }
        for (VirtualFile libRoot : target.getFiles(OrderRootType.CLASSES)) {
            target.removeRoot(libRoot.getUrl(), OrderRootType.CLASSES);
        }
        List<VirtualFile> allFiles = ScriptingLibraryUtil.sortFilesByPath(source.getAllFiles());
        for (VirtualFile newRoot : allFiles) {
            target.addRoot(newRoot, OrderRootType.CLASSES);
        }
        for (String docUrl : target.getUrls(OrderRootType.DOCUMENTATION)) {
            target.removeRoot(docUrl, OrderRootType.DOCUMENTATION);
        }
        List docUrls = ContainerUtil.sorted(source.getDocUrls());
        for (String docUrl : docUrls) {
            target.addRoot(docUrl, OrderRootType.DOCUMENTATION);
        }
        if (target instanceof LibraryEx.ModifiableModelEx) {
            List urls = ContainerUtil.map(source.getSourceFiles(), VirtualFile::getUrl);
            ((LibraryEx.ModifiableModelEx)target).setProperties(new ScriptingLibraryProperties(source.getFrameworkDescriptor(), urls));
        }
    }

    private void removeLibraryAndDependencies(@NotNull LibraryTable.ModifiableModel table, @NotNull Library library) {
        if (table == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(5);
        }
        if (library == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(6);
        }
        ModuleHelper.removeDependencies(this.getProject(), library);
        table.removeLibrary(library);
    }

    private void updateModuleDependencies(@NotNull ScriptingLibraryModel libraryModel) {
        Library originalLibrary;
        if (libraryModel == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(7);
        }
        if ((originalLibrary = libraryModel.getOriginalLibrary()) == null) {
            return;
        }
        Module[] modules = ModuleManager.getInstance(this.getProject()).getModules();
        ScriptingLibraryMappings mappings = this.getLibraryMappings();
        for (Module module : modules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
            boolean hasDependency = ModuleHelper.dependencyExists(rootManager, originalLibrary);
            if (mappings.dependsOn(module, libraryModel, modules.length)) {
                if (hasDependency) continue;
                ModuleRootModificationUtil.addDependency(module, originalLibrary);
                continue;
            }
            if (!hasDependency) continue;
            ModuleHelper.removeDependency(rootManager, originalLibrary);
        }
    }

    public void reset() {
        this.myLibTable = null;
    }

    public void clearCaches() {
        if (this.myLibTable != null) {
            this.myLibTable.invalidateCache();
        }
    }

    @NotNull
    public ScriptingLibraryModel createLibrary(String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls, ScriptingLibraryModel.LibraryLevel level, boolean isOnByDefault) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel scriptingLibraryModel = libraryTable.createLibrary(name, sourceFiles, compactFiles, docUrls, level, isOnByDefault);
        if (scriptingLibraryModel == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(8);
        }
        return scriptingLibraryModel;
    }

    public void removeLibrary(ScriptingLibraryModel library) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        libraryTable.removeLibrary(library);
    }

    @Nullable
    public ScriptingLibraryModel updateLibrary(String oldName, String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel libModel = libraryTable.getLibraryByName(oldName);
        if (libModel != null) {
            libModel.setName(name);
            libModel.setSourceFiles(sourceFiles);
            libModel.setCompactFiles(compactFiles);
            libModel.setDocUrls(docUrls);
            libraryTable.renameLibrary(oldName, name);
            libraryTable.invalidateCache();
            return libModel;
        }
        return null;
    }

    @NotNull
    public ScriptingLibraryModel[] getLibraries(ScriptingLibraryModel.LibraryLevel libraryLevel) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel[] scriptingLibraryModelArray = libraryTable.getLibraries(libraryLevel);
        if (scriptingLibraryModelArray == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(9);
        }
        return scriptingLibraryModelArray;
    }

    @Nullable
    public ScriptingLibraryModel getLibraryByName(String name) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        return libraryTable.getLibraryByName(name);
    }

    @NotNull
    public LibraryTable getLibraryTable(ScriptingLibraryModel.LibraryLevel libraryLevel) {
        LibraryTable libraryTable = ScriptingLibraryManager.getLibraryTable(this.myProject, libraryLevel);
        if (libraryTable == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(10);
        }
        return libraryTable;
    }

    @NotNull
    private static LibraryTable getLibraryTable(Project project, @NotNull ScriptingLibraryModel.LibraryLevel libraryLevel) {
        if (libraryLevel == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(11);
        }
        if (libraryLevel == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
            if (libraryTable == null) {
                ScriptingLibraryManager.$$$reportNull$$$0(12);
            }
            return libraryTable;
        }
        if (libraryLevel == ScriptingLibraryModel.LibraryLevel.PROJECT) {
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
            if (libraryTable == null) {
                ScriptingLibraryManager.$$$reportNull$$$0(13);
            }
            return libraryTable;
        }
        throw new RuntimeException("Unexpected libraryLevel: " + (Object)((Object)libraryLevel));
    }

    private static void collectLibraryFiles(@NotNull Collection<VirtualFile> collectedFiles, Project project, LibraryKind libraryKind, ScriptingLibraryModel.LibraryLevel level) {
        if (collectedFiles == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(14);
        }
        LibraryTable libraryTable = ScriptingLibraryManager.getLibraryTable(project, level);
        for (Library library : libraryTable.getLibraries()) {
            LibraryEx libraryEx;
            if (!(library instanceof LibraryEx) || (libraryEx = (LibraryEx)library).isDisposed() || libraryEx.getKind() != libraryKind) continue;
            collectedFiles.addAll(Arrays.asList(libraryEx.getFiles(OrderRootType.SOURCES)));
            collectedFiles.addAll(Arrays.asList(libraryEx.getFiles(OrderRootType.CLASSES)));
        }
    }

    public static Set<VirtualFile> getAllLibraryFiles(Project project, LibraryKind libraryKind) {
        return (Set)ReadAction.compute(() -> {
            HashSet collectedFiles = new HashSet();
            ScriptingLibraryManager.collectLibraryFiles((Collection<VirtualFile>)collectedFiles, project, libraryKind, ScriptingLibraryModel.LibraryLevel.GLOBAL);
            ScriptingLibraryManager.collectLibraryFiles((Collection<VirtualFile>)collectedFiles, project, libraryKind, ScriptingLibraryModel.LibraryLevel.PROJECT);
            return collectedFiles;
        });
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(15);
        }
        return project;
    }

    public ThreeState getFileState(VirtualFile file) {
        return this.getScriptingLibraryTable().getFileState(file);
    }

    @Nullable
    public VirtualFile getMatchingFile(String fileName) {
        return this.getScriptingLibraryTable().findProjectOrGlobalLibraryFileByName(fileName);
    }

    public boolean isLibraryFile(VirtualFile file) {
        return this.getFileState(file) != ThreeState.UNSURE;
    }

    @NotNull
    public Set<String> getDocUrlsFor(@NotNull VirtualFile file) {
        if (file == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(16);
        }
        Set<String> set = this.getScriptingLibraryTable().getDocUrlsFor(file);
        if (set == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(17);
        }
        return set;
    }

    protected abstract void initPredefinedLibraries(@NotNull ScriptingLibraryTable var1);

    @NotNull
    public Set<VirtualFile> getPredefinedLibraryFiles() {
        HashSet predefinedFiles = new HashSet();
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        for (ScriptingLibraryModel libModel : libraryTable.getLibraries(ScriptingLibraryModel.LibraryLevel.PREDEFINED)) {
            predefinedFiles.addAll(libModel.getSourceFiles());
        }
        HashSet hashSet = predefinedFiles;
        if (hashSet == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries() {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel[] scriptingLibraryModelArray = libraryTable.getLibraries(ScriptingLibraryModel.LibraryLevel.PREDEFINED);
        if (scriptingLibraryModelArray == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(19);
        }
        return scriptingLibraryModelArray;
    }

    @NotNull
    public ScriptingLibraryModel[] getAllLibraries() {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel[] scriptingLibraryModelArray = libraryTable.getAllLibraries();
        if (scriptingLibraryModelArray == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(20);
        }
        return scriptingLibraryModelArray;
    }

    @NotNull
    static ScriptingLibraryModel.LibraryLevel getLibraryLevel(LibraryTable libraryTable) {
        if (libraryTable.getTableLevel() == "project") {
            ScriptingLibraryModel.LibraryLevel libraryLevel = ScriptingLibraryModel.LibraryLevel.PROJECT;
            if (libraryLevel == null) {
                ScriptingLibraryManager.$$$reportNull$$$0(21);
            }
            return libraryLevel;
        }
        if (libraryTable.getTableLevel() == "application") {
            ScriptingLibraryModel.LibraryLevel libraryLevel = ScriptingLibraryModel.LibraryLevel.GLOBAL;
            if (libraryLevel == null) {
                ScriptingLibraryManager.$$$reportNull$$$0(22);
            }
            return libraryLevel;
        }
        throw new RuntimeException("Unexpected library table: " + libraryTable.getTableLevel());
    }

    @NotNull
    public abstract ScriptingLibraryMappings getLibraryMappings();

    public void associateWithProject(String libraryName) {
        ScriptingLibraryTable libTable = this.getScriptingLibraryTable();
        assert (libTable.getLibraryByName(libraryName) != null) : "Library '" + libraryName + "' not found";
        ScriptingLibraryMappings mappings = this.getLibraryMappings();
        mappings.associateWithProject(libraryName);
    }

    @Nullable
    public ScriptingLibraryModel findLibrary(@NotNull VirtualFile file) {
        if (file == null) {
            ScriptingLibraryManager.$$$reportNull$$$0(23);
        }
        return this.getScriptingLibraryTable().findLibrary(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryKind";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryManager";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryLevel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryModel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedFiles";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptingLibraryTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readLibraryTable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryTable";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocUrlsFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraries";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateLibraries";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeLibraryAndDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateModuleDependencies";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectLibraryFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDocUrlsFor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

