/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.tools.idea.gradle.filters.AndroidReRunBuildFilter;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.build.output.JavacOutputParser;
import com.intellij.build.output.KotlincOutputParser;
import com.intellij.execution.filters.Filter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class GradleBuildInvoker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleTasksExecutor.Factory myTaskExecutorFactory;
    @NotNull
    private final Set<AfterGradleInvocationTask> myAfterTasks;
    @NotNull
    private final List<String> myOneTimeGradleOptions;
    @NotNull
    private final Multimap<String, String> myLastBuildTasks;
    @NotNull
    private final BuildStopper myBuildStopper;

    public static GradleBuildInvoker getInstance(@NotNull Project project) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(0);
        }
        return (GradleBuildInvoker)ServiceManager.getService((Project)project, GradleBuildInvoker.class);
    }

    public GradleBuildInvoker(@NotNull Project project) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(1);
        }
        this(project, new GradleTasksExecutor.Factory());
    }

    @VisibleForTesting
    GradleBuildInvoker(@NotNull Project project, @NotNull GradleTasksExecutor.Factory tasksExecutorFactory) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(2);
        }
        if (tasksExecutorFactory == null) {
            GradleBuildInvoker.$$$reportNull$$$0(3);
        }
        this.myAfterTasks = new LinkedHashSet<AfterGradleInvocationTask>();
        this.myOneTimeGradleOptions = new ArrayList<String>();
        this.myLastBuildTasks = ArrayListMultimap.create();
        this.myBuildStopper = new BuildStopper();
        this.myProject = project;
        this.myTaskExecutorFactory = tasksExecutorFactory;
    }

    public void cleanProject() {
        this.setProjectBuildMode(BuildMode.CLEAN);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleBuildInvoker.findTasksToExecute(moduleManager.getModules(), BuildMode.SOURCE_GEN, TestCompileType.NONE);
        tasks.keys().elementSet().forEach(key -> tasks.get(key).add(0, "clean"));
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
        }
    }

    public void assembleTranslate() {
        this.setProjectBuildMode(BuildMode.ASSEMBLE_TRANSLATE);
        HashSet rootPaths = Sets.newHashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            String gradlePath = GradleBuildInvoker.getGradleProjectPath(module);
            if (StringUtil.isEmpty((String)gradlePath)) continue;
            rootPaths.add(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
        }
        for (String rootPath : rootPaths) {
            this.executeTasks(new File(rootPath), Collections.singletonList("assembleTranslate"));
        }
    }

    public void generateSources(boolean cleanProject) {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleBuildInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        if (cleanProject) {
            tasks.keys().elementSet().forEach(key -> tasks.get(key).add(0, "clean"));
        }
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
        }
    }

    @NotNull
    private static String createGenerateSourcesOnlyProperty() {
        String string = AndroidGradleSettings.createProjectProperty((String)"android.injected.generateSourcesOnly", (boolean)true);
        if (string == null) {
            GradleBuildInvoker.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void compileJava(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(5);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(6);
        }
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleBuildInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(7);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(8);
        }
        this.assemble(modules, testCompileType, Collections.emptyList());
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @NotNull List<String> arguments) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(9);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(10);
        }
        if (arguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(11);
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleBuildInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), arguments);
        }
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleBuildInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildWithTempOptions(@NotNull File buildFilePath, @NotNull List<String> options) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(12);
        }
        if (options == null) {
            GradleBuildInvoker.$$$reportNull$$$0(13);
        }
        this.myOneTimeGradleOptions.addAll(options);
        try {
            Collection tasks = this.myLastBuildTasks.get((Object)buildFilePath.getPath());
            if (tasks.isEmpty()) {
                this.rebuild();
            } else {
                ArrayList<String> tasksFromLastBuild = new ArrayList<String>();
                tasksFromLastBuild.addAll(tasks);
                this.executeTasks(buildFilePath, tasksFromLastBuild);
            }
        }
        finally {
            this.myOneTimeGradleOptions.clear();
        }
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            GradleBuildInvoker.$$$reportNull$$$0(14);
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    @NotNull
    public static ListMultimap<Path, String> findCleanTasksForModules(@NotNull Module[] modules) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(15);
        }
        ArrayListMultimap tasks = ArrayListMultimap.create();
        for (Module module : modules) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            String gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
            String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
            if (StringUtil.isEmpty((String)rootProjectPath)) continue;
            GradleBuildInvoker.addTaskIfSpecified(tasks.get((Object)Paths.get(rootProjectPath, new String[0])), gradlePath, "clean");
        }
        ArrayListMultimap arrayListMultimap = tasks;
        if (arrayListMultimap == null) {
            GradleBuildInvoker.$$$reportNull$$$0(16);
        }
        return arrayListMultimap;
    }

    @NotNull
    public static ListMultimap<Path, String> findTasksToExecute(@NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        Project project;
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(17);
        }
        if (buildMode == null) {
            GradleBuildInvoker.$$$reportNull$$$0(18);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(19);
        }
        ArrayListMultimap tasks = ArrayListMultimap.create();
        if (BuildMode.ASSEMBLE == buildMode && GradleSyncState.getInstance(project = modules[0].getProject()).lastSyncFailed()) {
            ((StreamEx)StreamEx.of((Object[])modules).map(module -> ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)).nonNull().distinct()).map(path -> Paths.get(path, new String[0])).forEach(arg_0 -> GradleBuildInvoker.lambda$findTasksToExecute$4((ListMultimap)tasks, arg_0));
            ArrayListMultimap arrayListMultimap = tasks;
            if (arrayListMultimap == null) {
                GradleBuildInvoker.$$$reportNull$$$0(20);
            }
            return arrayListMultimap;
        }
        for (Project module2 : modules) {
            String rootProjectPath;
            if ("buildSrc".equals(module2.getName()) || StringUtil.isEmpty((String)(rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2)))) continue;
            List<String> moduleTasks = GradleBuildInvoker.findGradleBuildTasks((Module)module2, buildMode, testCompileType);
            tasks.putAll((Object)Paths.get(rootProjectPath, new String[0]), moduleTasks);
        }
        if (buildMode == BuildMode.REBUILD && !tasks.isEmpty()) {
            tasks.keys().elementSet().forEach(arg_0 -> GradleBuildInvoker.lambda$findTasksToExecute$5((ListMultimap)tasks, arg_0));
        }
        if (tasks.isEmpty()) {
            String format = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            GradleBuildInvoker.getLogger().info(String.format(format, modules[0].getProject().getName(), buildMode.name()));
        }
        ArrayListMultimap arrayListMultimap = tasks;
        if (arrayListMultimap == null) {
            GradleBuildInvoker.$$$reportNull$$$0(21);
        }
        return arrayListMultimap;
    }

    public void executeTasks(@NotNull List<String> gradleTasks) {
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(22);
        }
        File path = Projects.getBaseDirPath(this.myProject);
        this.executeTasks(path, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(23);
        }
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(24);
        }
        this.executeTasks(buildFilePath, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull ListMultimap<Path, String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) {
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(25);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(26);
        }
        if (buildMode != null) {
            this.setProjectBuildMode(buildMode);
        }
        tasks.keys().elementSet().forEach(path -> {
            if (tasks == null) {
                GradleBuildInvoker.$$$reportNull$$$0(64);
            }
            if (commandLineArguments == null) {
                GradleBuildInvoker.$$$reportNull$$$0(65);
            }
            this.executeTasks(path.toFile(), tasks.get(path), commandLineArguments);
        });
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(27);
        }
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(28);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(29);
        }
        ArrayList<String> jvmArguments = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            File androidHomePath;
            LocalProperties localProperties;
            try {
                localProperties = new LocalProperties(this.myProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                jvmArguments.add(AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHomePath.getPath()));
            }
        }
        Request request = new Request(this.myProject, buildFilePath, gradleTasks);
        ExternalSystemTaskNotificationListener buildTaskListener = this.createBuildTaskListener(request, "Build");
        request.setJvmArguments(jvmArguments).setCommandLineArguments(commandLineArguments).setTaskListener(buildTaskListener);
        this.executeTasks(request);
    }

    @NotNull
    public ExternalSystemTaskNotificationListener createBuildTaskListener(final @NotNull Request request, final String executionName) {
        if (request == null) {
            GradleBuildInvoker.$$$reportNull$$$0(30);
        }
        final BuildViewManager buildViewManager = (BuildViewManager)ServiceManager.getService((Project)this.myProject, BuildViewManager.class);
        ArrayList buildOutputParsers = Lists.newArrayList((Object[])new BuildOutputParser[]{new JavacOutputParser(), new KotlincOutputParser()});
        final BuildOutputInstantReaderImpl buildOutputInstantReader = new BuildOutputInstantReaderImpl((Object)request.myTaskId, (BuildProgressListener)buildViewManager, (List)buildOutputParsers);
        ExternalSystemTaskNotificationListenerAdapter externalSystemTaskNotificationListenerAdapter = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStart(final @NotNull ExternalSystemTaskId id, String workingDir) {
                if (id == null) {
                    1.$$$reportNull$$$0(0);
                }
                AnAction restartAction = new AnAction(){

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.update(e);
                        Presentation p = e.getPresentation();
                        p.setEnabled(!GradleBuildInvoker.this.myBuildStopper.contains(id));
                    }

                    public void actionPerformed(AnActionEvent e) {
                        GradleBuildInvoker.this.executeTasks(request);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$1$1", "update"));
                    }
                };
                restartAction.getTemplatePresentation().setText("Restart");
                restartAction.getTemplatePresentation().setDescription("Restart");
                restartAction.getTemplatePresentation().setIcon(AllIcons.Actions.Compile);
                long eventTime = System.currentTimeMillis();
                buildViewManager.onEvent((BuildEvent)new StartBuildEventImpl((BuildDescriptor)new DefaultBuildDescriptor((Object)id, executionName, workingDir, eventTime), "running...").withRestartAction(restartAction).withExecutionFilter((Filter)new AndroidReRunBuildFilter(workingDir)));
            }

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event instanceof ExternalSystemTaskExecutionEvent) {
                    BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)((ExternalSystemTaskExecutionEvent)event));
                    buildViewManager.onEvent(buildEvent);
                }
            }

            public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
                if (id == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(3);
                }
                buildViewManager.onEvent((BuildEvent)new OutputBuildEventImpl((Object)id, text, stdOut));
                buildOutputInstantReader.append((CharSequence)text);
            }

            public void onEnd(@NotNull ExternalSystemTaskId id) {
                if (id == null) {
                    1.$$$reportNull$$$0(4);
                }
                buildOutputInstantReader.close();
            }

            public void onSuccess(@NotNull ExternalSystemTaskId id) {
                if (id == null) {
                    1.$$$reportNull$$$0(5);
                }
                buildViewManager.onEvent((BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "completed successfully", (EventResult)new SuccessResultImpl()));
            }

            public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                if (id == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(7);
                }
                String title = executionName + " failed";
                FailureResult failureResult = ExternalSystemUtil.createFailureResult((String)title, (Exception)e, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (Project)GradleBuildInvoker.this.myProject);
                buildViewManager.onEvent((BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "build failed", (EventResult)failureResult));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStart";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStatusChange";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTaskOutput";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEnd";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccess";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFailure";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (externalSystemTaskNotificationListenerAdapter == null) {
            GradleBuildInvoker.$$$reportNull$$$0(31);
        }
        return externalSystemTaskNotificationListenerAdapter;
    }

    public void executeTasks(@NotNull Request request) {
        if (request == null) {
            GradleBuildInvoker.$$$reportNull$$$0(32);
        }
        String buildFilePath = request.myBuildFilePath.getPath();
        this.myLastBuildTasks.removeAll((Object)buildFilePath);
        List<String> gradleTasks = request.getGradleTasks();
        this.myLastBuildTasks.putAll((Object)buildFilePath, gradleTasks);
        GradleBuildInvoker.getLogger().info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        GradleTasksExecutor executor = this.myTaskExecutorFactory.create(request, this.myBuildStopper);
        GradleBuildInvoker.saveAllFilesSafely();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            executor.queue();
        } else if (request.isWaitForCompletion()) {
            executor.queueAndWaitForCompletion();
        } else {
            UIUtil.invokeAndWaitIfNeeded(() -> ((GradleTasksExecutor)executor).queue());
        }
    }

    public static void saveAllFilesSafely() {
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments()));
    }

    @Nullable
    private static String getGradleProjectPath(@NotNull Module module) {
        GradleFacet gradleFacet;
        if (module == null) {
            GradleBuildInvoker.$$$reportNull$$$0(33);
        }
        if ((gradleFacet = GradleFacet.getInstance(module)) == null) {
            return null;
        }
        String gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
        if (StringUtil.isEmpty((String)gradlePath)) {
            String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module.getName());
            GradleBuildInvoker.getLogger().info(msg);
            return null;
        }
        return gradlePath;
    }

    @NotNull
    private static List<String> findGradleBuildTasks(@NotNull Module module, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        ArrayList tasks;
        block18: {
            String gradlePath;
            block17: {
                if (module == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(34);
                }
                if (buildMode == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(35);
                }
                if (testCompileType == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(36);
                }
                tasks = Lists.newArrayList();
                gradlePath = GradleBuildInvoker.getGradleProjectPath(module);
                if (StringUtil.isEmpty((String)gradlePath)) {
                    ArrayList arrayList = tasks;
                    if (arrayList == null) {
                        GradleBuildInvoker.$$$reportNull$$$0(37);
                    }
                    return arrayList;
                }
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) break block17;
                JpsAndroidModuleProperties properties = androidFacet.getProperties();
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                switch (buildMode) {
                    case CLEAN: 
                    case SOURCE_GEN: {
                        GradleBuildInvoker.addAfterSyncTasks(tasks, gradlePath, properties);
                        GradleBuildInvoker.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                        break;
                    }
                    case ASSEMBLE: {
                        tasks.add(GradleBuildInvoker.createBuildTask(gradlePath, properties.ASSEMBLE_TASK_NAME));
                        if (testCompileType != TestCompileType.NONE) {
                            for (BaseArtifact artifact : GradleBuildInvoker.getArtifactsForTestCompileType(testCompileType, androidModel)) {
                                GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, artifact.getAssembleTaskName());
                            }
                        }
                        break block18;
                    }
                    default: {
                        GradleBuildInvoker.addAfterSyncTasks(tasks, gradlePath, properties);
                        GradleBuildInvoker.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                        if (testCompileType != TestCompileType.UNIT_TESTS) {
                            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, properties.COMPILE_JAVA_TASK_NAME);
                        }
                        for (BaseArtifact artifact : GradleBuildInvoker.getArtifactsForTestCompileType(testCompileType, androidModel)) {
                            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, artifact.getCompileTaskName());
                        }
                        break block18;
                    }
                }
                break block18;
            }
            JavaFacet javaFacet = JavaFacet.getInstance(module);
            if (javaFacet != null && ((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
                String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
                if (gradleTaskName != null) {
                    tasks.add(GradleBuildInvoker.createBuildTask(gradlePath, gradleTaskName));
                }
                if (testCompileType == TestCompileType.UNIT_TESTS) {
                    tasks.add(GradleBuildInvoker.createBuildTask(gradlePath, "testClasses"));
                }
            }
        }
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            GradleBuildInvoker.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(GradleBuildInvoker.class);
        if (logger == null) {
            GradleBuildInvoker.$$$reportNull$$$0(39);
        }
        return logger;
    }

    private static void addAfterSyncTasksForTestArtifacts(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull TestCompileType testCompileType, @Nullable AndroidModuleModel androidModel) {
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(40);
        }
        if (gradlePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(41);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(42);
        }
        Collection<BaseArtifact> testArtifacts = GradleBuildInvoker.getArtifactsForTestCompileType(testCompileType, androidModel);
        for (BaseArtifact artifact : testArtifacts) {
            for (String taskName : AndroidModuleModel.getIdeSetupTasks(artifact)) {
                GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, taskName);
            }
        }
    }

    @NotNull
    private static Collection<BaseArtifact> getArtifactsForTestCompileType(@NotNull TestCompileType testCompileType, @Nullable AndroidModuleModel androidModel) {
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(43);
        }
        if (androidModel == null) {
            List<BaseArtifact> list = Collections.emptyList();
            if (list == null) {
                GradleBuildInvoker.$$$reportNull$$$0(44);
            }
            return list;
        }
        AndroidArtifact testArtifact = null;
        switch (testCompileType) {
            case NONE: {
                Collection<BaseArtifact> collection = androidModel.getTestArtifactsInSelectedVariant();
                if (collection == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(45);
                }
                return collection;
            }
            case ANDROID_TESTS: {
                testArtifact = androidModel.getAndroidTestArtifactInSelectedVariant();
                break;
            }
            case UNIT_TESTS: {
                testArtifact = androidModel.getUnitTestArtifactInSelectedVariant();
            }
        }
        ImmutableList immutableList = testArtifact != null ? ImmutableList.of((Object)testArtifact) : Collections.emptyList();
        if (immutableList == null) {
            GradleBuildInvoker.$$$reportNull$$$0(46);
        }
        return immutableList;
    }

    private static void addAfterSyncTasks(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull JpsAndroidModuleProperties properties) {
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(47);
        }
        if (gradlePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(48);
        }
        if (properties == null) {
            GradleBuildInvoker.$$$reportNull$$$0(49);
        }
        for (String taskName : properties.AFTER_SYNC_TASK_NAMES) {
            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private static void addTaskIfSpecified(@NotNull List<String> tasks, @NotNull String gradlePath, @Nullable String gradleTaskName) {
        String buildTask;
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(50);
        }
        if (gradlePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(51);
        }
        if (StringUtil.isNotEmpty((String)gradleTaskName) && !tasks.contains(buildTask = GradleBuildInvoker.createBuildTask(gradlePath, gradleTaskName))) {
            tasks.add(buildTask);
        }
    }

    @NotNull
    public static String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(52);
        }
        if (taskName == null) {
            GradleBuildInvoker.$$$reportNull$$$0(53);
        }
        if (gradleProjectPath.equals(":")) {
            String string = gradleProjectPath + taskName;
            if (string == null) {
                GradleBuildInvoker.$$$reportNull$$$0(54);
            }
            return string;
        }
        String string = gradleProjectPath + ":" + taskName;
        if (string == null) {
            GradleBuildInvoker.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    public static TestCompileType getTestCompileType(@Nullable String runConfigurationId) {
        if (runConfigurationId != null) {
            if (AndroidCommonUtils.isInstrumentationTestConfiguration((String)runConfigurationId)) {
                TestCompileType testCompileType = TestCompileType.ANDROID_TESTS;
                if (testCompileType == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(56);
                }
                return testCompileType;
            }
            if (AndroidCommonUtils.isTestConfiguration((String)runConfigurationId)) {
                TestCompileType testCompileType = TestCompileType.UNIT_TESTS;
                if (testCompileType == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(57);
                }
                return testCompileType;
            }
        }
        TestCompileType testCompileType = TestCompileType.NONE;
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(58);
        }
        return testCompileType;
    }

    public boolean stopBuild(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            GradleBuildInvoker.$$$reportNull$$$0(59);
        }
        if (this.myBuildStopper.contains(id)) {
            this.myBuildStopper.attemptToStopBuild(id, null);
            return true;
        }
        return false;
    }

    public void add(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            GradleBuildInvoker.$$$reportNull$$$0(60);
        }
        this.myAfterTasks.add(task);
    }

    @NotNull
    AfterGradleInvocationTask[] getAfterInvocationTasks() {
        AfterGradleInvocationTask[] afterGradleInvocationTaskArray = this.myAfterTasks.toArray(new AfterGradleInvocationTask[this.myAfterTasks.size()]);
        if (afterGradleInvocationTaskArray == null) {
            GradleBuildInvoker.$$$reportNull$$$0(61);
        }
        return afterGradleInvocationTaskArray;
    }

    public void remove(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            GradleBuildInvoker.$$$reportNull$$$0(62);
        }
        this.myAfterTasks.remove(task);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(63);
        }
        return project;
    }

    private static /* synthetic */ void lambda$findTasksToExecute$5(ListMultimap tasks, Path key) {
        tasks.get((Object)key).add(0, "clean");
    }

    private static /* synthetic */ void lambda$findTasksToExecute$4(ListMultimap tasks, Path path) {
        tasks.put((Object)path, (Object)"assemble");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksExecutorFactory";
                break;
            }
            case 4: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 19: 
            case 36: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCompileType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 12: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFilePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 14: 
            case 18: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
            case 22: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleTasks";
                break;
            }
            case 25: 
            case 40: 
            case 47: 
            case 50: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 26: 
            case 29: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 41: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectPath";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateSourcesOnlyProperty";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findCleanTasksForModules";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksToExecute";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildTaskListener";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findGradleBuildTasks";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsForTestCompileType";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildTask";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCompileType";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterInvocationTasks";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 63: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compileJava";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assemble";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rebuildWithTempOptions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setProjectBuildMode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findCleanTasksForModules";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findTasksToExecute";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "executeTasks";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTaskListener";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getGradleProjectPath";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findGradleBuildTasks";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasksForTestArtifacts";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactsForTestCompileType";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasks";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addTaskIfSpecified";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTask";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "stopBuild";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeTasks$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        @NotNull
        private final Project myProject;
        @NotNull
        private final File myBuildFilePath;
        @NotNull
        private final List<String> myGradleTasks;
        @NotNull
        private final List<String> myJvmArguments;
        @NotNull
        private final List<String> myCommandLineArguments;
        @NotNull
        private final Map<String, String> myEnv;
        private boolean myPassParentEnvs;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @Nullable
        private ExternalSystemTaskNotificationListener myTaskListener;
        private boolean myWaitForCompletion;
        private boolean myUseEmbeddedGradle;

        public Request(@NotNull Project project, @NotNull File buildFilePath, String ... gradleTasks) {
            if (project == null) {
                Request.$$$reportNull$$$0(0);
            }
            if (buildFilePath == null) {
                Request.$$$reportNull$$$0(1);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(2);
            }
            this(project, buildFilePath, Arrays.asList(gradleTasks));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
            if (project == null) {
                Request.$$$reportNull$$$0(3);
            }
            if (buildFilePath == null) {
                Request.$$$reportNull$$$0(4);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(5);
            }
            this(project, buildFilePath, gradleTasks, ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull ExternalSystemTaskId taskId) {
            if (project == null) {
                Request.$$$reportNull$$$0(6);
            }
            if (buildFilePath == null) {
                Request.$$$reportNull$$$0(7);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(8);
            }
            if (taskId == null) {
                Request.$$$reportNull$$$0(9);
            }
            this.myPassParentEnvs = true;
            this.myProject = project;
            this.myBuildFilePath = buildFilePath;
            this.myGradleTasks = new ArrayList<String>(gradleTasks);
            this.myJvmArguments = new ArrayList<String>();
            this.myCommandLineArguments = new ArrayList<String>();
            this.myTaskId = taskId;
            this.myEnv = new LinkedHashMap<String, String>();
        }

        @NotNull
        Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                Request.$$$reportNull$$$0(10);
            }
            return project;
        }

        @NotNull
        List<String> getGradleTasks() {
            List<String> list = this.myGradleTasks;
            if (list == null) {
                Request.$$$reportNull$$$0(11);
            }
            return list;
        }

        @NotNull
        List<String> getJvmArguments() {
            List<String> list = this.myJvmArguments;
            if (list == null) {
                Request.$$$reportNull$$$0(12);
            }
            return list;
        }

        @NotNull
        public Request setJvmArguments(@NotNull List<String> jvmArguments) {
            if (jvmArguments == null) {
                Request.$$$reportNull$$$0(13);
            }
            this.myJvmArguments.clear();
            this.myJvmArguments.addAll(jvmArguments);
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(14);
            }
            return request;
        }

        @NotNull
        List<String> getCommandLineArguments() {
            List<String> list = this.myCommandLineArguments;
            if (list == null) {
                Request.$$$reportNull$$$0(15);
            }
            return list;
        }

        @NotNull
        public Request setCommandLineArguments(@NotNull List<String> commandLineArguments) {
            if (commandLineArguments == null) {
                Request.$$$reportNull$$$0(16);
            }
            this.myCommandLineArguments.clear();
            this.myCommandLineArguments.addAll(commandLineArguments);
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(17);
            }
            return request;
        }

        public Request withEnvironmentVariables(Map<String, String> envs) {
            this.myEnv.putAll(envs);
            return this;
        }

        public Map<String, String> getEnv() {
            return Collections.unmodifiableMap(this.myEnv);
        }

        public Request passParentEnvs(boolean passParentEnvs) {
            this.myPassParentEnvs = passParentEnvs;
            return this;
        }

        public boolean isPassParentEnvs() {
            return this.myPassParentEnvs;
        }

        @Nullable
        public ExternalSystemTaskNotificationListener getTaskListener() {
            return this.myTaskListener;
        }

        @NotNull
        public Request setTaskListener(@Nullable ExternalSystemTaskNotificationListener taskListener) {
            this.myTaskListener = taskListener;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(18);
            }
            return request;
        }

        @NotNull
        ExternalSystemTaskId getTaskId() {
            ExternalSystemTaskId externalSystemTaskId = this.myTaskId;
            if (externalSystemTaskId == null) {
                Request.$$$reportNull$$$0(19);
            }
            return externalSystemTaskId;
        }

        @NotNull
        File getBuildFilePath() {
            File file = this.myBuildFilePath;
            if (file == null) {
                Request.$$$reportNull$$$0(20);
            }
            return file;
        }

        boolean isWaitForCompletion() {
            return this.myWaitForCompletion;
        }

        @NotNull
        public Request setWaitForCompletion(boolean waitForCompletion) {
            this.myWaitForCompletion = waitForCompletion;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(21);
            }
            return request;
        }

        boolean isUseEmbeddedGradle() {
            return this.myUseEmbeddedGradle;
        }

        @NotNull
        public Request setUseEmbeddedGradle(boolean useEmbeddedGradle) {
            this.myUseEmbeddedGradle = useEmbeddedGradle;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(22);
            }
            return request;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.myBuildFilePath, that.myBuildFilePath) && Objects.equals(this.myGradleTasks, that.myGradleTasks) && Objects.equals(this.myJvmArguments, that.myJvmArguments) && Objects.equals(this.myCommandLineArguments, that.myCommandLineArguments);
        }

        public int hashCode() {
            return Objects.hash(this.myBuildFilePath, this.myGradleTasks, this.myJvmArguments, this.myCommandLineArguments);
        }

        public String toString() {
            return "RequestSettings{myBuildFilePath=" + this.myBuildFilePath + ", myGradleTasks=" + this.myGradleTasks + ", myJvmArguments=" + this.myJvmArguments + ", myCommandLineArguments=" + this.myCommandLineArguments + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildFilePath";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleTasks";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jvmArguments";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleTasks";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJvmArguments";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setJvmArguments";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandLineArguments";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCommandLineArguments";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTaskListener";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskId";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildFilePath";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setWaitForCompletion";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setUseEmbeddedGradle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setJvmArguments";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "setCommandLineArguments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }

    public static enum TestCompileType {
        NONE,
        ANDROID_TESTS,
        UNIT_TESTS;

    }
}

