/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.subset;

import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeModuleForFileAction
extends AnAction {
    public IncludeModuleForFileAction() {
        super("Find and Add Module");
    }

    public void update(AnActionEvent e) {
        boolean show = false;
        VirtualFile file = null;
        Project project = e.getProject();
        if (project != null && (file = IncludeModuleForFileAction.findTarget(e, project)) != null) {
            show = !ProjectRootsUtil.isInSource((VirtualFile)file, (Project)project);
        }
        Presentation presentation = e.getPresentation();
        presentation.setVisible(show);
        if (file != null) {
            String type = file.isDirectory() ? "Directory" : "File";
            presentation.setText(String.format("Find and Add Module Containing Selected %1$s as Source", type));
        }
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile file;
        Project project = e.getProject();
        if (project != null && (file = IncludeModuleForFileAction.findTarget(e, project)) != null) {
            ProjectSubset.getInstance(project).findAndIncludeModuleContainingSourceFile(file);
        }
    }

    @Nullable
    private static VirtualFile findTarget(@NotNull AnActionEvent e, @NotNull Project project) {
        VirtualFile[] virtualFiles;
        if (e == null) {
            IncludeModuleForFileAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            IncludeModuleForFileAction.$$$reportNull$$$0(1);
        }
        if ((virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext())) != null && virtualFiles.length == 1) {
            VirtualFile target = virtualFiles[0];
            if (ProjectRootsUtil.isModuleSourceRoot((VirtualFile)target, (Project)project) || project.getBaseDir().equals(target)) {
                return null;
            }
            ProjectFileIndex projectIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            if (projectIndex.isExcluded(target)) {
                return null;
            }
            return target;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/gradle/project/subset/IncludeModuleForFileAction";
        objectArray[2] = "findTarget";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

