/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.tool;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.monitor.tool.StudioProfilerDeviceManager;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidMonitorToolWindow
implements Disposable {
    @NotNull
    private final JPanel myComponent;
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Project myProject;

    public AndroidMonitorToolWindow(@NotNull Project project) {
        if (project == null) {
            AndroidMonitorToolWindow.$$$reportNull$$$0(0);
        }
        try {
            this.myProject = project;
            StudioProfilerDeviceManager manager = new StudioProfilerDeviceManager(project);
            this.myProfilers = new StudioProfilers(manager.getClient());
            this.myProfilers.setPreferredProcessName(this.getPreferredProcessName(project));
            StudioProfilersView view = new StudioProfilersView(this.myProfilers);
            this.myComponent = view.getComponent();
            this.myProfilers.addDependency().setExecutor(arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0)).onChange((Enum)ProfilerAspect.MODE, this::updateToolWindow).onChange((Enum)ProfilerAspect.STAGE, this::updateToolWindow);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void updateToolWindow() {
        boolean maximize;
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow window = manager.getToolWindow("Android Profiler");
        boolean bl = maximize = this.myProfilers.getMode() == ProfilerMode.EXPANDED;
        if (maximize != manager.isMaximized(window)) {
            manager.setMaximized(window, maximize);
        }
    }

    public void dispose() {
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    @Nullable
    private String getPreferredProcessName(Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(module);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/tool/AndroidMonitorToolWindow", "<init>"));
    }
}

