/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.IconPickerDialog;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VectorIconButton
extends JButton
implements AssetComponent<VectorAsset>,
Disposable {
    private final VectorAsset myXmlAsset = new VectorAsset(VectorAsset.FileType.VECTOR_DRAWABLE);
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myAssetListeners = Lists.newArrayListWithExpectedSize((int)1);
    @Nullable
    private VdIcon myIcon;

    public VectorIconButton() {
        this.addActionListener(actionEvent -> {
            IconPickerDialog iconPicker = new IconPickerDialog(this.myIcon);
            if (iconPicker.showAndGet()) {
                VdIcon selectedIcon = iconPicker.getSelectedIcon();
                assert (selectedIcon != null);
                this.updateIcon(selectedIcon);
            }
        });
        this.myXmlAsset.path().addListener(sender -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener : this.myAssetListeners) {
                listener.actionPerformed(e);
            }
        });
        this.updateIcon(IconPickerDialog.getDefaultIcon());
    }

    private void updateIcon(@NotNull VdIcon selectedIcon) {
        if (selectedIcon == null) {
            VectorIconButton.$$$reportNull$$$0(0);
        }
        this.myIcon = null;
        this.setIcon(null);
        try {
            File iconFile = new File(FileUtil.getTempDirectory(), selectedIcon.getName());
            InputStream iconStream = selectedIcon.getURL().openStream();
            FileOutputStream outputStream = new FileOutputStream(iconFile);
            FileUtil.copy((InputStream)iconStream, (OutputStream)outputStream);
            this.myXmlAsset.path().set(iconFile);
            int h = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
            VectorAsset.ParseResult result = this.myXmlAsset.parse(h, false);
            BufferedImage image = result.getImage();
            image = VdIcon.adjustIconColor((Component)this, (BufferedImage)image);
            this.setIcon(new ImageIcon(image));
            this.myIcon = selectedIcon;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public VectorAsset getAsset() {
        VectorAsset vectorAsset = this.myXmlAsset;
        if (vectorAsset == null) {
            VectorIconButton.$$$reportNull$$$0(1);
        }
        return vectorAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener l) {
        if (l == null) {
            VectorIconButton.$$$reportNull$$$0(2);
        }
        this.myAssetListeners.add(l);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myAssetListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedIcon";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/ui/VectorIconButton";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/ui/VectorIconButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateIcon";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAssetListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

