/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ReplaceTagFix
extends WriteCommandAction<Void> {
    @NotNull
    private final XmlFile myFile;
    @NotNull
    private final String myWrongTag;
    @NotNull
    private final String myRightTag;

    public ReplaceTagFix(@NotNull Project project, @NotNull XmlFile file, @NotNull String wrongTag, @NotNull String rightTag) {
        if (project == null) {
            ReplaceTagFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ReplaceTagFix.$$$reportNull$$$0(1);
        }
        if (wrongTag == null) {
            ReplaceTagFix.$$$reportNull$$$0(2);
        }
        if (rightTag == null) {
            ReplaceTagFix.$$$reportNull$$$0(3);
        }
        super(project, String.format("Replace <%1$s> with <%2$s>", wrongTag, rightTag), new PsiFile[]{file});
        this.myFile = file;
        this.myWrongTag = wrongTag;
        this.myRightTag = rightTag;
    }

    protected void run(@NotNull Result<Void> result) throws Throwable {
        Collection xmlTags;
        if (result == null) {
            ReplaceTagFix.$$$reportNull$$$0(4);
        }
        if (!(xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)this.myFile, XmlTag.class)).isEmpty()) {
            ArrayList matching = Lists.newArrayListWithExpectedSize((int)xmlTags.size());
            for (XmlTag tag : xmlTags) {
                if (!tag.getName().equals(this.myWrongTag)) continue;
                matching.add(tag);
            }
            if (!matching.isEmpty()) {
                for (XmlTag tag : matching) {
                    tag.setName(this.myRightTag);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrongTag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/rendering/ReplaceTagFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

