/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.ddmlib.IDevice;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ValidationError;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class GradleApkProvider
implements ApkProvider {
    private static final Logger LOG = Logger.getInstance(GradleApkProvider.class);
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    private final boolean myTest;

    public GradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, boolean test) {
        if (facet == null) {
            GradleApkProvider.$$$reportNull$$$0(0);
        }
        if (applicationIdProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(1);
        }
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myTest = test;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        AndroidModuleModel androidModel;
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(2);
        }
        if ((androidModel = AndroidModuleModel.get(this.myFacet)) == null) {
            LOG.warn("Android model is null. Sync might have failed");
            List<ApkInfo> list = Collections.emptyList();
            if (list == null) {
                GradleApkProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        Variant selectedVariant = androidModel.getSelectedVariant();
        ArrayList apkList = Lists.newArrayList();
        int projectType = androidModel.getProjectType();
        if (projectType == 0 || projectType == 4) {
            File apk = GradleApkProvider.getApk(selectedVariant, device);
            apkList.add(new ApkInfo(apk, this.myApplicationIdProvider.getPackageName()));
        }
        if (this.myTest) {
            AndroidArtifact testArtifactInfo = androidModel.getAndroidTestArtifactInSelectedVariant();
            if (testArtifactInfo != null) {
                AndroidArtifactOutput output = GradleUtil.getOutput(testArtifactInfo);
                File testApk = output.getMainOutputFile().getOutputFile();
                String testPackageName = this.myApplicationIdProvider.getTestPackageName();
                assert (testPackageName != null);
                apkList.add(new ApkInfo(testApk, testPackageName));
            }
            if (androidModel.getFeatures().isTestedTargetVariantsSupported()) {
                apkList.addAll(0, this.getTargetedApks(selectedVariant, device));
            }
        }
        ArrayList arrayList = apkList;
        if (arrayList == null) {
            GradleApkProvider.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static File getApk(@NotNull Variant variant, @NotNull IDevice device) throws ApkProvisionException {
        AndroidArtifact mainArtifact;
        ArrayList outputs;
        if (variant == null) {
            GradleApkProvider.$$$reportNull$$$0(5);
        }
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(6);
        }
        if ((outputs = Lists.newArrayList((Iterable)(mainArtifact = variant.getMainArtifact()).getOutputs())).isEmpty()) {
            throw new ApkProvisionException("No outputs for the main artifact of variant: " + variant.getDisplayName());
        }
        List abis = device.getAbis();
        int density = device.getDensity();
        Set variantAbiFilters = mainArtifact.getAbiFilters();
        List apkFiles = SplitOutputMatcher.computeBestOutput((List)outputs, (Collection)variantAbiFilters, (int)density, (List)abis);
        if (apkFiles.isEmpty()) {
            String message = AndroidBundle.message("deployment.failed.splitapk.nomatch", variant.getDisplayName(), outputs.size(), density, Joiner.on((String)", ").join((Iterable)abis));
            throw new ApkProvisionException(message);
        }
        File file = ((OutputFile)apkFiles.get(0)).getOutputFile();
        if (file == null) {
            GradleApkProvider.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    private List<ApkInfo> getTargetedApks(@NotNull Variant selectedVariant, @NotNull IDevice device) throws ApkProvisionException {
        if (selectedVariant == null) {
            GradleApkProvider.$$$reportNull$$$0(8);
        }
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(9);
        }
        ArrayList targetedApks = Lists.newArrayList();
        for (TestedTargetVariant testedVariant : GradleApkProvider.getTestedTargetVariants(selectedVariant)) {
            Module targetModule = (Module)ApplicationManager.getApplication().runReadAction(() -> GradleUtil.findModuleByGradlePath(this.myFacet.getModule().getProject(), testedVariant.getTargetProjectPath()));
            assert (targetModule != null);
            AndroidFacet targetFacet = AndroidFacet.getInstance(targetModule);
            if (targetFacet == null) {
                LOG.warn("Please install tested apk manually.");
                continue;
            }
            AndroidModuleModel targetAndroidModel = AndroidModuleModel.get(targetFacet);
            if (targetAndroidModel == null) {
                LOG.warn("Android model for tested module is null. Sync might have failed.");
                continue;
            }
            Variant targetVariant = targetAndroidModel.findVariantByName(testedVariant.getTargetVariant());
            if (targetVariant == null) {
                LOG.warn("Tested variant not found. Sync might have failed.");
                continue;
            }
            File targetApk = GradleApkProvider.getApk(targetVariant, device);
            targetedApks.add(new ApkInfo(targetApk, targetVariant.getMergedFlavor().getApplicationId()));
        }
        ArrayList arrayList = targetedApks;
        if (arrayList == null) {
            GradleApkProvider.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<TestedTargetVariant> getTestedTargetVariants(@NotNull Variant variant) {
        Collection collection;
        if (variant == null) {
            GradleApkProvider.$$$reportNull$$$0(11);
        }
        try {
            collection = variant.getTestedTargetVariants();
        }
        catch (UnsupportedMethodException e) {
            Logger.getInstance(GradleApkProvider.class).warn("Method 'getTestedTargetVariants' not found", (Throwable)e);
            ArrayList arrayList = Lists.newArrayList();
            if (arrayList == null) {
                GradleApkProvider.$$$reportNull$$$0(13);
            }
            return arrayList;
        }
        if (collection == null) {
            GradleApkProvider.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(this.myFacet);
        assert (androidModuleModel != null);
        if (androidModuleModel.getMainArtifact().isSigned()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleApkProvider.$$$reportNull$$$0(14);
            }
            return immutableList;
        }
        AndroidArtifactOutput output = GradleUtil.getOutput(androidModuleModel.getMainArtifact());
        String message = AndroidBundle.message("run.error.apk.not.signed", output.getMainOutputFile().getOutputFile().getName(), androidModuleModel.getSelectedVariant().getDisplayName());
        Runnable quickFix = new Runnable(){

            @Override
            public void run() {
                Module module = GradleApkProvider.this.myFacet.getModule();
                ProjectSettingsService service = ProjectSettingsService.getInstance((Project)module.getProject());
                if (service instanceof AndroidProjectSettingsService) {
                    ((AndroidProjectSettingsService)service).openSigningConfiguration(module);
                } else {
                    service.openModuleSettings(module);
                }
            }
        };
        ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(message, quickFix));
        if (immutableList == null) {
            GradleApkProvider.$$$reportNull$$$0(15);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/GradleApkProvider";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/GradleApkProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getApks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApk";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetedApks";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestedTargetVariants";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getApks";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getApk";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTargetedApks";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTestedTargetVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

