/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemTransferHandler
extends TransferHandler {
    private final DesignSurface myDesignSurface;
    private final Supplier<Palette.Item> myItemSupplier;
    private final IconPreviewFactory myIconFactory;

    public ItemTransferHandler(@NotNull DesignSurface designSurface, @NotNull Supplier<Palette.Item> itemSupplier, @NotNull IconPreviewFactory iconFactory) {
        if (designSurface == null) {
            ItemTransferHandler.$$$reportNull$$$0(0);
        }
        if (itemSupplier == null) {
            ItemTransferHandler.$$$reportNull$$$0(1);
        }
        if (iconFactory == null) {
            ItemTransferHandler.$$$reportNull$$$0(2);
        }
        this.myDesignSurface = designSurface;
        this.myItemSupplier = itemSupplier;
        this.myIconFactory = iconFactory;
    }

    @Override
    public int getSourceActions(@NotNull JComponent component) {
        if (component == null) {
            ItemTransferHandler.$$$reportNull$$$0(3);
        }
        return 3;
    }

    @Override
    @Nullable
    protected Transferable createTransferable(@NotNull JComponent component) {
        Dimension size;
        Palette.Item item;
        if (component == null) {
            ItemTransferHandler.$$$reportNull$$$0(4);
        }
        if ((item = this.myItemSupplier.get()) == null) {
            return null;
        }
        ScreenView screenView = this.myDesignSurface.getCurrentScreenView();
        if (screenView == null) {
            return null;
        }
        BufferedImage image = this.myIconFactory.renderDragImage(item, screenView);
        if (image != null) {
            size = new Dimension(image.getWidth(), image.getHeight());
            double scale = this.myDesignSurface.getScale();
            image = ImageUtils.scale(image, scale);
        } else {
            Icon icon = item.getIcon();
            image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            icon.paintIcon(component, g2, 0, 0);
            g2.dispose();
            double scale = this.myDesignSurface.getScale();
            size = new Dimension((int)((double)image.getWidth() / scale), (int)((double)image.getHeight() / scale));
        }
        this.setDragImage(image);
        this.setDragImageOffset(new Point(-image.getWidth() / 2, -image.getHeight() / 2));
        DnDTransferComponent dndComponent = new DnDTransferComponent(item.getTagName(), item.getXml(), size.width, size.height);
        return new ItemTransferable(new DnDTransferItem(dndComponent));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/palette/ItemTransferHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createTransferable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

