/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class BlueprintLayer
extends Layer {
    private static final int BACKGROUND_LINE_SPACE_PX = 2;
    private static final float[] COMPONENT_BACKGROUND_GRADIENT_FRACTIONS = new float[]{0.0f, 0.1f, 0.1001f};
    private static final Color[] COMPONENT_BACKGROUND_GRADIENT_COLORS = new Color[]{NlConstants.BLUEPRINT_COMPONENT_FG_COLOR, NlConstants.BLUEPRINT_COMPONENT_FG_COLOR, NlConstants.BLUEPRINT_COMPONENT_BG_COLOR};
    private final ScreenView myScreenView;
    private Dimension myScreenViewSize;
    private Rectangle mySizeRectangle;

    public BlueprintLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            BlueprintLayer.$$$reportNull$$$0(0);
        }
        this.myScreenViewSize = new Dimension();
        this.mySizeRectangle = new Rectangle();
        this.myScreenView = screenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        ViewHandlerManager viewHandlerManager;
        NlModel model;
        if (gc == null) {
            BlueprintLayer.$$$reportNull$$$0(1);
        }
        this.myScreenView.getSize(this.myScreenViewSize);
        this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle2D.intersect(this.mySizeRectangle, gc.getClipBounds(), this.mySizeRectangle);
        if (this.mySizeRectangle.isEmpty()) {
            return;
        }
        Graphics2D g = (Graphics2D)gc.create();
        Shape prevClip = null;
        Shape screenShape = this.myScreenView.getScreenShape();
        if (screenShape != null) {
            prevClip = g.getClip();
            g.clip(screenShape);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(NlConstants.BLUEPRINT_BG_COLOR);
        g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
        if (prevClip != null) {
            g.setClip(prevClip);
        }
        if ((model = this.myScreenView.getModel()).getComponents().size() == 0) {
            return;
        }
        NlComponent component = model.getComponents().get(0);
        if (this.drawComponent(g, component = component.getRoot(), viewHandlerManager = ViewHandlerManager.get(model.getFacet()), false)) {
            Dimension size = this.myScreenView.getSize();
            DesignSurface surface = this.myScreenView.getSurface();
            if (size.width != 0 && size.height != 0) {
                surface.repaint(this.myScreenView.getX(), this.myScreenView.getY(), size.width, size.height);
            } else {
                surface.repaint();
            }
        }
        g.dispose();
    }

    private boolean drawComponent(@NotNull Graphics2D gc, @NotNull NlComponent component, @NotNull ViewHandlerManager viewHandlerManager, boolean parentHandlesPainting) {
        if (gc == null) {
            BlueprintLayer.$$$reportNull$$$0(2);
        }
        if (component == null) {
            BlueprintLayer.$$$reportNull$$$0(3);
        }
        if (viewHandlerManager == null) {
            BlueprintLayer.$$$reportNull$$$0(4);
        }
        boolean needsRepaint = false;
        boolean handlesPainting = false;
        if (component.viewInfo != null) {
            ViewGroupHandler viewGroupHandler;
            ViewHandler handler = component.getViewHandler();
            if (handler != null && handler instanceof ViewGroupHandler && (viewGroupHandler = (ViewGroupHandler)handler).handlesPainting()) {
                if (handler.paintConstraints(this.myScreenView, gc, component)) {
                    return needsRepaint;
                }
                needsRepaint |= viewGroupHandler.drawGroup(gc, this.myScreenView, component);
                handlesPainting = true;
            }
            if (!handlesPainting && !parentHandlesPainting) {
                Graphics2D g = (Graphics2D)gc.create();
                int x = Coordinates.getSwingX(this.myScreenView, component.x);
                int y = Coordinates.getSwingY(this.myScreenView, component.y);
                int w = Coordinates.getSwingDimension(this.myScreenView, component.w);
                int h = Coordinates.getSwingDimension(this.myScreenView, component.h);
                this.drawComponentBackground(g, component);
                String name = component.getTagName();
                name = name.substring(name.lastIndexOf(46) + 1);
                Font font = NlConstants.BLUEPRINT_TEXT_FONT;
                g.setFont(font);
                g.setColor(NlConstants.BLUEPRINT_FG_COLOR);
                String id = component.getId();
                int lineHeight = g.getFontMetrics().getHeight();
                FontRenderContext fontRenderContext = g.getFontRenderContext();
                if (id != null && h > lineHeight * 2) {
                    Rectangle2D classBounds = font.getStringBounds(name, fontRenderContext);
                    Rectangle2D idBounds = font.getStringBounds(id, fontRenderContext);
                    int textY = y + h / 2;
                    int textX = x + w / 2 - (int)classBounds.getWidth() / 2;
                    if (component.isRoot()) {
                        textX = x + lineHeight;
                        textY = y - (int)(classBounds.getHeight() + idBounds.getHeight());
                    }
                    g.drawString(name, textX, textY);
                    if (component.isRoot()) {
                        textX = x + lineHeight;
                        textY = y - (int)idBounds.getHeight();
                    } else {
                        textX = x + w / 2 - (int)idBounds.getWidth() / 2;
                        textY += (int)idBounds.getHeight();
                    }
                    g.drawString(id, textX, textY);
                } else {
                    String text = id != null ? id : name;
                    Rectangle2D stringBounds = font.getStringBounds(text, fontRenderContext);
                    int textX = x + w / 2 - (int)stringBounds.getWidth() / 2;
                    int textY = y + h / 2 + (int)stringBounds.getHeight() / 2;
                    g.drawString(text, textX, textY);
                }
                g.dispose();
            }
        }
        for (NlComponent child : component.getChildren()) {
            needsRepaint |= this.drawComponent(gc, child, viewHandlerManager, handlesPainting);
        }
        return needsRepaint;
    }

    private void drawComponentBackground(@NotNull Graphics2D gc, @NotNull NlComponent component) {
        if (gc == null) {
            BlueprintLayer.$$$reportNull$$$0(5);
        }
        if (component == null) {
            BlueprintLayer.$$$reportNull$$$0(6);
        }
        if (component.viewInfo != null) {
            int x = Coordinates.getSwingX(this.myScreenView, component.x);
            int y = Coordinates.getSwingY(this.myScreenView, component.y);
            int w = Coordinates.getSwingDimension(this.myScreenView, component.w);
            int h = Coordinates.getSwingDimension(this.myScreenView, component.h);
            Graphics2D g = (Graphics2D)gc.create();
            if (!component.isRoot()) {
                g.setPaint(new LinearGradientPaint(x, y, x + 2, y + 2, COMPONENT_BACKGROUND_GRADIENT_FRACTIONS, COMPONENT_BACKGROUND_GRADIENT_COLORS, MultipleGradientPaint.CycleMethod.REFLECT));
                g.fillRect(x, y, w, h);
            }
            g.setColor(NlConstants.BLUEPRINT_FG_COLOR);
            Stroke prevStroke = g.getStroke();
            g.setStroke(NlConstants.BLUEPRINT_COMPONENT_STROKE);
            g.drawRect(x, y, w, h);
            g.setStroke(prevStroke);
            g.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewHandlerManager";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/BlueprintLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "drawComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "drawComponentBackground";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

