/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.idea.lint.SuppressLintIntentionAction;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.inspections.lint.AndroidLintGlobalInspectionContext;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLintInspectionBase
extends GlobalInspectionTool {
    public static final String LINT_INSPECTION_PREFIX = "AndroidLint";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.AndroidLintInspectionBase");
    private static final Object ISSUE_MAP_LOCK = new Object();
    private static volatile Map<Issue, String> ourIssue2InspectionShortName;
    protected final Issue myIssue;
    private final String[] myGroupPath;
    private final String myDisplayName;

    protected AndroidLintInspectionBase(@NotNull String displayName, @NotNull Issue issue) {
        if (displayName == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(0);
        }
        if (issue == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(1);
        }
        this.myIssue = issue;
        Category category = issue.getCategory();
        this.myGroupPath = ArrayUtil.mergeArrays((String[])new String[]{AndroidBundle.message("android.inspections.group.name", new Object[0]), AndroidBundle.message("android.lint.inspections.subgroup.name", new Object[0])}, (String[])AndroidLintInspectionBase.computeAllNames(category));
        this.myDisplayName = displayName;
    }

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(3);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(4);
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = this.getQuickFixes(message);
        if (androidLintQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(5);
        }
        return androidLintQuickFixArray;
    }

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(6);
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(7);
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public IntentionAction[] getIntentions(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(9);
        }
        if (IntentionAction.EMPTY_ARRAY == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(10);
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    @NotNull
    private LocalQuickFix[] getLocalQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(11);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(12);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(13);
        }
        AndroidLintQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message);
        ArrayList<MyLocalQuickFix> result = new ArrayList<MyLocalQuickFix>(fixes.length);
        for (AndroidLintQuickFix fix : fixes) {
            if (!fix.isApplicable(startElement, endElement, AndroidQuickfixContexts.BatchContext.TYPE)) continue;
            result.add(new MyLocalQuickFix(fix));
        }
        LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(14);
        }
        return localQuickFixArray;
    }

    public void runInspection(@NotNull AnalysisScope scope, final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        AndroidLintGlobalInspectionContext androidLintContext;
        if (scope == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(15);
        }
        if (manager == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(16);
        }
        if (globalContext == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(17);
        }
        if (problemDescriptionsProcessor == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(18);
        }
        if ((androidLintContext = (AndroidLintGlobalInspectionContext)globalContext.getExtension(AndroidLintGlobalInspectionContext.ID)) == null) {
            return;
        }
        Map<Issue, Map<File, List<ProblemData>>> problemMap = androidLintContext.getResults();
        if (problemMap == null) {
            return;
        }
        Map<File, List<ProblemData>> file2ProblemList = problemMap.get(this.myIssue);
        if (file2ProblemList == null) {
            return;
        }
        for (final Map.Entry<File, List<ProblemData>> entry : file2ProblemList.entrySet()) {
            File file = entry.getKey();
            final VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) continue;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ProblemDescriptor[] descriptors;
                    PsiDirectory psiDirectory;
                    PsiManager psiManager = PsiManager.getInstance((Project)globalContext.getProject());
                    PsiFile psiFile = psiManager.findFile(vFile);
                    if (psiFile != null) {
                        ProblemDescriptor[] descriptors2 = AndroidLintInspectionBase.this.computeProblemDescriptors((PsiElement)psiFile, manager, (List)entry.getValue());
                        if (descriptors2.length > 0) {
                            problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiFile), (CommonProblemDescriptor[])descriptors2);
                        }
                    } else if (vFile.isDirectory() && (psiDirectory = psiManager.findDirectory(vFile)) != null && (descriptors = AndroidLintInspectionBase.this.computeProblemDescriptors((PsiElement)psiDirectory, manager, (List)entry.getValue())).length > 0) {
                        problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiDirectory), (CommonProblemDescriptor[])descriptors);
                    }
                }
            });
        }
    }

    @NotNull
    private ProblemDescriptor[] computeProblemDescriptors(@NotNull PsiElement psiFile, @NotNull InspectionManager manager, @NotNull List<ProblemData> problems) {
        if (psiFile == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(19);
        }
        if (manager == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(20);
        }
        if (problems == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(21);
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (ProblemData problemData : problems) {
            String originalMessage = problemData.getMessage();
            String formattedMessage = "<html>" + TextFormat.RAW.convertTo(originalMessage, TextFormat.HTML_WITH_UNICODE) + "</html>";
            TextRange range = problemData.getTextRange();
            if (range.getStartOffset() == range.getEndOffset()) {
                if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiDirectory) {
                    LocalQuickFix[] fixes = this.getLocalQuickFixes(psiFile, psiFile, originalMessage);
                    result.add(new NonTextFileProblemDescriptor((PsiFileSystemItem)psiFile, formattedMessage, fixes));
                    continue;
                }
                if (this.isSuppressedFor(psiFile)) continue;
                result.add(manager.createProblemDescriptor(psiFile, formattedMessage, false, this.getLocalQuickFixes(psiFile, psiFile, originalMessage), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiElement startElement = psiFile.findElementAt(range.getStartOffset());
            PsiElement endElement = psiFile.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || this.isSuppressedFor(startElement)) continue;
            result.add(manager.createProblemDescriptor(startElement, endElement, formattedMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getLocalQuickFixes(startElement, endElement, originalMessage)));
        }
        ProblemDescriptor[] problemDescriptorArray = result.toArray(new ProblemDescriptor[result.size()]);
        if (problemDescriptorArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(22);
        }
        return problemDescriptorArray;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressLintQuickFix suppressLintQuickFix = new SuppressLintQuickFix(this.myIssue);
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{suppressLintQuickFix};
        if (suppressQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(23);
        }
        return suppressQuickFixArray;
    }

    public static void invalidateInspectionShortName2IssueMap() {
        ourIssue2InspectionShortName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInspectionShortNameByIssue(@NotNull Project project, @NotNull Issue issue) {
        if (project == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(24);
        }
        if (issue == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(25);
        }
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            if (ourIssue2InspectionShortName == null) {
                ourIssue2InspectionShortName = new HashMap();
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
                for (InspectionToolWrapper e : profile.getInspectionTools(null)) {
                    InspectionProfileEntry entry;
                    String shortName = e.getShortName();
                    if (!shortName.startsWith(LINT_INSPECTION_PREFIX) || !((entry = e.getTool()) instanceof AndroidLintInspectionBase)) continue;
                    Issue s = ((AndroidLintInspectionBase)entry).getIssue();
                    ourIssue2InspectionShortName.put(s, shortName);
                }
            }
            return ourIssue2InspectionShortName.get(issue);
        }
    }

    @NotNull
    private static String[] computeAllNames(@NotNull Category category) {
        if (category == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(26);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Category c = category; c != null; c = c.getParent()) {
            String name = c.getName();
            if (name == null) {
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                    AndroidLintInspectionBase.$$$reportNull$$$0(27);
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            result.add(name);
        }
        String[] stringArray = (String[])ArrayUtil.reverseArray((Object[])ArrayUtil.toStringArray(result));
        if (stringArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(28);
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.lint.inspections.group.name", new Object[0]);
        if (string == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public String[] getGroupPath() {
        if (this.myGroupPath == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(30);
        }
        return this.myGroupPath;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(31);
        }
        return string;
    }

    public String getStaticDescription() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<html><body>");
        sb.append(this.myIssue.getBriefDescription(TextFormat.HTML));
        sb.append("<br><br>");
        sb.append(this.myIssue.getExplanation(TextFormat.HTML));
        List urls = this.myIssue.getMoreInfo();
        if (!urls.isEmpty()) {
            boolean separated = false;
            for (String url : urls) {
                if (this.myIssue.getExplanation(TextFormat.RAW).contains(url)) continue;
                if (!separated) {
                    sb.append("<br><br>");
                    separated = true;
                } else {
                    sb.append("<br>");
                }
                sb.append("<a href=\"");
                sb.append(url);
                sb.append("\">");
                sb.append(url);
                sb.append("</a>");
            }
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public boolean isEnabledByDefault() {
        return this.myIssue.isEnabledByDefault();
    }

    @NotNull
    public String getShortName() {
        String string = InspectionProfileEntry.getShortName((String)((Object)((Object)this)).getClass().getSimpleName());
        if (string == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        Severity defaultSeverity = this.myIssue.getDefaultSeverity();
        if (defaultSeverity == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            if (highlightDisplayLevel == null) {
                AndroidLintInspectionBase.$$$reportNull$$$0(33);
            }
            return highlightDisplayLevel;
        }
        HighlightDisplayLevel displayLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(defaultSeverity);
        HighlightDisplayLevel highlightDisplayLevel = displayLevel != null ? displayLevel : HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(34);
        }
        return highlightDisplayLevel;
    }

    @Nullable
    static HighlightDisplayLevel toHighlightDisplayLevel(@NotNull Severity severity) {
        if (severity == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(35);
        }
        switch (severity) {
            case ERROR: {
                return HighlightDisplayLevel.ERROR;
            }
            case FATAL: {
                return HighlightDisplayLevel.ERROR;
            }
            case WARNING: {
                return HighlightDisplayLevel.WARNING;
            }
            case INFORMATIONAL: {
                return HighlightDisplayLevel.WEAK_WARNING;
            }
            case IGNORE: {
                return null;
            }
        }
        LOG.error("Unknown severity " + severity);
        return null;
    }

    private static boolean isSingleFileScope(EnumSet<Scope> scopes) {
        if (scopes.size() != 1) {
            return false;
        }
        Scope scope = (Scope)scopes.iterator().next();
        return scope == Scope.JAVA_FILE || scope == Scope.RESOURCE_FILE || scope == Scope.MANIFEST || scope == Scope.PROGUARD_FILE || scope == Scope.OTHER;
    }

    public boolean worksInBatchModeOnly() {
        Implementation implementation = this.myIssue.getImplementation();
        if (AndroidLintInspectionBase.isSingleFileScope(implementation.getScope())) {
            return false;
        }
        for (EnumSet scopes : implementation.getAnalysisScopes()) {
            if (!AndroidLintInspectionBase.isSingleFileScope(scopes)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Issue getIssue() {
        Issue issue = this.myIssue;
        if (issue == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(36);
        }
        return issue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalQuickFixes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProblemDescriptors";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllNames";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIntentions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLocalQuickFixes";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeProblemDescriptors";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionShortNameByIssue";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "computeAllNames";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "toHighlightDisplayLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonTextFileProblemDescriptor
    implements ProblemDescriptor {
        private final PsiFileSystemItem myFile;
        private final String myMessage;
        private final LocalQuickFix[] myFixes;
        private ProblemGroup myGroup;

        public NonTextFileProblemDescriptor(@NotNull PsiFileSystemItem file, @NotNull String message, @NotNull LocalQuickFix[] fixes) {
            if (file == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(0);
            }
            if (message == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(1);
            }
            if (fixes == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(2);
            }
            this.myFile = file;
            this.myMessage = message;
            this.myFixes = fixes;
        }

        public PsiElement getPsiElement() {
            return this.myFile;
        }

        public PsiElement getStartElement() {
            return this.myFile;
        }

        public PsiElement getEndElement() {
            return this.myFile;
        }

        public TextRange getTextRangeInElement() {
            return new TextRange(0, 0);
        }

        public int getLineNumber() {
            return 0;
        }

        @NotNull
        public ProblemHighlightType getHighlightType() {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (problemHighlightType == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(3);
            }
            return problemHighlightType;
        }

        public boolean isAfterEndOfLine() {
            return false;
        }

        public void setTextAttributes(TextAttributesKey key) {
        }

        @Nullable
        public ProblemGroup getProblemGroup() {
            return this.myGroup;
        }

        public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
            this.myGroup = problemGroup;
        }

        public boolean showTooltip() {
            return false;
        }

        @NotNull
        public String getDescriptionTemplate() {
            String string = this.myMessage;
            if (string == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public QuickFix[] getFixes() {
            return this.myFixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$NonTextFileProblemDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$NonTextFileProblemDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class MyLocalQuickFix
    implements LocalQuickFix {
        private final AndroidLintQuickFix myLintQuickFix;

        MyLocalQuickFix(@NotNull AndroidLintQuickFix lintQuickFix) {
            if (lintQuickFix == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            this.myLintQuickFix = lintQuickFix;
        }

        @NotNull
        public String getName() {
            String string = this.myLintQuickFix.getName();
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = AndroidBundle.message("android.lint.quickfixes.family", new Object[0]);
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyLocalQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyLocalQuickFix.$$$reportNull$$$0(4);
            }
            this.myLintQuickFix.apply(descriptor.getStartElement(), descriptor.getEndElement(), AndroidQuickfixContexts.BatchContext.getInstance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lintQuickFix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$MyLocalQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$MyLocalQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SuppressLintQuickFix
    implements SuppressQuickFix {
        private Issue myIssue;

        private SuppressLintQuickFix(Issue issue) {
            this.myIssue = issue;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(1);
            }
            return true;
        }

        public boolean isSuppressAll() {
            return false;
        }

        @NotNull
        public String getName() {
            if ("Suppress with @SuppressLint (Java) or tools:ignore (XML) or lint.xml" == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(2);
            }
            return "Suppress with @SuppressLint (Java) or tools:ignore (XML) or lint.xml";
        }

        @NotNull
        public String getFamilyName() {
            if ("Suppress" == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(3);
            }
            return "Suppress";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement myElement;
            PsiFile file;
            if (project == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(5);
            }
            if ((file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)(myElement = descriptor.getPsiElement()), PsiFile.class, (boolean)false)) != null) {
                new SuppressLintIntentionAction(this.myIssue, myElement).invoke(project, null, file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

