/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections.wellformedness;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.VtlInspectionBase;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlParameterDeclaration;
import com.intellij.velocity.psi.directives.VtlAssignment;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VtlInterpolationsInspection
extends VtlInspectionBase {
    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        VtlReferenceExpression wouldBeVariableDeclared;
        if (element instanceof VtlParameterDeclaration) {
            PsiElement wouldBeFormalNotationStart = element.getFirstChild();
            if (PsiUtil.isFormalNotationStart(wouldBeFormalNotationStart)) {
                PsiElement errorElement = wouldBeFormalNotationStart.getNextSibling();
                if (errorElement.getTextRange().isEmpty()) {
                    errorElement = wouldBeFormalNotationStart;
                }
                VtlInterpolationsInspection.registerFormalNotationProblem(errorElement, holder);
            }
        } else if (element instanceof VtlAssignment && (wouldBeVariableDeclared = ((VtlAssignment)element).getAssignedVariableElement(null)) != null && PsiUtil.isFormalNotationStart(wouldBeVariableDeclared.getPrevSibling())) {
            VtlInterpolationsInspection.registerFormalNotationProblem(wouldBeVariableDeclared, holder);
        }
    }

    private static void registerFormalNotationProblem(PsiElement element, ProblemsHolder holder) {
        holder.registerProblem(element, VelocityBundle.message("vtl.formal.notation.is.not.allowed", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            VtlInterpolationsInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = VelocityBundle.message("vtl.welformedness.inspection", new Object[0]);
        if (string == null) {
            VtlInterpolationsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("VtlInterpolationsInspection" == null) {
            VtlInterpolationsInspection.$$$reportNull$$$0(2);
        }
        return "VtlInterpolationsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/velocity/inspections/wellformedness/VtlInterpolationsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

