/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.AbstractSyntheticBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlDirectiveType;
import com.intellij.velocity.psi.VtlElementTypes;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlBlock
extends TemplateLanguageBlock {
    protected VtlBlock(@NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings codeStyleSettings, @NotNull ASTNode node, @Nullable List<DataLanguageBlockWrapper> foreignChildren, @Nullable Wrap wrap) {
        if (blockFactory == null) {
            VtlBlock.$$$reportNull$$$0(0);
        }
        if (codeStyleSettings == null) {
            VtlBlock.$$$reportNull$$$0(1);
        }
        if (node == null) {
            VtlBlock.$$$reportNull$$$0(2);
        }
        super(node, wrap, null, blockFactory, codeStyleSettings, foreignChildren);
    }

    protected Wrap createChildWrap(ASTNode child) {
        if (VtlBlock.isStringLiteral(child)) {
            return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
        }
        return super.createChildWrap(child);
    }

    private static boolean isStringLiteral(ASTNode child) {
        return VtlCompositeElementTypes.STRING_LITERALS.contains(child.getElementType());
    }

    public Indent getIndent() {
        if (this.getParent() == null || this.getParent().getParent() == null) {
            return Indent.getNoneIndent();
        }
        IElementType type = this.getNode().getElementType();
        if (type instanceof VtlDirectiveType && type != VtlCompositeElementTypes.DIRECTIVE_ELSEIF && type != VtlCompositeElementTypes.DIRECTIVE_ELSE || VtlBlock.isStringLiteral(this.getNode()) || type == VtlCompositeElementTypes.DIRECTIVE_BREAK || type == VtlCompositeElementTypes.INTERPOLATION) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    protected Indent getChildIndent() {
        return this.getNode().getTreeParent() == null ? Indent.getNoneIndent() : Indent.getNormalIndent();
    }

    protected IElementType getTemplateTextElementType() {
        return VtlElementTypes.TEMPLATE_TEXT;
    }

    public Wrap substituteTemplateChildWrap(@NotNull DataLanguageBlockWrapper child, @Nullable Wrap childWrap) {
        if (child == null) {
            VtlBlock.$$$reportNull$$$0(3);
        }
        if (VtlBlock.isStringLiteral(this.getNode())) {
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
        }
        return childWrap;
    }

    @Nullable
    public Spacing getRightNeighborSpacing(@NotNull Block rightNeighbor, @NotNull DataLanguageBlockWrapper parent, int thisBlockIndex) {
        if (rightNeighbor == null) {
            VtlBlock.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            VtlBlock.$$$reportNull$$$0(5);
        }
        if (rightNeighbor instanceof DataLanguageBlockWrapper) {
            if (VtlBlock.mustPreserveSpacing(parent)) {
                return Spacing.getReadOnlySpacing();
            }
            return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)1);
        }
        return null;
    }

    private static boolean mustPreserveSpacing(@NotNull DataLanguageBlockWrapper parent) {
        Block original;
        if (parent == null) {
            VtlBlock.$$$reportNull$$$0(6);
        }
        return (original = parent.getOriginal()) instanceof AbstractSyntheticBlock && ((AbstractSyntheticBlock)original).shouldKeepWhiteSpacesInside();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightNeighbor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/psi/formatter/VtlBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteTemplateChildWrap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRightNeighborSpacing";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "mustPreserveSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

