/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.NamedRow;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvDocumentDataHookUp
extends DocumentDataHookUp {
    protected CsvFormatParser myParser;

    public CsvDocumentDataHookUp(@NotNull Project project, @NotNull CsvFormat format, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(0);
        }
        if (format == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(1);
        }
        if (document == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(2);
        }
        super(project, document, range);
        this.myParser = new CsvFormatParser(format);
    }

    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(3);
        }
        this.myParser = new CsvFormatParser(format);
        this.getLoader().reloadCurrentPage(new GridRequestSource(null, this));
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myParser.getDataFormat();
        if (csvFormat == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(4);
        }
        return csvFormat;
    }

    @Override
    @Nullable
    protected CsvMarkup buildMarkup(@NotNull CharSequence sequence, @NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        String string;
        CsvMarkup markup;
        if (sequence == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(5);
        }
        if (source == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(6);
        }
        return (markup = this.myParser.parse(string = sequence.toString())) == null ? this.oneLineMarkup(string) : markup;
    }

    @NotNull
    private CsvMarkup oneLineMarkup(@NotNull String string) {
        if (string == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(7);
        }
        CsvFormatter formatter = new CsvFormatter(this.myParser.getDataFormat());
        int length = string.length();
        TextRange range = new TextRange(0, length);
        CsvRecord record = new CsvRecord(range, ContainerUtil.list((Object[])new ValueRange[]{new ValueRange(0, length)}), false);
        CsvMarkup csvMarkup = new CsvMarkup(formatter, string, ContainerUtil.list((Object[])new CsvRecord[]{record}), null, false);
        if (csvMarkup == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(8);
        }
        return csvMarkup;
    }

    @NotNull
    static List<String> values(@NotNull CharSequence sequence, @NotNull List<ValueRange> ranges) {
        if (sequence == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(9);
        }
        if (ranges == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(10);
        }
        List list = ContainerUtil.map(ranges, range -> {
            if (sequence == null) {
                CsvDocumentDataHookUp.$$$reportNull$$$0(12);
            }
            return range.value(sequence).toString();
        });
        if (list == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/CsvDocumentDataHookUp";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/CsvDocumentDataHookUp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "oneLineMarkup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildMarkup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "oneLineMarkup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "values";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$values$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ValueRange
    extends TextRange {
        ValueRange(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        CharSequence value(CharSequence s) {
            return this.subSequence(s);
        }
    }

    public static class CsvRecord {
        public final TextRange range;
        public final List<ValueRange> values;
        public final boolean hasRecordSeparator;

        CsvRecord(@NotNull TextRange range, @NotNull List<ValueRange> values2, boolean hasRecordSeparator) {
            if (range == null) {
                CsvRecord.$$$reportNull$$$0(0);
            }
            if (values2 == null) {
                CsvRecord.$$$reportNull$$$0(1);
            }
            this.range = range;
            this.values = values2;
            this.hasRecordSeparator = hasRecordSeparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "values";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvRecord";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CsvMarkup
    extends DocumentDataHookUp.DataMarkup {
        private final List<CsvRecord> myRecords;
        private final CsvRecord myHeader;
        private final CsvFormatter myFormatter;

        protected CsvMarkup(@NotNull CsvFormatter formatter, @NotNull CharSequence sequence, @NotNull List<CsvRecord> records, @Nullable CsvRecord header, boolean rowNumbers) {
            if (formatter == null) {
                CsvMarkup.$$$reportNull$$$0(0);
            }
            if (sequence == null) {
                CsvMarkup.$$$reportNull$$$0(1);
            }
            if (records == null) {
                CsvMarkup.$$$reportNull$$$0(2);
            }
            super(CsvMarkup.columnsFrom(sequence, records, header, rowNumbers), CsvMarkup.rowsFrom(sequence, records, rowNumbers));
            this.myFormatter = formatter;
            this.myHeader = header;
            this.myRecords = records;
        }

        public List<CsvRecord> getRecords() {
            return this.myRecords;
        }

        public CsvRecord getHeader() {
            return this.myHeader;
        }

        public CsvFormatter getFormatter() {
            return this.myFormatter;
        }

        @Override
        protected boolean deleteRows(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Row> sortedRows) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(3);
            }
            if (sortedRows == null) {
                CsvMarkup.$$$reportNull$$$0(4);
            }
            for (DataConsumer.Row row : sortedRows) {
                session.delete(this.myRecords.get((int)(row.rowNum - 1)).range);
            }
            return true;
        }

        @Override
        protected boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(5);
            }
            return this.insertRow(session, Arrays.asList(new Object[this.columns.size()]));
        }

        @Override
        protected boolean cloneRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Row row) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(6);
            }
            if (row == null) {
                CsvMarkup.$$$reportNull$$$0(7);
            }
            return this.insertRow(session, (List<?>)ContainerUtil.immutableList((Object[])row.values));
        }

        @Override
        protected boolean deleteColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Column> sortedColumns) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(8);
            }
            if (sortedColumns == null) {
                CsvMarkup.$$$reportNull$$$0(9);
            }
            List<DataConsumer.Column> columnsToLeave = this.getColumnsToLeave(sortedColumns);
            if (this.myHeader != null) {
                this.leaveColumns(session, columnsToLeave, this.myHeader);
            }
            for (int i2 = 0; i2 < this.rows.size(); ++i2) {
                this.leaveColumns(session, columnsToLeave, this.myRecords.get(i2), (DataConsumer.Row)this.rows.get(i2));
            }
            return true;
        }

        @Override
        protected boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(10);
            }
            return this.insertColumn(session, null);
        }

        @Override
        protected boolean cloneColumn(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Column column) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(11);
            }
            if (column == null) {
                CsvMarkup.$$$reportNull$$$0(12);
            }
            return this.insertColumn(session, column);
        }

        @Override
        protected boolean update(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<RowMutation> mutations) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(13);
            }
            if (mutations == null) {
                CsvMarkup.$$$reportNull$$$0(14);
            }
            for (RowMutation mutation : mutations) {
                DataConsumer.Row row = mutation.getRow();
                List<ValueRange> valueRanges = this.myRecords.get((int)DataConsumer.Row.toRealIdx((DataConsumer.Row)row)).values;
                for (ColumnQueryData data : mutation.getData()) {
                    String newValueText = this.myFormatter.formatValue(data.getObject());
                    DataConsumer.Column column = data.getColumn();
                    int rangeIdx = column.columnNum + (row instanceof NamedRow ? 1 : 0);
                    session.replace(valueRanges.get(rangeIdx), newValueText);
                }
            }
            return true;
        }

        private boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session, @Nullable DataConsumer.Column column) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(15);
            }
            if (this.myHeader != null) {
                ValueRange lastColumnRange = (ValueRange)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(this.myHeader.values)));
                String columnName = this.myFormatter.formatHeaderValue(column != null ? column.name : "column" + (this.columns.size() + 1));
                session.insert(this.myFormatter.headerValueSeparator() + columnName, lastColumnRange.getEndOffset());
            }
            for (int i2 = 0; i2 < this.rows.size(); ++i2) {
                ValueRange lastValueRange = (ValueRange)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(this.myRecords.get((int)i2).values)));
                String valueText = this.myFormatter.formatValue(column != null ? column.getValue((DataConsumer.Row)this.rows.get(i2)) : null);
                session.insert(this.myFormatter.valueSeparator() + valueText, lastValueRange.getEndOffset());
            }
            return true;
        }

        private boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<?> values2) {
            CsvRecord lastRecord;
            int offset;
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(16);
            }
            if (values2 == null) {
                CsvMarkup.$$$reportNull$$$0(17);
            }
            int n = offset = (lastRecord = (CsvRecord)ObjectUtils.chooseNotNull((Object)ContainerUtil.getLastItem(this.myRecords), (Object)this.myHeader)) != null ? lastRecord.range.getEndOffset() : 0;
            if (lastRecord != null && !lastRecord.hasRecordSeparator) {
                session.insert(this.myFormatter.recordSeparator(), offset);
            }
            if (this.myFormatter.requiresRowNumbers()) {
                String newRecordName = null;
                DataConsumer.Row lastRow = (DataConsumer.Row)ContainerUtil.getLastItem((List)this.rows);
                if (lastRow instanceof NamedRow) {
                    try {
                        newRecordName = String.valueOf(Long.parseLong(((NamedRow)lastRow).name) + 1L);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (newRecordName == null) {
                    newRecordName = String.valueOf(lastRow != null ? lastRow.rowNum + 1 : 1);
                }
                values2 = ContainerUtil.prepend(values2, (Object[])new Object[]{newRecordName});
            }
            session.insert(this.myFormatter.formatRecord(values2), offset);
            return true;
        }

        private void leaveColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Column> columns2, @NotNull CsvRecord record, @NotNull DataConsumer.Row row) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(18);
            }
            if (columns2 == null) {
                CsvMarkup.$$$reportNull$$$0(19);
            }
            if (record == null) {
                CsvMarkup.$$$reportNull$$$0(20);
            }
            if (row == null) {
                CsvMarkup.$$$reportNull$$$0(21);
            }
            if (columns2.isEmpty()) {
                session.delete(record.range);
                return;
            }
            List values2 = ContainerUtil.map(columns2, column -> {
                if (row == null) {
                    CsvMarkup.$$$reportNull$$$0(33);
                }
                return column.getValue(row);
            });
            if (row instanceof NamedRow) {
                values2 = ContainerUtil.prepend((List)values2, (Object[])new Object[]{((NamedRow)row).name});
            }
            String recordText = this.myFormatter.formatRecord(values2);
            session.replace(record.range, recordText);
            if (record.hasRecordSeparator) {
                session.insert(this.myFormatter.recordSeparator(), record.range.getEndOffset());
            }
        }

        private void leaveColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Column> columns2, @NotNull CsvRecord headerRecord) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(22);
            }
            if (columns2 == null) {
                CsvMarkup.$$$reportNull$$$0(23);
            }
            if (headerRecord == null) {
                CsvMarkup.$$$reportNull$$$0(24);
            }
            List<ValueRange> values2 = headerRecord.values;
            int valuesStart = values2.get(this.myFormatter.requiresRowNumbers() ? 1 : 0).getStartOffset();
            int valuesEnd = values2.get(values2.size() - 1).getEndOffset();
            StringBuilder sb = new StringBuilder();
            for (DataConsumer.Column column : columns2) {
                sb.append(this.myFormatter.formatHeaderValue(column.name)).append(this.myFormatter.headerValueSeparator());
            }
            sb.setLength(sb.length() != 0 ? sb.length() - this.myFormatter.headerValueSeparator().length() : sb.length());
            session.replace(TextRange.create((int)valuesStart, (int)valuesEnd), sb.toString());
        }

        @NotNull
        private List<DataConsumer.Column> getColumnsToLeave(@NotNull List<DataConsumer.Column> orderedColumnsToDelete) {
            if (orderedColumnsToDelete == null) {
                CsvMarkup.$$$reportNull$$$0(25);
            }
            ArrayList columnsToLeave = ContainerUtil.newArrayListWithCapacity((int)(this.columns.size() - orderedColumnsToDelete.size()));
            Iterator<DataConsumer.Column> toDeleteIterator = orderedColumnsToDelete.iterator();
            Iterator allColumnsIterator = this.columns.iterator();
            block0: while (allColumnsIterator.hasNext()) {
                DataConsumer.Column column;
                DataConsumer.Column toDelete;
                DataConsumer.Column column2 = toDelete = toDeleteIterator.hasNext() ? toDeleteIterator.next() : null;
                while (!(column = (DataConsumer.Column)allColumnsIterator.next()).equals(toDelete)) {
                    columnsToLeave.add(column);
                    if (allColumnsIterator.hasNext()) continue;
                    continue block0;
                }
            }
            ArrayList arrayList = columnsToLeave;
            if (arrayList == null) {
                CsvMarkup.$$$reportNull$$$0(26);
            }
            return arrayList;
        }

        @NotNull
        private static List<DataConsumer.Column> columnsFrom(@NotNull CharSequence sequence, @NotNull List<CsvRecord> records, @Nullable CsvRecord header, boolean rowNameColumn) {
            int columnCount;
            if (sequence == null) {
                CsvMarkup.$$$reportNull$$$0(27);
            }
            if (records == null) {
                CsvMarkup.$$$reportNull$$$0(28);
            }
            int n = header != null ? header.values.size() : (columnCount = records.isEmpty() ? 0 : records.get((int)0).values.size());
            if (columnCount > 0 && rowNameColumn) {
                --columnCount;
            }
            List<String> columnNames = header != null && rowNameColumn ? CsvFormatParser.values(sequence, header.values.subList(1, header.values.size())) : (header != null ? CsvFormatParser.values(sequence, header.values) : null);
            ArrayList columns2 = ContainerUtil.newArrayListWithCapacity((int)columnCount);
            for (int i2 = 0; i2 < columnCount; ++i2) {
                String name = columnNames == null ? "C" + (i2 + 1) : columnNames.get(i2);
                columns2.add(new DataConsumer.Column(i2, name, 239, "TEXT", "java.lang.String"));
            }
            ArrayList arrayList = columns2;
            if (arrayList == null) {
                CsvMarkup.$$$reportNull$$$0(29);
            }
            return arrayList;
        }

        @NotNull
        private static List<DataConsumer.Row> rowsFrom(@NotNull CharSequence sequence, @NotNull List<CsvRecord> records, boolean named) {
            if (sequence == null) {
                CsvMarkup.$$$reportNull$$$0(30);
            }
            if (records == null) {
                CsvMarkup.$$$reportNull$$$0(31);
            }
            ArrayList rows = ContainerUtil.newArrayListWithCapacity((int)records.size());
            for (int i2 = 0; i2 < records.size(); ++i2) {
                DataConsumer.Row row;
                List<ValueRange> valuesList = records.get((int)i2).values;
                if (named) {
                    Object[] values2 = CsvFormatParser.values(sequence, valuesList.subList(1, valuesList.size())).toArray();
                    String name = valuesList.get(0).value(sequence).toString();
                    row = NamedRow.create(i2, name, values2);
                } else {
                    row = DataConsumer.Row.create(i2, CsvFormatParser.values(sequence, valuesList).toArray());
                }
                rows.add(row);
            }
            ArrayList arrayList = rows;
            if (arrayList == null) {
                CsvMarkup.$$$reportNull$$$0(32);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 26: 
                case 29: 
                case 32: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 26: 
                case 29: 
                case 32: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 1: 
                case 27: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 2: 
                case 28: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 18: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortedRows";
                    break;
                }
                case 7: 
                case 21: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortedColumns";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mutations";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 19: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headerRecord";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderedColumnsToDelete";
                    break;
                }
                case 26: 
                case 29: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsToLeave";
                    break;
                }
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "columnsFrom";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rowsFrom";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRows";
                    break;
                }
                case 5: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "insertRow";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneRow";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteColumns";
                    break;
                }
                case 10: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "insertColumn";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneColumn";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "leaveColumns";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnsToLeave";
                    break;
                }
                case 26: 
                case 29: 
                case 32: {
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "columnsFrom";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "rowsFrom";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$leaveColumns$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 26: 
                case 29: 
                case 32: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

