/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.oracle.OraTableColumn;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public interface OraMixinMatLog
extends BasicMinorObject,
BasicNamedElement {
    @Override
    public OraSchema getSchema();

    public boolean isWithRowId();

    public boolean isWithObjectId();

    public boolean isWithPrimaryKey();

    public boolean isWithSequence();

    public boolean isWithNewValues();

    @Override
    @NotNull
    default public String identity(boolean includingSurrogate) {
        String string = includingSurrogate ? BasicNamedElement.super.identity(true) : "#ML";
        if (string == null) {
            OraMixinMatLog.$$$reportNull$$$0(0);
        }
        return string;
    }

    default public String withOptions() {
        OraTable table;
        StringBuilder b = new StringBuilder(60);
        ArrayList<String> opts = new ArrayList<String>(3);
        if (this.isWithRowId()) {
            opts.add("rowid");
        }
        if (this.isWithObjectId()) {
            opts.add("object id");
        }
        if (this.isWithPrimaryKey()) {
            opts.add("primary key");
        }
        if (this.isWithSequence()) {
            opts.add("sequence");
        }
        b.append("with ");
        StringUtil.join(opts, (String)", ", (StringBuilder)b);
        OraSchema schema = this.getSchema();
        if (schema != null && (table = (OraTable)schema.getTables().get(this.getName())) != null) {
            boolean was = false;
            for (OraTableColumn oraTableColumn : table.getColumns()) {
                String name = oraTableColumn.getRealName();
                if (name == null || name.endsWith("$$")) continue;
                b.append(was ? ", " : " (").append(name);
                was = true;
            }
            if (was) {
                b.append(')');
            }
        }
        return b.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraMixinMatLog", "identity"));
    }
}

