/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseConsoleAction
extends AlignedIconWithTextAction
implements DumbAware {
    public void update(AnActionEvent e) {
        String tooltipText;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        if (psiFile == null || DbConsoleRootType.isConsoleFile(virtualFile)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        JdbcConsole console = JdbcConsoleProvider.getAttachedConsole(e.getProject(), virtualFile);
        JComponent button = (JComponent)e.getPresentation().getClientProperty("customComponent");
        boolean isSqlFile = psiFile instanceof SqlFile || psiFile.getFileType() == SqlFileType.INSTANCE;
        boolean isPopup = ActionPlaces.isPopupPlace((String)e.getPlace());
        boolean enabled = !DbImplUtil.getDataSourcesForExec(psiFile, true, false).isEmpty();
        String fullText = console != null && !isPopup ? console.getTitle() : StringUtil.notNullize((String)this.getTemplatePresentation().getText(), (String)"Attach Console");
        String text2 = fullText.length() <= 30 ? fullText : fullText.substring(0, 30) + "\u2026";
        boolean visible = (console == null && isSqlFile || !isPopup) && StringUtil.isNotEmpty((String)text2);
        String string = tooltipText = enabled ? "Switch attached console" : "Attached console";
        Icon icon = !enabled || isPopup ? null : (UIUtil.isUnderDarcula() ? AllIcons.General.ComboArrow : AllIcons.General.ComboBoxButtonArrow);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setText(text2, false);
        e.getPresentation().setDescription(fullText);
        e.getPresentation().setDisabledIcon(icon);
        e.getPresentation().setIcon(icon);
        if (button != null) {
            button.setToolTipText(tooltipText);
            ((ActionButtonWithText)button).setHorizontalTextPosition(2);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(ChooseConsoleAction.getRunners(psiFile, console), null, e);
    }

    @NotNull
    protected static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiFile psiFile, @Nullable JdbcConsole current) {
        if (psiFile == null) {
            ChooseConsoleAction.$$$reportNull$$$0(0);
        }
        Project project = psiFile.getProject();
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.notNull((Object)PsiUtilCore.getVirtualFile((PsiElement)psiFile));
        JBIterable<DbDataSource> dataSources2 = DbImplUtil.getDataSourcesForExec(psiFile, true, false);
        Set allowedIds = dataSources2.map(o -> o.getUniqueId()).toSet();
        ArrayList result2 = ContainerUtil.newArrayList();
        if (current != null) {
            result2.add(JdbcConsoleProvider.newPriorityRunner("Detach console", false, false, AllIcons.Actions.Cancel, null, () -> JdbcConsoleProvider.attachConsole(project, null, virtualFile)));
        }
        for (JdbcConsole console2 : JdbcConsoleProvider.getRunningConsoles(project)) {
            if (console2 == current || !allowedIds.contains(console2.getDataSource().getUniqueId())) continue;
            result2.add(JdbcConsoleProvider.newRunner(console2, () -> JdbcConsoleProvider.attachConsole(project, console2, virtualFile)));
        }
        for (DbDataSource dataSource : dataSources2) {
            result2.add(JdbcConsoleProvider.newRunner(dataSource, null, (Consumer<JdbcConsole>)((Consumer)console -> JdbcConsoleProvider.attachConsole(project, console, virtualFile))));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ChooseConsoleAction.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseConsoleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseConsoleAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

