/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mssql;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.mssql.MsMajorObject;
import com.intellij.database.scripting.AbstractScriptingService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007B\u0017\b\u0014\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R(\u0010\f\u001a\u0004\u0018\u00018\u00022\b\u0010\u000b\u001a\u0004\u0018\u00018\u00028V@WX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/scripting/mssql/TsqlScriptingService;", "M", "Lcom/intellij/database/model/basic/BasicModel;", "D", "Lcom/intellij/database/model/basic/BasicDatabase;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "model", "database", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicDatabase;)V", "value", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "areCurrentDatabaseNamesCaseSensitive", "getPreliminaryOrderPart", "element", "Lcom/intellij/database/model/basic/BasicElement;", "database-scripting"})
public abstract class TsqlScriptingService<M extends BasicModel, D extends BasicDatabase, S extends BasicSchema>
extends AbstractScriptingService<M, D, S> {
    @NotNull
    private final String statementDelimiterStr = "go";
    private final boolean statementDelimiterOwnsLine = true;

    @Override
    @Nullable
    public S getCurrentSchema() {
        return super.getCurrentSchema();
    }

    @Override
    public void setCurrentSchema(@Nullable S value) {
        S s = value;
        super.setCurrentSchema(s != null && (s = s.getDatabase()) != null ? ModelFun.getCurrentSchema(s) : null);
    }

    public boolean areCurrentDatabaseNamesCaseSensitive() {
        return false;
    }

    @Override
    @NotNull
    public String getStatementDelimiterStr() {
        return this.statementDelimiterStr;
    }

    @Override
    public boolean getStatementDelimiterOwnsLine() {
        return this.statementDelimiterOwnsLine;
    }

    @Override
    @NotNull
    public String getPreliminaryOrderPart(@NotNull BasicElement element) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof MsMajorObject) {
            if (this.getConsiderOrderHeuristic()) {
                string = super.getPreliminaryOrderPart(element);
            } else {
                String string2 = ((MsMajorObject)element).getName();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.name");
            }
        } else {
            string = super.getPreliminaryOrderPart(element);
        }
        return string;
    }

    protected TsqlScriptingService(@NotNull M model, @NotNull D database) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        super(model, database);
        this.statementDelimiterStr = "go";
        this.statementDelimiterOwnsLine = true;
    }
}

