/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.postgres.PostgresCollation;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresForeignDataWrapper;
import com.intellij.database.model.postgres.PostgresForeignServer;
import com.intellij.database.model.postgres.PostgresForeignTable;
import com.intellij.database.model.postgres.PostgresIndex;
import com.intellij.database.model.postgres.PostgresMatView;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresRole;
import com.intellij.database.model.postgres.PostgresRule;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.postgres.PostgresUserMapping;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.postgres.PostgresBaseDropGenerator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002\u00a8\u00067"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresDropGenerator;", "Lcom/intellij/database/scripting/postgres/PostgresBaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateCollation", "", "collation", "Lcom/intellij/database/model/postgres/PostgresCollation;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateForeignDataWrapper", "fdw", "Lcom/intellij/database/model/postgres/PostgresForeignDataWrapper;", "generateForeignServer", "srv", "Lcom/intellij/database/model/postgres/PostgresForeignServer;", "generateForeignTable", "table", "Lcom/intellij/database/model/postgres/PostgresForeignTable;", "generateIndex", "index", "Lcom/intellij/database/model/postgres/PostgresIndex;", "generateMatView", "mview", "Lcom/intellij/database/model/postgres/PostgresMatView;", "generateOperator", "op", "Lcom/intellij/database/model/postgres/PostgresOperator;", "generateRole", "role", "Lcom/intellij/database/model/postgres/PostgresRole;", "generateRule", "rule", "Lcom/intellij/database/model/postgres/PostgresRule;", "generateSequence", "seq", "Lcom/intellij/database/model/postgres/PostgresSequence;", "generateTrigger", "trigger", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "generateType", "tp", "Lcom/intellij/database/model/postgres/PostgresDefType;", "generateUserMapping", "um", "Lcom/intellij/database/model/postgres/PostgresUserMapping;", "opType", "", "t", "Lcom/intellij/database/model/DataType;", "Companion", "database-scripting"})
public final class PostgresDropGenerator
extends PostgresBaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof PostgresRole) {
            this.generateRole((PostgresRole)element);
        } else if (basicElement instanceof PostgresCollation) {
            this.generateCollation((PostgresCollation)element);
        } else if (basicElement instanceof PostgresForeignTable) {
            this.generateForeignTable((PostgresForeignTable)element);
        } else if (basicElement instanceof PostgresForeignDataWrapper) {
            this.generateForeignDataWrapper((PostgresForeignDataWrapper)element);
        } else if (basicElement instanceof PostgresIndex) {
            this.generateIndex((PostgresIndex)element);
        } else if (basicElement instanceof PostgresOperator) {
            this.generateOperator((PostgresOperator)element);
        } else if (basicElement instanceof PostgresRule) {
            this.generateRule((PostgresRule)element);
        } else if (basicElement instanceof PostgresSequence) {
            this.generateSequence((PostgresSequence)element);
        } else if (basicElement instanceof PostgresForeignServer) {
            this.generateForeignServer((PostgresForeignServer)element);
        } else if (basicElement instanceof PostgresTrigger) {
            this.generateTrigger((PostgresTrigger)element);
        } else if (basicElement instanceof PostgresDefType) {
            this.generateType((PostgresDefType)element);
        } else if (basicElement instanceof PostgresUserMapping) {
            this.generateUserMapping((PostgresUserMapping)element);
        } else if (basicElement instanceof PostgresMatView) {
            this.generateMatView((PostgresMatView)element);
        } else {
            super.generateElement(element);
        }
    }

    private final void generateMatView(PostgresMatView mview) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, mview){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresMatView $mview;

            public final void invoke() {
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop materialized view", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$mview), PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$mview = postgresMatView;
                super(0);
            }
        }, 3, null);
    }

    private final void generateUserMapping(PostgresUserMapping um) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, um){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresUserMapping $um;

            public final void invoke() {
                Object object;
                String string;
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop user mapping", PostgresDropGenerator.access$ifExists(this.this$0), "for", (string = this.$um.getUser()) != null && (string = PostgresDropGenerator.access$getScr$p(this.this$0, string)) != null ? (CharSequence)string : (CharSequence)"???", "on", (object = this.$um.getForeignServer()) != null && (object = PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???");
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$um = postgresUserMapping;
                super(0);
            }
        }, 3, null);
    }

    private final void generateType(PostgresDefType tp) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tp){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresDefType $tp;

            public final void invoke() {
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop type", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$tp), PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$tp = postgresDefType;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTrigger(PostgresTrigger trigger) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresTrigger $trigger;

            public final void invoke() {
                Object object;
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop trigger", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$getScr$p(this.this$0, this.$trigger.getName()), "on", (object = this.$trigger.getLikeTable()) != null && (object = PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$trigger = postgresTrigger;
                super(0);
            }
        }, 3, null);
    }

    private final void generateForeignServer(PostgresForeignServer srv) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, srv){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresForeignServer $srv;

            public final void invoke() {
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop server", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$srv), PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$srv = postgresForeignServer;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSequence(PostgresSequence seq) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, seq){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresSequence $seq;

            public final void invoke() {
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop sequence", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$seq), PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$seq = postgresSequence;
                super(0);
            }
        }, 3, null);
    }

    private final void generateRule(PostgresRule rule) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, rule){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresRule $rule;

            public final void invoke() {
                Object object;
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop rule", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$getScr$p(this.this$0, this.$rule.getName()), "on", (object = this.$rule.getLikeTable()) != null && (object = PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$rule = postgresRule;
                super(0);
            }
        }, 3, null);
    }

    private final void generateOperator(PostgresOperator op) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, op){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresOperator $op;

            public final void invoke() {
                CodeTextBuilder codeTextBuilder = PostgresDropGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray = new CharSequence[4];
                charSequenceArray[0] = "drop operator";
                charSequenceArray[1] = PostgresDropGenerator.access$ifExists(this.this$0);
                StringBuilder stringBuilder = new StringBuilder().append("").append(PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$op)).append('(');
                DataType dataType = this.$op.getLeftType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"op.leftType");
                StringBuilder stringBuilder2 = stringBuilder.append(PostgresDropGenerator.access$opType(this.this$0, dataType)).append(", ");
                DataType dataType2 = this.$op.getRightType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"op.rightType");
                charSequenceArray[2] = stringBuilder2.append(PostgresDropGenerator.access$opType(this.this$0, dataType2)).append(')').toString();
                charSequenceArray[3] = PostgresDropGenerator.access$restrictCascade(this.this$0);
                codeTextBuilder.phrase(charSequenceArray);
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$op = postgresOperator;
                super(0);
            }
        }, 3, null);
    }

    private final String opType(DataType t) {
        return Intrinsics.areEqual((Object)t, (Object)DataType.UNKNOWN) ^ true ? this.script(t) : "none";
    }

    private final void generateIndex(PostgresIndex index) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, index){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresIndex $index;

            public final void invoke() {
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop index", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$index), PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$index = postgresIndex;
                super(0);
            }
        }, 3, null);
    }

    private final void generateForeignDataWrapper(PostgresForeignDataWrapper fdw) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, fdw){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresForeignDataWrapper $fdw;

            public final void invoke() {
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop foreign data wrapper", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$fdw), PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$fdw = postgresForeignDataWrapper;
                super(0);
            }
        }, 3, null);
    }

    private final void generateForeignTable(PostgresForeignTable table) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresForeignTable $table;

            public final void invoke() {
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop foreign table", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$table), PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$table = postgresForeignTable;
                super(0);
            }
        }, 3, null);
    }

    private final void generateCollation(PostgresCollation collation) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, collation){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresCollation $collation;

            public final void invoke() {
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop collation", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$collation), PostgresDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$collation = postgresCollation;
                super(0);
            }
        }, 3, null);
    }

    private final void generateRole(PostgresRole role) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, role){
            final /* synthetic */ PostgresDropGenerator this$0;
            final /* synthetic */ PostgresRole $role;

            public final void invoke() {
                PostgresDropGenerator.access$getBuilder$p(this.this$0).phrase("drop role", PostgresDropGenerator.access$ifExists(this.this$0), PostgresDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$role));
            }
            {
                this.this$0 = postgresDropGenerator;
                this.$role = postgresRole;
                super(0);
            }
        }, 3, null);
    }

    public PostgresDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        super(context, task);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.ROLE, ObjectKind.COLLATION, ObjectKind.FOREIGN_TABLE, ObjectKind.FOREIGN_DATA_WRAPPER, ObjectKind.INDEX, ObjectKind.OPERATOR, ObjectKind.RULE, ObjectKind.SEQUENCE, ObjectKind.SERVER, ObjectKind.TRIGGER, ObjectKind.OBJECT_TYPE, ObjectKind.USER_MAPPING, ObjectKind.MAT_VIEW});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(PostgresDropGenerator $this) {
        return $this.getBuilder();
    }

    @Nullable
    public static final /* synthetic */ String access$ifExists(PostgresDropGenerator $this) {
        return $this.ifExists();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(PostgresDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @Nullable
    public static final /* synthetic */ String access$restrictCascade(PostgresDropGenerator $this) {
        return $this.restrictCascade();
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(PostgresDropGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$opType(PostgresDropGenerator $this, @NotNull DataType t) {
        return $this.opType(t);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.CHECK)) {
                ObjectKind objectKind = (ObjectKind)CollectionsKt.firstOrNull(context);
                if (objectKind == null) {
                    objectKind = ObjectKind.TABLE;
                }
                if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) return true;
            }
            if (this.getSUPPORTED().contains(kind)) return true;
            if (!PostgresBaseDropGenerator.Companion.canDrop(kind, context)) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

