/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sqlite;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModCheck;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.sqlite.SqliteModCheck;
import com.intellij.database.model.sqlite.SqliteModIndex;
import com.intellij.database.model.sqlite.SqliteModKey;
import com.intellij.database.model.sqlite.SqliteModRoot;
import com.intellij.database.model.sqlite.SqliteModTable;
import com.intellij.database.model.sqlite.SqliteModTableColumn;
import com.intellij.database.model.sqlite.SqliteModTrigger;
import com.intellij.database.model.sqlite.SqliteModVirtualTable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.database.SqlObjectBuilderImpl;
import com.intellij.sql.dialects.sqlite.SqliteTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\"2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\"2\u0006\u0010\n\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J1\u0010'\u001a\u0004\u0018\u0001H(\"\b\b\u0000\u0010(*\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H(0-H\u0002\u00a2\u0006\u0002\u0010.J \u0010/\u001a\u0004\u0018\u00010+2\b\u0010*\u001a\u0004\u0018\u00010+2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-H\u0002J\u0018\u00100\u001a\n\u0012\u0004\u0012\u00020+\u0018\u0001012\u0006\u00102\u001a\u000203H\u0002J\u0014\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000103H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:H\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010=\u001a\u00020\u00122\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010@\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010A\u001a\u0004\u0018\u0001032\b\u00102\u001a\u0004\u0018\u000103H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/sql/dialects/sqlite/SqliteObjectBuilder;", "Lcom/intellij/sql/database/SqlObjectBuilderImpl;", "()V", "SEQUENCE_IDENTITY", "Lcom/intellij/database/model/SequenceIdentity;", "Lorg/jetbrains/annotations/NotNull;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildCheck", "Lcom/intellij/database/model/basic/BasicModCheck;", "buildCheckFromConstraintDefinition", "Lcom/intellij/database/model/sqlite/SqliteModCheck;", "Lcom/intellij/sql/psi/SqlConstraintDefinition;", "complete", "", "buildColumn", "Lcom/intellij/database/model/sqlite/SqliteModTableColumn;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildIndexFromCreateIndex", "Lcom/intellij/database/model/sqlite/SqliteModIndex;", "Lcom/intellij/sql/psi/SqlCreateIndexStatement;", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyFromTableKeyDefinition", "Lcom/intellij/database/model/sqlite/SqliteModKey;", "Lcom/intellij/sql/psi/SqlTableKeyDefinition;", "buildTable", "Lcom/intellij/database/model/sqlite/SqliteModTable;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildTriggerFromCreateTrigger", "Lcom/intellij/sql/psi/SqlCreateTriggerStatement;", "buildVirtualTable", "Lcom/intellij/database/model/sqlite/SqliteModVirtualTable;", "findObject", "T", "Lcom/intellij/database/model/basic/BasicElement;", "name", "", "src", "Lcom/intellij/database/model/families/Family;", "(Ljava/lang/String;Lcom/intellij/database/model/families/Family;)Lcom/intellij/database/model/basic/BasicElement;", "fixName", "getColumns", "", "el", "Lcom/intellij/psi/PsiElement;", "getConflictResolution", "Lcom/intellij/database/model/properties/SqliteOnConflictAlgorithm;", "def", "getEvent", "Lcom/intellij/database/model/TrigEvent;", "type", "Lcom/intellij/psi/tree/IElementType;", "getTurn", "Lcom/intellij/database/model/TrigTurn;", "isDesc", "expr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "partialBuild", "skipUnsignificant", "sql-dialects"})
public final class SqliteObjectBuilder
extends SqlObjectBuilderImpl {
    private final SequenceIdentity SEQUENCE_IDENTITY = SequenceIdentity.of(1L, null, 1L, null);

    @Override
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof SqliteModTable) {
            this.buildTable((SqliteModTable)obj, source, true);
        } else if (basicModElement instanceof SqliteModTableColumn) {
            this.buildColumn((SqliteModTableColumn)obj, source, true);
        } else if (basicModElement instanceof SqliteModVirtualTable) {
            this.buildVirtualTable((SqliteModVirtualTable)obj, source, true);
        } else {
            super.build(obj, source);
        }
    }

    @Override
    public void partialBuild(@NotNull DasObject obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        DasObject dasObject = obj;
        if (dasObject instanceof SqliteModTable) {
            this.buildTable((SqliteModTable)obj, source, false);
        } else if (dasObject instanceof SqliteModTableColumn) {
            this.buildColumn((SqliteModTableColumn)obj, source, false);
        } else if (dasObject instanceof SqliteModVirtualTable) {
            this.buildVirtualTable((SqliteModVirtualTable)obj, source, false);
        } else if (dasObject instanceof SqliteModTrigger) {
            if (source instanceof SqlCreateTriggerStatement) {
                this.buildTriggerFromCreateTrigger((BasicModTrigger)obj, (SqlCreateTriggerStatement)source, false);
            }
        } else if (dasObject instanceof SqliteModIndex) {
            if (source instanceof SqlCreateIndexStatement) {
                this.buildIndexFromCreateIndex((SqliteModIndex)obj, (SqlCreateIndexStatement)source, false);
            }
        } else if (dasObject instanceof SqliteModKey) {
            if (source instanceof SqlTableKeyDefinition) {
                this.buildKeyFromTableKeyDefinition((SqliteModKey)obj, (SqlTableKeyDefinition)source, false);
            }
        } else if (dasObject instanceof SqliteModCheck && source instanceof SqlConstraintDefinition) {
            this.buildCheckFromConstraintDefinition((SqliteModCheck)obj, (SqlConstraintDefinition)source, false);
        }
    }

    private final void buildTable(SqliteModTable obj, DasObject source, boolean complete) {
        if (complete) {
            this.buildBasicElement(obj, source);
        }
        if (source instanceof SqlCreateTableStatement) {
            PsiElement psiElement = (PsiElement)source;
            IElementType iElementType = SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE");
            obj.setWithoutRowId(this.findChild(psiElement, iElementType) != null);
        }
    }

    @Override
    protected void buildCheck(@NotNull BasicModCheck obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(obj instanceof SqliteModCheck) || !(source instanceof SqlConstraintDefinition)) {
            super.buildCheck(obj, source);
            return;
        }
        this.buildCheckFromConstraintDefinition((SqliteModCheck)obj, (SqlConstraintDefinition)source, true);
    }

    private final void buildCheckFromConstraintDefinition(SqliteModCheck obj, SqlConstraintDefinition source, boolean complete) {
        if (complete) {
            super.buildCheck(obj, (DasObject)source);
        }
        obj.setOnConflict(this.getConflictResolution((PsiElement)source));
    }

    private final void buildColumn(SqliteModTableColumn obj, DasObject source, boolean complete) {
        if (complete) {
            this.buildTyped(obj, source);
        }
        if (source instanceof SqlColumnDefinition) {
            PsiElement first$iv$iv;
            SqliteObjectBuilder this_$iv;
            String collationName = null;
            SqliteObjectBuilder sqliteObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType type;
                PsiElement it = tmp$iv$iv;
                if (!(it instanceof SqlConstraintDefinition)) continue;
                ASTNode aSTNode = ((SqlConstraintDefinition)it).getNode();
                Object object = type = aSTNode != null ? aSTNode.getElementType() : null;
                if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION)) {
                    SqlExpression collationRef;
                    SqlExpression sqlExpression = collationRef = (SqlExpression)((SqlConstraintDefinition)it).getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
                    collationName = sqlExpression != null ? sqlExpression.getText() : null;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION)) continue;
                obj.setOnNullConflict(this.getConflictResolution(it));
            }
            if (StringsKt.equals((String)"binary", (String)collationName, (boolean)true)) {
                collationName = null;
            }
            BasicRoot basicRoot = ((BasicModModel)obj.getModel()).getRoot();
            if (basicRoot == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.sqlite.SqliteModRoot");
            }
            NamingFamily namingFamily = ((SqliteModRoot)basicRoot).getCollations();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"(obj.model.root as SqliteModRoot).collations");
            obj.setCollation(this.fixName(collationName, namingFamily));
            PsiElement psiElement = (PsiElement)source;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes\u2026ERATED_AS_IDENTITY_CLAUSE");
            obj.setSequenceIdentity(this.findChild(psiElement, (IElementType)sqlCompositeElementType) == null ? null : this.SEQUENCE_IDENTITY);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildVirtualTable(SqliteModVirtualTable obj, DasObject source, boolean complete) {
        if (complete) {
            this.buildNamedElement(obj, source);
        }
        if (source instanceof SqlCreateStatement) {
            List list;
            SqlClause moduleClause = (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlClause.class);
            SqlReferenceExpression moduleRef = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)moduleClause), SqlReferenceExpression.class);
            SqlClause[] moduleArguments = (SqlClause[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)moduleClause), SqlClause.class);
            SqliteModVirtualTable sqliteModVirtualTable = obj;
            if (moduleArguments != null) {
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Object[] objectArray = moduleArguments;
                SqliteModVirtualTable sqliteModVirtualTable2 = sqliteModVirtualTable;
                void var8_9 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
                for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                    void it;
                    void item$iv$iv = $receiver$iv$iv[j];
                    SqlClause sqlClause = (SqlClause)item$iv$iv;
                    collection = destination$iv$iv;
                    String string = it.getText();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                sqliteModVirtualTable = sqliteModVirtualTable2;
                list = collection;
            } else {
                list = CollectionsKt.emptyList();
            }
            sqliteModVirtualTable.setArguments(list);
            SqlReferenceExpression sqlReferenceExpression = moduleRef;
            obj.setModule(sqlReferenceExpression != null ? sqlReferenceExpression.getName() : null);
        }
    }

    @Override
    protected void buildKey(@NotNull BasicModKey obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(source instanceof SqlTableKeyDefinition) || !(obj instanceof SqliteModKey)) {
            super.buildKey(obj, source);
            return;
        }
        this.buildKeyFromTableKeyDefinition((SqliteModKey)obj, (SqlTableKeyDefinition)source, true);
    }

    private final void buildKeyFromTableKeyDefinition(SqliteModKey obj, SqlTableKeyDefinition source, boolean complete) {
        if (complete) {
            this.buildBasicElement(obj, (DasObject)source);
        }
        obj.setPrimary(source.isPrimary());
        obj.setOnConflict(this.getConflictResolution((PsiElement)source));
    }

    @Override
    protected void buildTrigger(@NotNull BasicModTrigger obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(obj instanceof SqliteModTrigger)) {
            super.buildTrigger(obj, source);
        }
        if (source instanceof SqlCreateTriggerStatement) {
            this.buildTriggerFromCreateTrigger(obj, (SqlCreateTriggerStatement)source, true);
        }
    }

    private final void buildTriggerFromCreateTrigger(BasicModTrigger obj, SqlCreateTriggerStatement source, boolean complete) {
        SqlExpression whenExpr;
        PsiElement element;
        SqlNameElement name;
        if (complete) {
            this.buildBasicElement(obj, (DasObject)source);
        }
        TrigTurn turn = null;
        TrigEvent event = null;
        List<String> cols = null;
        SqlNameElement sqlNameElement = name = source.getNameElement();
        PsiElement afterName = this.skipUnsignificant((PsiElement)(sqlNameElement != null ? sqlNameElement.getNextSibling() : null));
        if (afterName instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)afterName).getFirstChild())) != null) {
            IElementType type;
            IElementType iElementType = type = element.getNode().getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"type");
            event = this.getEvent(iElementType);
            if (event == null) {
                turn = this.getTurn(type);
                PsiElement nextClause = this.skipUnsignificant(((SqlClause)afterName).getNextSibling());
                if (nextClause instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)nextClause).getFirstChild())) != null) {
                    IElementType iElementType2 = element.getNode().getElementType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"element.node.elementType");
                    event = this.getEvent(iElementType2);
                    cols = this.getColumns(nextClause);
                }
            } else {
                cols = this.getColumns(afterName);
            }
        }
        turn = turn == null ? TrigTurn.BEFORE_ROW : turn;
        SqlWhenClause whenClause = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlWhenClause.class);
        SqlExpression sqlExpression = whenExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)whenClause), SqlExpression.class);
        obj.setCondition(sqlExpression != null ? sqlExpression.getText() : null);
        obj.setTurn(turn);
        List<String> list = cols;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        obj.setColNames(list);
        obj.setEvents(event == null ? SetsKt.emptySet() : SetsKt.setOf((Object)event));
    }

    @Override
    protected void buildIndex(@NotNull BasicModIndex obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(obj instanceof SqliteModIndex)) {
            super.buildIndex(obj, source);
            return;
        }
        if (source instanceof SqlCreateIndexStatement) {
            this.buildIndexFromCreateIndex((SqliteModIndex)obj, (SqlCreateIndexStatement)source, false);
        }
    }

    private final void buildIndexFromCreateIndex(SqliteModIndex obj, SqlCreateIndexStatement source, boolean complete) {
        SqlTableColumnsList columnsList;
        SqlReferenceExpression tableRef;
        SqlExpression whereExpr;
        if (complete) {
            this.buildNamedElement(obj, (DasObject)source);
        }
        SqlWhereClause where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlWhereClause.class);
        SqlExpression sqlExpression = whereExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)where), SqlExpression.class);
        obj.setCondition(sqlExpression != null ? sqlExpression.getText() : null);
        SqlReferenceExpression sqlReferenceExpression = tableRef = source.getTargetReference();
        Object object = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
        if (!(object instanceof SqlTableColumnsList)) {
            object = null;
        }
        SqlTableColumnsList sqlTableColumnsList = columnsList = (SqlTableColumnsList)object;
        Object columns2 = sqlTableColumnsList != null ? sqlTableColumnsList.getColumnsReferenceList() : null;
        SqlExpression[] columnExprs = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)columns2), SqlExpression.class);
        if (columnExprs != null) {
            ArrayList newNames = ContainerUtil.newArrayListWithCapacity((int)((Object[])columnExprs).length);
            LinkedHashSet newRev = ContainerUtil.newLinkedHashSet();
            for (int j = 0; j < columnExprs.length; ++j) {
                SqlExpression expr = columnExprs[j];
                boolean curRev = false;
                if (expr instanceof SqlReferenceExpression) {
                    String string = ((SqlReferenceExpression)expr).getName();
                    PositioningNamingFamily positioningNamingFamily = obj.getTable().getColumns();
                    Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"obj.table.columns");
                    newNames.add(this.fixName(string, positioningNamingFamily));
                    curRev = this.isDesc((SqlReferenceExpression)expr);
                } else {
                    newNames.add(expr.getText());
                }
                if (!curRev) continue;
                newRev.add(newNames.get(newNames.size() - 1));
            }
            obj.setColNames(newNames);
            obj.setReverseColNames(newRev);
        }
    }

    private final boolean isDesc(SqlReferenceExpression expr) {
        for (PsiElement tmp = expr.getNextSibling(); tmp != null && !(tmp instanceof SqlExpression); tmp = tmp.getNextSibling()) {
            IElementType type;
            ASTNode aSTNode = tmp.getNode();
            Object object = type = aSTNode != null ? aSTNode.getElementType() : null;
            if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_ASC)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DESC)) continue;
            return true;
        }
        return false;
    }

    private final String fixName(String name, Family<?> src) {
        Object obj = this.findObject(name, src);
        if (obj == null || (obj = obj.getName()) == null) {
            obj = name;
        }
        return obj;
    }

    private final <T extends BasicElement> T findObject(String name, Family<T> src) {
        Object v0;
        block2: {
            if (name == null) {
                return null;
            }
            Iterable $receiver$iv = src;
            for (Object element$iv : $receiver$iv) {
                BasicElement it = (BasicElement)element$iv;
                if (!StringsKt.equals((String)name, (String)it.getName(), (boolean)true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return (T)((BasicElement)v0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getColumns(PsiElement el) {
        List list;
        SqlReferenceExpression[] sqlReferenceExpressionArray = (SqlReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlReferenceExpression.class);
        if (sqlReferenceExpressionArray != null) {
            void $receiver$iv$iv;
            Object[] $receiver$iv;
            Object[] objectArray = $receiver$iv = (Object[])sqlReferenceExpressionArray;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                void it;
                void item$iv$iv = $receiver$iv$iv[j];
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = it.getName();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final TrigEvent getEvent(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSERT)) {
            return TrigEvent.INSERT;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DELETE)) {
            return TrigEvent.DELETE;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_UPDATE) ? TrigEvent.UPDATE : null;
    }

    private final TrigTurn getTurn(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_BEFORE)) {
            return TrigTurn.BEFORE_ROW;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_AFTER)) {
            return TrigTurn.AFTER_ROW;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSTEAD) ? TrigTurn.INSTEAD_OF : null;
    }

    private final PsiElement skipUnsignificant(PsiElement el) {
        PsiElement tmp = el;
        while (tmp instanceof PsiWhiteSpace || tmp instanceof PsiComment) {
            tmp = tmp.getNextSibling();
        }
        return tmp;
    }

    private final SqliteOnConflictAlgorithm getConflictResolution(PsiElement def) {
        Object object;
        block3: {
            IElementType iElementType = SqliteTypes.SQLITE_CONFLICT_CLAUSE;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"SqliteTypes.SQLITE_CONFLICT_CLAUSE");
            PsiElement psiElement = this.findChild(def, iElementType);
            if (psiElement == null) {
                return null;
            }
            PsiElement onConflict = psiElement;
            PsiElement how = PsiTreeUtil.getDeepestLast((PsiElement)onConflict);
            String text2 = how.getText();
            Object[] $receiver$iv = (Object[])SqliteOnConflictAlgorithm.values();
            for (int j = 0; j < $receiver$iv.length; ++j) {
                Object element$iv = $receiver$iv[j];
                SqliteOnConflictAlgorithm it = (SqliteOnConflictAlgorithm)((Object)element$iv);
                if (!StringsKt.equals((String)it.toString(), (String)text2, (boolean)true)) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        SqliteOnConflictAlgorithm algo = (SqliteOnConflictAlgorithm)((Object)object);
        if (Intrinsics.areEqual((Object)((Object)algo), (Object)((Object)SqliteOnConflictAlgorithm.ABORT))) {
            return null;
        }
        return algo;
    }
}

