/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        if ("SqlDialectInspection" == null) {
            SqlDialectInspection.$$$reportNull$$$0(0);
        }
        return "SqlDialectInspection";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        LocalQuickFix[] localQuickFixArray;
        boolean addSelected;
        if (file == null) {
            SqlDialectInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlDialectInspection.$$$reportNull$$$0(2);
        }
        if (!isOnTheFly || !(file instanceof SqlFile) || ((SqlFile)file).getSqlLanguage() != DbSqlUtil.getGenericDialect()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = manager.getProject();
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file);
        VirtualFile vfile = topLevelFile.getVirtualFile();
        if (vfile instanceof LightVirtualFile || DbSrcUtils.isDbSrcFile(vfile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        String fileText = file.getText();
        CharSequence fileSnippet = fileText.subSequence(0, Math.min(fileText.length(), 10240));
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)project);
        HashMap dialectMap = ContainerUtil.newHashMap();
        MyMetric metric = new MyMetric();
        for (SqlLanguageDialect dialect : DbSqlUtil.getTopLevelSqlDialects()) {
            if (dialect.getDatabaseDialect().getFamilyId() == DatabaseFamilyId.UNKNOWN) continue;
            PsiFile sqlFile = fileFactory.createFileFromText("a.sql", (Language)dialect, fileSnippet);
            sqlFile.accept((PsiElementVisitor)metric);
            dialectMap.put(dialect, metric.getMetric());
        }
        ArrayList sortedDialects = ContainerUtil.newArrayList(dialectMap.keySet());
        Collections.sort(sortedDialects, (o1, o2) -> ((Double)dialectMap.get(o2)).compareTo((Double)dialectMap.get(o1)));
        if (sortedDialects.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SqlLanguageDialect topDialect = (SqlLanguageDialect)sortedDialects.get(0);
        double topMetric = (Double)dialectMap.get(topDialect);
        if (topMetric > 0.0 && topMetric < 10.0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList selectedNames = ContainerUtil.newArrayList();
        if (topMetric > 0.0) {
            for (SqlLanguageDialect dialect : sortedDialects) {
                if (!((Double)dialectMap.get(dialect) / topMetric > 0.9)) continue;
                selectedNames.add(dialect.getDisplayName());
            }
        }
        String message = "SQL dialect is not configured.";
        boolean bl = addSelected = selectedNames.size() < 4;
        if (selectedNames.size() > 0 && addSelected) {
            message = message + " " + StringUtil.join((Collection)selectedNames, (String)", ") + (selectedNames.size() == 1 ? " matches" : " match") + " best.";
        }
        MyQuickFix settingsFix = new MyQuickFix(null);
        if (topMetric > 0.0 && addSelected) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
            localQuickFixArray2[0] = new MyQuickFix(topDialect);
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[1] = settingsFix;
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[0] = settingsFix;
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)file, message, true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlDialectInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlDialectInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMetric
    extends PsiRecursiveElementWalkingVisitor {
        int errors;
        int composites;

        private MyMetric() {
        }

        public double getMetric() {
            try {
                double d = this.errors == 0 ? (double)this.composites : (double)this.composites / (double)this.errors;
                return d;
            }
            finally {
                this.errors = 0;
                this.composites = 0;
            }
        }

        public void visitElement(PsiElement element) {
            if (element instanceof PsiErrorElement) {
                ++this.errors;
            } else if (element instanceof SqlCompositeElement) {
                ++this.composites;
            }
            super.visitElement(element);
        }
    }

    public static class MyQuickFix
    extends IntentionAndQuickFixAction {
        private final SqlLanguageDialect myDialect;

        public MyQuickFix(@Nullable SqlLanguageDialect dialect) {
            this.myDialect = dialect;
        }

        @NotNull
        public String getName() {
            String string = this.myDialect == null ? "Change dialect to..." : "Use " + this.myDialect.getDisplayName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            boolean injected;
            PsiFile topLevelFile;
            VirtualFile virtualFile;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if ((virtualFile = (topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file)).getVirtualFile()) == null) {
                return;
            }
            boolean bl = injected = topLevelFile != file;
            if (virtualFile instanceof VirtualFileWindow) {
                virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            if (this.myDialect == null) {
                if (injected || !ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                    SqlDialectsConfigurable.openDialectsConfigurable(project, virtualFile);
                } else {
                    RelativePoint point = RelativePoint.fromScreen((Point)MouseInfo.getPointerInfo().getLocation());
                    ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<VirtualFile>)JBIterable.of((Object)virtualFile));
                    if (editor == null || !editor.getComponent().isShowing()) {
                        popup.show(point);
                    } else {
                        JRootPane rootPane = editor.getComponent().getRootPane();
                        Component componentAt = rootPane.findComponentAt(point.getPoint((Component)rootPane));
                        if (componentAt instanceof HyperlinkLabel) {
                            popup.setMinimumSize(componentAt.getSize());
                            popup.showUnderneathOf(componentAt);
                        } else {
                            popup.showInBestPositionFor(editor);
                        }
                    }
                }
            } else {
                ChangeDialectAction.setDialectImpl(project, virtualFile, (Language)this.myDialect, injected);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlDialectInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlDialectInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

