/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssColorHightlightAction
extends AnAction {
    @NonNls
    private static final String COLOR_DECLARATION = "color";

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor != null) {
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Document document = editor.getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile psiFile = documentManager.getPsiFile(document);
            if (psiFile != null && CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)psiFile)) {
                final MarkupModel model = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
                psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitElement(PsiElement element) {
                        CssColorHightlightAction.addRangeHighlighter(element, model);
                        super.visitElement(element);
                    }
                });
            }
        }
    }

    private static void addRangeHighlighter(@NotNull PsiElement element, @NotNull MarkupModel model) {
        if (element == null) {
            CssColorHightlightAction.$$$reportNull$$$0(0);
        }
        if (model == null) {
            CssColorHightlightAction.$$$reportNull$$$0(1);
        }
        if (element instanceof CssDeclaration) {
            CssTermList value;
            Color color;
            CssDeclaration declaration = (CssDeclaration)element;
            String name = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)declaration);
            if (declaration.isShorthandProperty()) {
                String[] names;
                for (String property : names = declaration.expandShorthandProperty()) {
                    PsiElement valueElement;
                    Color color2;
                    if (!property.contains(COLOR_DECLARATION)) continue;
                    PsiElement[] values = declaration.getShorthandPsiValue(property);
                    if (values != null && values.length > 0 && (color2 = CssPsiColorUtil.getColor(valueElement = values[0])) != null) {
                        TextAttributes atr = new TextAttributes();
                        atr.setBackgroundColor(color2);
                        TextRange range = valueElement.getTextRange();
                        model.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 0, atr, HighlighterTargetArea.EXACT_RANGE);
                    }
                    break;
                }
            } else if (name.contains(COLOR_DECLARATION) && (color = CssPsiColorUtil.getColor((PsiElement)(value = declaration.getValue()))) != null) {
                TextAttributes atr = new TextAttributes();
                atr.setBackgroundColor(color);
                if (value != null) {
                    TextRange range = value.getTextRange();
                    model.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 0, atr, HighlighterTargetArea.EXACT_RANGE);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/css/actions/CssColorHightlightAction";
        objectArray[2] = "addRangeHighlighter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

