/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class UninstantiableBindingInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("uninstantiable.binding.problem.descriptor", new Object[0]);
        if (string == null) {
            UninstantiableBindingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/UninstantiableBindingInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"to".equals(methodName)) {
                return;
            }
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            if (!(arg instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiTypeElement classTypeElement = ((PsiClassObjectAccessExpression)arg).getOperand();
            PsiType classType = classTypeElement.getType();
            if (!(classType instanceof PsiClassType)) {
                return;
            }
            PsiClass referentClass = ((PsiClassType)classType).resolve();
            if (referentClass == null) {
                return;
            }
            if (GuiceUtils.isInstantiable(referentClass)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!"com.google.inject.binder.LinkedBindingBuilder".equals(containingClass.getQualifiedName())) {
                return;
            }
            PsiClass moduleClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
            if (moduleClass != null && GuiceUtils.provides(moduleClass, referentClass)) {
                return;
            }
            this.registerError((PsiElement)classTypeElement, new Object[0]);
        }
    }
}

