/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.validation;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.validators.TrueValidator;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class ValidatorPanel
extends JPanel
implements Disposable {
    private static final String BLANK = " ";
    private final ListenerManager myListeners;
    private final Table<Validator.Severity, ObservableValue<?>, String> myMessages;
    private final BoolProperty myHasErrors;
    private JPanel myRootPanel;
    private JPanel mySouthPanel;
    private JBLabel myValidationLabel;

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel) {
        if (parentDisposable == null) {
            ValidatorPanel.$$$reportNull$$$0(0);
        }
        if (innerPanel == null) {
            ValidatorPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myMessages = HashBasedTable.create();
        this.myHasErrors = new BoolValueProperty();
        this.add(this.myRootPanel);
        this.myRootPanel.add(innerPanel);
        this.myValidationLabel.setName("ValidationLabel");
        this.myValidationLabel.setText(BLANK);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public <T> void registerValidator(@NotNull ObservableValue<T> value, @NotNull Validator<T> validator) {
        if (value == null) {
            ValidatorPanel.$$$reportNull$$$0(2);
        }
        if (validator == null) {
            ValidatorPanel.$$$reportNull$$$0(3);
        }
        this.myListeners.listenAndFire(value, sender -> {
            if (validator == null) {
                ValidatorPanel.$$$reportNull$$$0(14);
            }
            if (value == null) {
                ValidatorPanel.$$$reportNull$$$0(15);
            }
            Validator.Result result = validator.validate(value.get());
            this.myMessages.column((Object)value).clear();
            if (result.getSeverity() != Validator.Severity.OK) {
                this.myMessages.put((Object)result.getSeverity(), (Object)value, (Object)result.getMessage());
            }
            this.updateValidationLabel();
        });
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull Validator.Severity severity, @NotNull String message) {
        if (value == null) {
            ValidatorPanel.$$$reportNull$$$0(4);
        }
        if (severity == null) {
            ValidatorPanel.$$$reportNull$$$0(5);
        }
        if (message == null) {
            ValidatorPanel.$$$reportNull$$$0(6);
        }
        this.registerValidator(value, new TrueValidator(severity, message));
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull String message) {
        if (value == null) {
            ValidatorPanel.$$$reportNull$$$0(7);
        }
        if (message == null) {
            ValidatorPanel.$$$reportNull$$$0(8);
        }
        this.registerTest(value, Validator.Severity.ERROR, message);
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message, @NotNull Validator.Severity severity) {
        if (message == null) {
            ValidatorPanel.$$$reportNull$$$0(9);
        }
        if (severity == null) {
            ValidatorPanel.$$$reportNull$$$0(10);
        }
        this.registerValidator(message, value -> {
            if (severity == null) {
                ValidatorPanel.$$$reportNull$$$0(13);
            }
            if (value.isEmpty()) {
                return Validator.Result.OK;
            }
            return new Validator.Result(severity, (String)value);
        });
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message) {
        if (message == null) {
            ValidatorPanel.$$$reportNull$$$0(11);
        }
        this.registerMessageSource(message, Validator.Severity.ERROR);
    }

    @NotNull
    public ObservableBool hasErrors() {
        BoolProperty boolProperty = this.myHasErrors;
        if (boolProperty == null) {
            ValidatorPanel.$$$reportNull$$$0(12);
        }
        return boolProperty;
    }

    private void updateValidationLabel() {
        this.myValidationLabel.setIcon(null);
        this.myValidationLabel.setText(BLANK);
        boolean hasErrors = false;
        for (Validator.Severity severity : Validator.Severity.values()) {
            Iterator messages = this.myMessages.row((Object)severity).values().iterator();
            if (!messages.hasNext()) continue;
            this.myValidationLabel.setText((String)messages.next());
            this.myValidationLabel.setIcon(severity.getIcon());
            if (severity != Validator.Severity.ERROR) continue;
            hasErrors = true;
            break;
        }
        this.myHasErrors.set((Object)hasErrors);
    }

    public void dispose() {
        this.myListeners.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerPanel";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/validation/ValidatorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/validation/ValidatorPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "hasErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerValidator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerTest";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerMessageSource";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerMessageSource$1";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerValidator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 15));
        this.mySouthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "South");
        this.myValidationLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

