/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayeredPanel<T>
extends JBLayeredPane
implements SideModel.Listener<T>,
Disposable {
    private final String myBenchName;
    private final PropertiesComponent myPropertiesComponent;
    private final JComponent myDefaultLayer;
    private final ThreeComponentsSplitter mySplitter;
    private final JPanel myContainer;
    private String myToolName;
    private Side mySide;

    public LayeredPanel(@NotNull String benchName, @NotNull JComponent defaultLayer, @NotNull SideModel<T> model) {
        if (benchName == null) {
            LayeredPanel.$$$reportNull$$$0(0);
        }
        if (defaultLayer == null) {
            LayeredPanel.$$$reportNull$$$0(1);
        }
        if (model == null) {
            LayeredPanel.$$$reportNull$$$0(2);
        }
        this(benchName, defaultLayer, model, PropertiesComponent.getInstance());
    }

    public LayeredPanel(@NotNull String benchName, @NotNull JComponent defaultLayer, @NotNull SideModel<T> model, @NotNull PropertiesComponent propertiesComponent) {
        if (benchName == null) {
            LayeredPanel.$$$reportNull$$$0(3);
        }
        if (defaultLayer == null) {
            LayeredPanel.$$$reportNull$$$0(4);
        }
        if (model == null) {
            LayeredPanel.$$$reportNull$$$0(5);
        }
        if (propertiesComponent == null) {
            LayeredPanel.$$$reportNull$$$0(6);
        }
        this.myBenchName = benchName;
        this.myPropertiesComponent = propertiesComponent;
        this.myDefaultLayer = defaultLayer;
        this.myContainer = new JPanel();
        this.myContainer.setOpaque(false);
        this.myContainer.addComponentListener(this.createWidthUpdater());
        this.mySplitter = new ThreeComponentsSplitter();
        this.mySplitter.setOpaque(false);
        this.mySplitter.setInnerComponent((JComponent)this.myContainer);
        this.mySplitter.setDividerWidth(JBUI.scale((int)0));
        this.mySide = Side.LEFT;
        Disposer.register((Disposable)this, (Disposable)this.mySplitter);
        this.add(defaultLayer, DEFAULT_LAYER);
        this.add((Component)this.mySplitter, PALETTE_LAYER);
        model.addListener(this);
    }

    ThreeComponentsSplitter getSplitter() {
        return this.mySplitter;
    }

    @Override
    public void modelChanged(@NotNull SideModel<T> model, @NotNull SideModel.EventType unused) {
        if (model == null) {
            LayeredPanel.$$$reportNull$$$0(7);
        }
        if (unused == null) {
            LayeredPanel.$$$reportNull$$$0(8);
        }
        model.getHiddenSliders().forEach(this::addHiddenTool);
        this.addVisibleTool(model.getVisibleAutoHideTool());
        this.revalidate();
        this.repaint();
    }

    private void addVisibleTool(@Nullable AttachedToolWindow<T> tool) {
        if (tool == null) {
            this.mySplitter.setVisible(false);
            this.mySplitter.setFirstComponent(null);
            this.mySplitter.setLastComponent(null);
            this.myToolName = null;
        } else {
            JComponent component = tool.getComponent();
            component.setVisible(true);
            this.mySplitter.setVisible(true);
            this.myToolName = tool.getToolName();
            if (tool.isLeft()) {
                this.mySide = Side.LEFT;
                this.mySplitter.setFirstComponent(component);
                this.mySplitter.setFirstSize(this.getToolWidth(tool));
                this.mySplitter.setLastComponent(null);
                this.myContainer.setBorder(IdeBorderFactory.createBorder((int)1));
            } else {
                this.mySide = Side.RIGHT;
                this.mySplitter.setFirstComponent(null);
                this.mySplitter.setLastComponent(component);
                this.mySplitter.setLastSize(this.getToolWidth(tool));
                this.myContainer.setBorder(IdeBorderFactory.createBorder((int)4));
            }
        }
    }

    private void addHiddenTool(@NotNull AttachedToolWindow<T> tool) {
        if (tool == null) {
            LayeredPanel.$$$reportNull$$$0(9);
        }
        JComponent component = tool.getComponent();
        component.setVisible(false);
        this.myContainer.add((Component)component, PALETTE_LAYER);
    }

    public void doLayout() {
        this.myDefaultLayer.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.mySplitter.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    public void dispose() {
    }

    @NotNull
    private ComponentListener createWidthUpdater() {
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int width;
                int n = width = LayeredPanel.this.mySide.isLeft() ? LayeredPanel.this.mySplitter.getFirstSize() : LayeredPanel.this.mySplitter.getLastSize();
                if (LayeredPanel.this.myToolName != null && width > 0) {
                    LayeredPanel.this.setToolWidth(width);
                }
            }
        };
        if (componentAdapter == null) {
            LayeredPanel.$$$reportNull$$$0(10);
        }
        return componentAdapter;
    }

    @NotNull
    private String getUnscaledWidthPropertyName() {
        String string = "ATTACHED_TOOL_WINDOW." + this.myBenchName + "." + this.myToolName + ".UNSCALED.WIDTH";
        if (string == null) {
            LayeredPanel.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private String getScaledWidthPropertyName() {
        String string = "ATTACHED_TOOL_WINDOW." + this.myBenchName + "." + this.myToolName + ".WIDTH";
        if (string == null) {
            LayeredPanel.$$$reportNull$$$0(12);
        }
        return string;
    }

    private int getToolWidth(@NotNull AttachedToolWindow<T> tool) {
        int width;
        if (tool == null) {
            LayeredPanel.$$$reportNull$$$0(13);
        }
        if ((width = this.myPropertiesComponent.getInt(this.getUnscaledWidthPropertyName(), -1)) != -1) {
            return JBUI.scale((int)width);
        }
        int scaledWidth = this.myPropertiesComponent.getInt(this.getScaledWidthPropertyName(), -1);
        if (scaledWidth == -1) {
            return tool.getDefinition().getInitialMinimumWidth();
        }
        this.myPropertiesComponent.unsetValue(this.getScaledWidthPropertyName());
        this.setToolWidth(scaledWidth);
        return scaledWidth;
    }

    private void setToolWidth(int width) {
        this.myPropertiesComponent.setValue(this.getUnscaledWidthPropertyName(), AdtUiUtils.unscale(width), -1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "benchName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLayer";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unused";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/workbench/LayeredPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/workbench/LayeredPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createWidthUpdater";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnscaledWidthPropertyName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScaledWidthPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addHiddenTool";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getToolWidth";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

