/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.project.IntelliJProjectConfiguration;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class OutputChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.OutputChecker");
    private static final String JDK_HOME_STR = "!JDK_HOME!";
    protected final String myAppPath;
    private final String myOutputPath;
    public static final Key[] OUTPUT_ORDER = new Key[]{ProcessOutputTypes.SYSTEM, ProcessOutputTypes.STDOUT, ProcessOutputTypes.STDERR};
    private Map<Key, StringBuffer> myBuffers;
    protected String myTestName;
    private static final Pattern JDI_BUG_OUTPUT_PATTERN_1 = Pattern.compile("ERROR\\:\\s+JDWP\\s+Unable\\s+to\\s+get\\s+JNI\\s+1\\.2\\s+environment,\\s+jvm-\\>GetEnv\\(\\)\\s+return\\s+code\\s+=\\s+-2\n");
    private static final Pattern JDI_BUG_OUTPUT_PATTERN_2 = Pattern.compile("JDWP\\s+exit\\s+error\\s+AGENT_ERROR_NO_JNI_ENV.*\\]\n");

    public OutputChecker(String appPath, String outputPath) {
        this.myAppPath = appPath;
        this.myOutputPath = outputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String testName) {
        IdeaLogger.ourErrorsOccurred = null;
        this.myTestName = testName = Character.toLowerCase(testName.charAt(0)) + testName.substring(1);
        OutputChecker outputChecker = this;
        synchronized (outputChecker) {
            this.myBuffers = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String s, Key outputType) {
        OutputChecker outputChecker = this;
        synchronized (outputChecker) {
            if (this.myBuffers != null) {
                StringBuffer buffer = this.myBuffers.get(outputType);
                if (buffer == null) {
                    buffer = new StringBuffer();
                    this.myBuffers.put(outputType, buffer);
                }
                buffer.append(s);
            }
        }
    }

    public void println(String s, Key outputType) {
        this.print(s + "\n", outputType);
    }

    public void checkValid(Sdk jdk) throws Exception {
        this.checkValid(jdk, false);
    }

    @NotNull
    File getOutFile(File outs, Sdk jdk, @Nullable File current, String prefix) {
        File outFile;
        String name = this.myTestName + prefix;
        File res = new File(outs, name + ".out");
        if (current == null || res.exists()) {
            current = res;
        }
        if (JavaSdkUtil.isJdkAtLeast((Sdk)jdk, (JavaSdkVersion)JavaSdkVersion.JDK_1_9) && (outFile = new File(outs, name + ".jdk9.out")).exists()) {
            current = outFile;
        }
        File file = current;
        if (file == null) {
            OutputChecker.$$$reportNull$$$0(0);
        }
        return file;
    }

    public void checkValid(Sdk jdk, boolean sortClassPath) throws Exception {
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        String actual = this.preprocessBuffer(jdk, this.buildOutputString(), sortClassPath);
        File outs = new File(this.myAppPath + File.separator + "outs");
        assert (outs.exists() || outs.mkdirs()) : outs;
        File outFile = this.getOutFile(outs, jdk, null, "");
        if (!outFile.exists()) {
            if (SystemInfo.isWindows) {
                outFile = this.getOutFile(outs, jdk, outFile, ".win");
            } else if (SystemInfo.isUnix) {
                outFile = this.getOutFile(outs, jdk, outFile, ".unx");
            }
        }
        if (!outFile.exists()) {
            FileUtil.writeToFile((File)outFile, (String)actual);
            LOG.error("Test file created " + outFile.getPath() + "\n**************** Don't forget to put it into VCS! *******************");
        } else {
            String originalText = FileUtilRt.loadFile((File)outFile, (String)"UTF-8");
            String expected = StringUtilRt.convertLineSeparators((String)originalText);
            if (!expected.equals(actual)) {
                System.out.println("expected:");
                System.out.println(originalText);
                System.out.println("actual:");
                System.out.println(actual);
                int len = Math.min(expected.length(), actual.length());
                if (expected.length() != actual.length()) {
                    System.out.println("Text sizes differ: expected " + expected.length() + " but actual: " + actual.length());
                }
                if (expected.length() > len) {
                    System.out.println("Rest from expected text is: \"" + expected.substring(len) + "\"");
                } else if (actual.length() > len) {
                    System.out.println("Rest from actual text is: \"" + actual.substring(len) + "\"");
                }
                Assert.assertEquals((Object)originalText, (Object)actual);
            }
        }
    }

    public boolean contains(String str) {
        return this.buildOutputString().contains(str);
    }

    private synchronized String buildOutputString() {
        StringBuilder result = new StringBuilder();
        for (Key key : OUTPUT_ORDER) {
            StringBuffer buffer = this.myBuffers.get(key);
            if (buffer == null) continue;
            result.append(buffer.toString());
        }
        return result.toString();
    }

    private String preprocessBuffer(Sdk testJdk, final String buffer, final boolean sortClassPath) throws Exception {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return buffer;
        }
        return (String)application.runReadAction((ThrowableComputable)new ThrowableComputable<String, Exception>(){

            public String compute() throws UnknownHostException {
                String internalJdkHome = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk().getHomeDirectory().getPath();
                String result = buffer;
                result = StringUtil.replace((String)result, (String)"\r\n", (String)"\n");
                result = StringUtil.replace((String)result, (String)"\r", (String)"\n");
                result = OutputChecker.this.replaceAdditionalInOutput(result);
                result = OutputChecker.replacePath(result, OutputChecker.this.myAppPath, "!APP_PATH!");
                result = OutputChecker.replacePath(result, OutputChecker.this.myOutputPath, "!OUTPUT_PATH!");
                result = OutputChecker.replacePath(result, JavaSdkUtil.getIdeaRtJarPath(), "!RT_JAR!");
                String junit4JarPaths = StringUtil.join((Collection)IntelliJProjectConfiguration.getProjectLibraryClassesRootPaths((String)"JUnit4"), (String)File.pathSeparator);
                result = OutputChecker.replacePath(result, junit4JarPaths, "!JUNIT4_JARS!");
                result = StringUtil.replace((String)result, (String)InetAddress.getLocalHost().getCanonicalHostName(), (String)"!HOST_NAME!", (boolean)true);
                result = StringUtil.replace((String)result, (String)InetAddress.getLocalHost().getHostName(), (String)"!HOST_NAME!", (boolean)true);
                result = StringUtil.replace((String)result, (String)"127.0.0.1", (String)"!HOST_NAME!", (boolean)false);
                result = OutputChecker.replacePath(result, internalJdkHome, OutputChecker.JDK_HOME_STR);
                File productionFile = new File(PathUtil.getJarPathForClass(OutputChecker.class));
                if (productionFile.isDirectory()) {
                    result = OutputChecker.replacePath(result, StringUtil.trimTrailing((String)productionFile.getParentFile().toURI().toString(), (char)'/'), "!PRODUCTION_PATH!");
                }
                result = OutputChecker.replacePath(result, PathManager.getHomePath(), "!IDEA_HOME!");
                result = StringUtil.replace((String)result, (String)"Process finished with exit code 255", (String)"Process finished with exit code -1");
                result = result.replaceAll("!HOST_NAME!:\\d*", "!HOST_NAME!:!HOST_PORT!");
                result = result.replaceAll("at \\'.*?\\'", "at '!HOST_NAME!:PORT_NAME!'");
                result = result.replaceAll("address: \\'.*?\\'", "address: '!HOST_NAME!:PORT_NAME!'");
                result = result.replaceAll("\"?file:.*AppletPage.*\\.html\"?", "file:!APPLET_HTML!");
                result = result.replaceAll("\"(!JDK_HOME!.*?)\"", "$1");
                result = result.replaceAll("\"(!APP_PATH!.*?)\"", "$1");
                result = result.replaceAll("\"(-D.*?)\"", "$1");
                result = result.replaceAll(" -javaagent:.*props", "");
                result = result.replaceAll("-Didea.launcher.port=\\d*", "-Didea.launcher.port=!IDEA_LAUNCHER_PORT!");
                result = result.replaceAll("-Dfile.encoding=[\\w\\d-]*", "-Dfile.encoding=!FILE_ENCODING!");
                result = result.replaceAll("\\((.*)\\:\\d+\\)", "($1:!LINE_NUMBER!)");
                result = OutputChecker.fixSlashes(result, OutputChecker.JDK_HOME_STR);
                result = OutputChecker.stripQuotesAroundClasspath(result);
                Matcher matcher = Pattern.compile("-classpath\\s+(\\S+)\\s+").matcher(result);
                while (matcher.find()) {
                    String classPath = matcher.group(1);
                    String[] classPathElements = classPath.split(File.pathSeparator);
                    ArrayList<String> classpathRes = new ArrayList<String>();
                    boolean hasJdkJars = false;
                    for (String element : classPathElements) {
                        if (!element.startsWith(OutputChecker.JDK_HOME_STR)) {
                            classpathRes.add(element);
                            continue;
                        }
                        hasJdkJars = true;
                    }
                    if (hasJdkJars) {
                        classpathRes.add("!JDK_JARS!");
                    }
                    if (sortClassPath) {
                        Collections.sort(classpathRes);
                    }
                    String sortedPath = StringUtil.join(classpathRes, (String)";");
                    result = StringUtil.replace((String)result, (String)classPath, (String)sortedPath);
                }
                result = JDI_BUG_OUTPUT_PATTERN_1.matcher(result).replaceAll("");
                result = JDI_BUG_OUTPUT_PATTERN_2.matcher(result).replaceAll("");
                return result;
            }
        });
    }

    protected static String replacePath(String result, String path, String replacement) {
        result = StringUtil.replace((String)result, (String)FileUtil.toSystemDependentName((String)path), (String)replacement, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
        result = StringUtil.replace((String)result, (String)FileUtil.toSystemIndependentName((String)path), (String)replacement, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
        return result;
    }

    @NotNull
    private static String fixSlashes(String text, String jdkHomeMarker) {
        int commandLineStart = text.indexOf(jdkHomeMarker);
        while (commandLineStart != -1) {
            char c;
            StringBuilder builder = new StringBuilder(text);
            for (int i = commandLineStart + 1; i < builder.length() && (c = builder.charAt(i)) != '\n'; ++i) {
                if (c != File.separatorChar) continue;
                builder.setCharAt(i, '\\');
            }
            text = builder.toString();
            commandLineStart = text.indexOf(jdkHomeMarker, commandLineStart + 1);
        }
        String string = text;
        if (string == null) {
            OutputChecker.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected String replaceAdditionalInOutput(String str) {
        return str;
    }

    private static String stripQuotesAroundClasspath(String result) {
        int spaceIdx;
        String clsp = "-classpath ";
        int clspIdx = 0;
        while ((clspIdx = result.indexOf("-classpath ", clspIdx)) > -1 && (spaceIdx = result.indexOf(" ", clspIdx + "-classpath ".length())) > -1) {
            result = result.substring(0, clspIdx) + "-classpath " + StringUtil.stripQuotesAroundValue((String)result.substring(clspIdx + "-classpath ".length(), spaceIdx)) + result.substring(spaceIdx);
            clspIdx += "-classpath ".length();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/impl/OutputChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fixSlashes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

