/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.ChooseTemplateStep;
import com.intellij.ide.projectWizard.ProjectTypeStep;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectWizardTestCase<T extends AbstractProjectWizard>
extends PlatformTestCase {
    protected static final String DEFAULT_SDK = "default";
    protected T myWizard;
    @Nullable
    private Project myCreatedProject;
    private Sdk myOldDefaultProjectSdk;

    protected Project createProjectFromTemplate(@NotNull String group, @Nullable String name, @Nullable Consumer<Step> adjuster) throws IOException {
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(0);
        }
        this.runWizard(group, name, null, adjuster);
        try {
            this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard, null);
        }
        catch (Throwable e) {
            this.myCreatedProject = (Project)ContainerUtil.find((Object[])this.myProjectManager.getOpenProjects(), project -> this.myWizard.getProjectName().equals(project.getName()));
            throw new RuntimeException(e);
        }
        ProjectWizardTestCase.assertNotNull((Object)this.myCreatedProject);
        UIUtil.dispatchAllInvocationEvents();
        Project[] projects = this.myProjectManager.getOpenProjects();
        ProjectWizardTestCase.assertEquals((String)Arrays.asList(projects).toString(), (int)2, (int)projects.length);
        return this.myCreatedProject;
    }

    @Nullable
    protected Module createModuleFromTemplate(String group, String name, @Nullable Consumer<Step> adjuster) throws IOException {
        this.runWizard(group, name, this.getProject(), adjuster);
        return this.createModuleFromWizard();
    }

    protected Module createModuleFromWizard() {
        return new NewModuleAction().createModuleFromWizard(this.myProject, null, this.myWizard);
    }

    protected void runWizard(@NotNull String group, @Nullable String name, Project project, @Nullable Consumer<Step> adjuster) throws IOException {
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(1);
        }
        this.createWizard(project);
        ProjectTypeStep step = (ProjectTypeStep)this.myWizard.getCurrentStepObject();
        if (!step.setSelectedTemplate(group, name)) {
            throw new IllegalArgumentException(group + '/' + name + " template not found, available groups " + step.availableTemplateGroupsToString());
        }
        this.runWizard((Consumer<Step>)((Consumer)step1 -> {
            if (name != null && step1 instanceof ChooseTemplateStep) {
                ((ChooseTemplateStep)step1).setSelectedTemplate(name);
            }
            if (adjuster != null) {
                adjuster.consume(step1);
            }
        }));
    }

    protected void runWizard(@Nullable Consumer<Step> adjuster) {
        block2: {
            ModuleWizardStep currentStep;
            do {
                currentStep = (ModuleWizardStep)this.myWizard.getCurrentStepObject();
                if (adjuster != null) {
                    adjuster.consume((Object)currentStep);
                }
                if (this.myWizard.isLast()) break block2;
                this.myWizard.doNextAction();
            } while (currentStep != this.myWizard.getCurrentStepObject());
            throw new RuntimeException(currentStep + " is not validated");
        }
        this.myWizard.doFinishAction();
    }

    protected void createWizard(Project project) throws IOException {
        File directory = FileUtil.createTempDirectory((String)this.getName(), (String)"new", (boolean)false);
        myFilesToDelete.add(directory);
        this.myWizard = this.createWizard(project, directory);
        UIUtil.dispatchAllInvocationEvents();
    }

    protected Project createProject(Consumer<Step> adjuster) throws IOException {
        this.createWizard(null);
        this.runWizard(adjuster);
        this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard, null);
        return this.myCreatedProject;
    }

    protected T createWizard(Project project, File directory) {
        throw new RuntimeException();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myOldDefaultProjectSdk = ProjectRootManager.getInstance((Project)this.myProjectManager.getDefaultProject()).getProjectSdk();
        Sdk projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
        for (Sdk jdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (projectSdk == jdk) continue;
            ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(jdk));
        }
    }

    protected void configureJdk() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.addSdk(new SimpleJavaSdkType().createJdk(DEFAULT_SDK, SystemProperties.getJavaHome()));
            this.addSdk(new SimpleJavaSdkType().createJdk("_other", SystemProperties.getJavaHome()));
            System.out.println("ProjectWizardTestCase.configureJdk:");
            System.out.println(Arrays.asList(ProjectJdkTable.getInstance().getAllJdks()));
        });
    }

    protected void addSdk(Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
    }

    public void tearDown() throws Exception {
        try {
            if (this.myWizard != null) {
                Disposer.dispose((Disposable)this.myWizard.getDisposable());
                this.myWizard = null;
            }
            if (this.myCreatedProject != null) {
                this.myProjectManager.closeProject(this.myCreatedProject);
                ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)this.myCreatedProject));
                this.myCreatedProject = null;
            }
            ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)this.myProjectManager.getDefaultProject()).setProjectSdk(this.myOldDefaultProjectSdk));
            SelectTemplateSettings.getInstance().setLastTemplate(null, null);
        }
        finally {
            super.tearDown();
        }
    }

    protected Module importModuleFrom(ProjectImportProvider provider, String path) {
        return this.importFrom(path, this.getProject(), null, provider);
    }

    protected Module importProjectFrom(String path, Consumer<Step> adjuster, ProjectImportProvider ... providers) {
        Module module = this.importFrom(path, null, adjuster, providers);
        if (module != null) {
            this.myCreatedProject = module.getProject();
        }
        return module;
    }

    private Module importFrom(String path, @Nullable Project project, Consumer<Step> adjuster, ProjectImportProvider ... providers) {
        return ProjectWizardTestCase.computeInWriteSafeContext(() -> this.doImportModule(path, project, adjuster, providers));
    }

    private Module doImportModule(String path, @Nullable Project project, Consumer<Step> adjuster, ProjectImportProvider[] providers) {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        ProjectWizardTestCase.assertNotNull((String)("Can't find " + path), (Object)file);
        ProjectWizardTestCase.assertTrue((boolean)providers[0].canImport(file, project));
        this.myWizard = ImportModuleAction.createImportWizard((Project)project, null, (VirtualFile)file, (ProjectImportProvider[])providers);
        ProjectWizardTestCase.assertNotNull(this.myWizard);
        if (this.myWizard.getStepCount() > 0) {
            this.runWizard(adjuster);
        }
        return (Module)ContainerUtil.getFirstItem((List)ImportModuleAction.createFromWizard((Project)project, this.myWizard));
    }

    private static <T> T computeInWriteSafeContext(Supplier<T> supplier) {
        Ref module = Ref.create();
        ApplicationManager.getApplication().invokeLater(() -> module.set(supplier.get()));
        UIUtil.dispatchAllInvocationEvents();
        return (T)module.get();
    }

    protected Sdk createSdk(String name, SdkTypeId sdkType) {
        Sdk sdk = ProjectJdkTable.getInstance().createSdk(name, sdkType);
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
        return sdk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "group";
        objectArray2[1] = "com/intellij/ide/projectWizard/ProjectWizardTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createProjectFromTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runWizard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

