/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.EventsTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import io.grpc.StatusRuntimeException;

public class EventDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private int myProcessId = -1;
    private final Common.Session mySession;
    private final EventsTable myEventsTable;
    private final EventServiceGrpc.EventServiceBlockingStub myEventPollingService;

    public EventDataPoller(int processId, Common.Session session, EventsTable eventTable, EventServiceGrpc.EventServiceBlockingStub pollingService) {
        super(POLLING_DELAY_NS);
        this.myProcessId = processId;
        this.myEventsTable = eventTable;
        this.myEventPollingService = pollingService;
        this.mySession = session;
    }

    @Override
    public void poll() throws StatusRuntimeException {
        if (this.myProcessId == -1) {
            return;
        }
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setProcessId(this.myProcessId).setStartTimestamp(this.myDataRequestStartTimestampNs).setEndTimestamp(Long.MAX_VALUE);
        EventProfiler.ActivityDataResponse activityResponse = this.myEventPollingService.getActivityData(dataRequestBuilder.build());
        for (EventProfiler.ActivityData data : activityResponse.getDataList()) {
            long id = data.getHash();
            EventProfiler.ActivityData cached_data = this.myEventsTable.findActivityDataOrNull(data.getProcessId(), id, this.mySession);
            if (cached_data != null) {
                EventProfiler.ActivityData.Builder builder = cached_data.toBuilder();
                for (EventProfiler.ActivityStateData state : data.getStateChangesList()) {
                    if (!cached_data.getStateChangesList().contains(state)) {
                        builder.addStateChanges(state);
                    }
                    if (state.getTimestamp() <= this.myDataRequestStartTimestampNs) continue;
                    this.myDataRequestStartTimestampNs = state.getTimestamp();
                }
                this.myEventsTable.insertOrReplace(id, this.mySession, builder.build());
                continue;
            }
            this.myEventsTable.insertOrReplace(id, this.mySession, data);
            for (EventProfiler.ActivityStateData state : data.getStateChangesList()) {
                if (state.getTimestamp() <= this.myDataRequestStartTimestampNs) continue;
                this.myDataRequestStartTimestampNs = state.getTimestamp();
            }
        }
        EventProfiler.SystemDataResponse systemResponse = this.myEventPollingService.getSystemData(dataRequestBuilder.build());
        for (EventProfiler.SystemData data : systemResponse.getDataList()) {
            long id = data.getEventId();
            this.myEventsTable.insertOrReplace(id, this.mySession, data);
        }
    }
}

