/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.CpuTable;
import com.android.tools.datastore.poller.CpuDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class CpuService
extends CpuServiceGrpc.CpuServiceImplBase
implements ServicePassThrough {
    private final Map<Integer, PollRunner> myRunners;
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private final CpuTable myCpuTable;
    @NotNull
    private final DataStoreService myService;
    private ResponseData<CpuProfiler.CpuDataResponse> myLastCpuResponse;
    private ResponseData<CpuProfiler.GetThreadsResponse> myLastThreadsResponse;
    private ResponseData<CpuProfiler.GetTraceInfoResponse> myLastTraceInfoResponse;

    public CpuService(@NotNull DataStoreService dataStoreService, Consumer<Runnable> fetchExecutor, @NotNull Map<Common.Session, Long> sessionIdLookup) {
        if (dataStoreService == null) {
            CpuService.$$$reportNull$$$0(0);
        }
        if (sessionIdLookup == null) {
            CpuService.$$$reportNull$$$0(1);
        }
        this.myRunners = new HashMap<Integer, PollRunner>();
        this.myLastCpuResponse = ResponseData.createEmpty();
        this.myLastThreadsResponse = ResponseData.createEmpty();
        this.myLastTraceInfoResponse = ResponseData.createEmpty();
        this.myFetchExecutor = fetchExecutor;
        this.myService = dataStoreService;
        this.myCpuTable = new CpuTable(sessionIdLookup);
    }

    public void getData(CpuProfiler.CpuDataRequest request, StreamObserver<CpuProfiler.CpuDataResponse> observer) {
        if (!this.myLastCpuResponse.matches(request.getProcessId(), request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            CpuProfiler.CpuDataResponse.Builder response = CpuProfiler.CpuDataResponse.newBuilder();
            List<CpuProfiler.CpuProfilerData> cpuData = this.myCpuTable.getCpuDataByRequest(request);
            for (CpuProfiler.CpuProfilerData data : cpuData) {
                response.addData(data);
            }
            this.myLastCpuResponse = new ResponseData(request.getProcessId(), request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        observer.onNext((Object)this.myLastCpuResponse.getResponse());
        observer.onCompleted();
    }

    public void getThreads(CpuProfiler.GetThreadsRequest request, StreamObserver<CpuProfiler.GetThreadsResponse> observer) {
        if (!this.myLastThreadsResponse.matches(request.getProcessId(), request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            CpuProfiler.GetThreadsResponse.Builder response = CpuProfiler.GetThreadsResponse.newBuilder();
            response.addAllThreads(this.myCpuTable.getThreadsDataByRequest(request));
            this.myLastThreadsResponse = new ResponseData(request.getProcessId(), request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        observer.onNext((Object)this.myLastThreadsResponse.getResponse());
        observer.onCompleted();
    }

    public void getTraceInfo(CpuProfiler.GetTraceInfoRequest request, StreamObserver<CpuProfiler.GetTraceInfoResponse> responseObserver) {
        if (!this.myLastTraceInfoResponse.matches(request.getProcessId(), request.getSession(), request.getFromTimestamp(), request.getToTimestamp())) {
            CpuProfiler.GetTraceInfoResponse.Builder response = CpuProfiler.GetTraceInfoResponse.newBuilder();
            List<CpuProfiler.TraceInfo> responses = this.myCpuTable.getTraceInfo(request);
            response.addAllTraceInfo(responses);
            this.myLastTraceInfoResponse = new ResponseData(request.getProcessId(), request.getSession(), request.getFromTimestamp(), request.getToTimestamp(), response.build());
        }
        responseObserver.onNext((Object)this.myLastTraceInfoResponse.getResponse());
        responseObserver.onCompleted();
    }

    public void saveTraceInfo(CpuProfiler.SaveTraceInfoRequest request, StreamObserver<CpuProfiler.EmptyCpuReply> responseObserver) {
        this.myCpuTable.insertTraceInfo(request.getProcessId(), request.getTraceInfo(), request.getSession());
        responseObserver.onNext((Object)CpuProfiler.EmptyCpuReply.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void startMonitoringApp(CpuProfiler.CpuStartRequest request, StreamObserver<CpuProfiler.CpuStartResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession());
        if (client != null) {
            observer.onNext((Object)client.startMonitoringApp(request));
            observer.onCompleted();
            int processId = request.getProcessId();
            this.myRunners.put(processId, new CpuDataPoller(processId, request.getSession(), this.myCpuTable, this.myService.getCpuClient(request.getSession())));
            this.myFetchExecutor.accept(this.myRunners.get(processId));
        } else {
            observer.onNext((Object)CpuProfiler.CpuStartResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    public void stopMonitoringApp(CpuProfiler.CpuStopRequest request, StreamObserver<CpuProfiler.CpuStopResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub service;
        int processId = request.getProcessId();
        PollRunner runner = this.myRunners.remove(processId);
        if (runner != null) {
            runner.stop();
        }
        if ((service = this.myService.getCpuClient(request.getSession())) == null) {
            observer.onNext((Object)CpuProfiler.CpuStopResponse.getDefaultInstance());
        } else {
            observer.onNext((Object)service.stopMonitoringApp(request));
        }
        observer.onCompleted();
    }

    public void startProfilingApp(CpuProfiler.CpuProfilingAppStartRequest request, StreamObserver<CpuProfiler.CpuProfilingAppStartResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession());
        if (client != null) {
            observer.onNext((Object)client.startProfilingApp(request));
        } else {
            observer.onNext((Object)CpuProfiler.CpuProfilingAppStartResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void stopProfilingApp(CpuProfiler.CpuProfilingAppStopRequest request, StreamObserver<CpuProfiler.CpuProfilingAppStopResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession());
        CpuProfiler.CpuProfilingAppStopResponse response = CpuProfiler.CpuProfilingAppStopResponse.getDefaultInstance();
        if (client != null) {
            response = client.stopProfilingApp(request);
            this.myCpuTable.insertTrace(request.getProcessId(), response.getTraceId(), request.getSession(), request.getProfilerType(), response.getTrace());
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void checkAppProfilingState(CpuProfiler.ProfilingStateRequest request, StreamObserver<CpuProfiler.ProfilingStateResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession());
        if (client != null) {
            observer.onNext((Object)client.checkAppProfilingState(request));
        } else {
            observer.onNext((Object)CpuProfiler.ProfilingStateResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void getTrace(CpuProfiler.GetTraceRequest request, StreamObserver<CpuProfiler.GetTraceResponse> observer) {
        CpuTable.TraceData data = this.myCpuTable.getTraceData(request.getProcessId(), request.getTraceId(), request.getSession());
        CpuProfiler.GetTraceResponse.Builder builder = CpuProfiler.GetTraceResponse.newBuilder();
        if (data == null) {
            builder.setStatus(CpuProfiler.GetTraceResponse.Status.FAILURE);
        } else {
            builder.setStatus(CpuProfiler.GetTraceResponse.Status.SUCCESS).setData(data.getTraceBytes()).setProfilerType(data.getProfilerType());
        }
        observer.onNext((Object)builder.build());
        observer.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        if (list == null) {
            CpuService.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            CpuService.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            CpuService.$$$reportNull$$$0(4);
        }
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myCpuTable.initialize(connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStoreService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionIdLookup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/CpuService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/CpuService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResponseData<T> {
        private int myProcessId;
        private Common.Session mySession;
        private long myStart;
        private long myEnd;
        private T myResponse;

        private ResponseData(int processId, Common.Session session, long startTimestamp, long endTimestamp, T response) {
            this.myProcessId = processId;
            this.mySession = session;
            this.myStart = startTimestamp;
            this.myEnd = endTimestamp;
            this.myResponse = response;
        }

        public boolean matches(int processId, Common.Session session, long startTimestamp, long endTimestamp) {
            boolean isSessionEquals = this.mySession == null && session == null || this.mySession != null && this.mySession.equals((Object)session);
            return isSessionEquals && this.myProcessId == processId && this.myStart == startTimestamp && this.myEnd == endTimestamp;
        }

        public T getResponse() {
            return this.myResponse;
        }

        public static ResponseData createEmpty() {
            return new ResponseData<Object>(0, null, 0L, 0L, null);
        }
    }
}

