/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class CpuThreadsTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final CpuProfilerStage.ThreadsTooltip myTooltip;
    @NotNull
    private final JLabel myContent;
    @NotNull
    private final ProfilerTimeline myTimeline;
    private int myMaximumLabelWidth;

    protected CpuThreadsTooltipView(@NotNull CpuProfilerStageView view, @NotNull CpuProfilerStage.ThreadsTooltip tooltip) {
        if (view == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(0);
        }
        if (tooltip == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(1);
        }
        super(view.getTimeline(), "CPU");
        this.myMaximumLabelWidth = 0;
        this.myLabel.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(11.0f));
        this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        this.myTimeline = view.getTimeline();
        this.myTooltip = tooltip;
        this.myContent = new JLabel();
        this.myContent.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.myContent.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        tooltip.addDependency(this).onChange((Enum)CpuProfilerStage.ThreadsTooltip.Aspect.THREAD_STATE, this::threadStateChanged);
    }

    @Override
    protected void timeChanged() {
        Range range = this.myTimeline.getTooltipRange();
        if (!range.isEmpty()) {
            String time = TimeAxisFormatter.DEFAULT.getFormattedString(this.myTimeline.getDataRange().getLength(), range.getMin() - this.myTimeline.getDataRange().getMin(), true);
            String title = this.myTooltip.getThreadName() != null ? this.myTooltip.getThreadName() : "CPU";
            this.myLabel.setText(String.format("<html>%s <span style='color:#%s'>%s</span></html", title, ColorUtil.toHex((Color)ProfilerColors.CPU_THREADS_TOOLTIP_TIME_COLOR), time));
            this.myMaximumLabelWidth = Math.max(this.myMaximumLabelWidth, this.myLabel.getWidth());
            this.myLabel.setMinimumSize(new Dimension(this.myMaximumLabelWidth, 0));
        } else {
            this.myLabel.setText("");
        }
    }

    private void threadStateChanged() {
        String state = this.myTooltip.getThreadState() == null ? "" : this.threadStateToString(this.myTooltip.getThreadState());
        this.myContent.setText(state);
    }

    @Override
    protected Component createTooltip() {
        return this.myContent;
    }

    private String threadStateToString(@NotNull CpuProfilerStage.ThreadState state) {
        if (state == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(2);
        }
        switch (state) {
            case RUNNING: 
            case RUNNING_CAPTURED: {
                return "Running";
            }
            case SLEEPING: 
            case SLEEPING_CAPTURED: {
                return "Sleeping";
            }
            case DEAD: 
            case DEAD_CAPTURED: {
                return "Dead";
            }
            case WAITING: 
            case WAITING_CAPTURED: {
                return "Waiting";
            }
        }
        return "Unknown";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadsTooltipView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "threadStateToString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

