/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.CpuProfiler;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ProfilingConfiguration {
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    public static final int DEFAULT_SAMPLING_INTERVAL_US = 1000;
    public static final String ART_SAMPLED = "Sampled";
    public static final String ART_INSTRUMENTED = "Instrumented";
    public static final String SIMPLEPERF = "Sampled (Hybrid)";
    private static List<ProfilingConfiguration> ourDefaultConfigurations;
    private String myName;
    private CpuProfiler.CpuProfilerType myProfilerType;
    private CpuProfiler.CpuProfilingAppStartRequest.Mode myMode;
    private int myProfilingBufferSizeInMb = 8;
    private int myProfilingSamplingIntervalUs = 1000;

    public ProfilingConfiguration() {
    }

    public ProfilingConfiguration(String name, CpuProfiler.CpuProfilerType profilerType, CpuProfiler.CpuProfilingAppStartRequest.Mode mode) {
        this.myName = name;
        this.myProfilerType = profilerType;
        this.myMode = mode;
    }

    public CpuProfiler.CpuProfilingAppStartRequest.Mode getMode() {
        return this.myMode;
    }

    public void setMode(CpuProfiler.CpuProfilingAppStartRequest.Mode mode) {
        this.myMode = mode;
    }

    public CpuProfiler.CpuProfilerType getProfilerType() {
        return this.myProfilerType;
    }

    public void setProfilerType(CpuProfiler.CpuProfilerType profilerType) {
        this.myProfilerType = profilerType;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public int getProfilingBufferSizeInMb() {
        return this.myProfilingBufferSizeInMb;
    }

    public void setProfilingBufferSizeInMb(int profilingBufferSizeInMb) {
        this.myProfilingBufferSizeInMb = profilingBufferSizeInMb;
    }

    public int getProfilingSamplingIntervalUs() {
        return this.myProfilingSamplingIntervalUs;
    }

    public void setProfilingSamplingIntervalUs(int profilingSamplingIntervalUs) {
        this.myProfilingSamplingIntervalUs = profilingSamplingIntervalUs;
    }

    public static List<ProfilingConfiguration> getDefaultProfilingConfigurations() {
        if (ourDefaultConfigurations == null) {
            ProfilingConfiguration artSampled = new ProfilingConfiguration(ART_SAMPLED, CpuProfiler.CpuProfilerType.ART, CpuProfiler.CpuProfilingAppStartRequest.Mode.SAMPLED);
            ProfilingConfiguration artInstrumented = new ProfilingConfiguration(ART_INSTRUMENTED, CpuProfiler.CpuProfilerType.ART, CpuProfiler.CpuProfilingAppStartRequest.Mode.INSTRUMENTED);
            ProfilingConfiguration simpleperf = new ProfilingConfiguration(SIMPLEPERF, CpuProfiler.CpuProfilerType.SIMPLE_PERF, CpuProfiler.CpuProfilingAppStartRequest.Mode.SAMPLED);
            ourDefaultConfigurations = ImmutableList.of((Object)artSampled, (Object)artInstrumented, (Object)simpleperf);
        }
        return ourDefaultConfigurations;
    }
}

