/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.stacktrace;

import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CodeNavigator {
    private final List<Listener> myListeners;
    @NotNull
    private final FeatureTracker myFeatureTracker;

    public CodeNavigator(@NotNull FeatureTracker featureTracker) {
        if (featureTracker == null) {
            CodeNavigator.$$$reportNull$$$0(0);
        }
        this.myListeners = Lists.newArrayList();
        this.myFeatureTracker = featureTracker;
    }

    public final void addListener(@NotNull Listener listener) {
        if (listener == null) {
            CodeNavigator.$$$reportNull$$$0(1);
        }
        this.myListeners.add(listener);
    }

    public final void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            CodeNavigator.$$$reportNull$$$0(2);
        }
        this.myListeners.remove(listener);
    }

    public final void navigate(@NotNull CodeLocation location) {
        if (location == null) {
            CodeNavigator.$$$reportNull$$$0(3);
        }
        this.handleNavigate(location);
        this.myListeners.forEach(l -> {
            if (location == null) {
                CodeNavigator.$$$reportNull$$$0(4);
            }
            l.onNavigated(location);
        });
        this.myFeatureTracker.trackNavigateToCode();
    }

    protected abstract void handleNavigate(@NotNull CodeLocation var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/stacktrace/CodeNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$navigate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void onNavigated(@NotNull CodeLocation var1);
    }
}

