/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.util.ObservableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.ClassLoaderAwareTaskAction;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.DefaultTaskDestroyables;
import org.gradle.api.internal.tasks.DefaultTaskInputs;
import org.gradle.api.internal.tasks.DefaultTaskLocalState;
import org.gradle.api.internal.tasks.DefaultTaskOutputs;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskLocalStateInternal;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.DefaultTaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskDestroyables;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.api.tasks.TaskLocalState;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Collections2;
import org.gradle.internal.logging.compatbridge.LoggingManagerInternalCompatibilityBridge;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.scripts.ScriptOrigin;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask
implements TaskInternal,
DynamicObjectAware {
    private static final Logger BUILD_LOGGER = Logging.getLogger(Task.class);
    private static final ThreadLocal<TaskInfo> NEXT_INSTANCE = new ThreadLocal();
    private final ProjectInternal project;
    private final String name;
    private List<ContextAwareTaskAction> actions;
    private Path path;
    private Path identityPath;
    private boolean enabled = true;
    private final DefaultTaskDependency dependencies;
    private final DefaultTaskDependency mustRunAfter;
    private final DefaultTaskDependency finalizedBy;
    private final DefaultTaskDependency shouldRunAfter;
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private String group;
    private AndSpec<Task> onlyIfSpec = this.createNewOnlyIfSpec();
    private TaskExecuter executer;
    private final ServiceRegistry services;
    private final TaskStateInternal state;
    private final TaskMutator taskMutator;
    private ObservableList observableActionList;
    private boolean impliesSubProjects;
    private boolean hasCustomActions;
    private final TaskInputsInternal taskInputs;
    private final TaskOutputsInternal taskOutputs;
    private final TaskDestroyables taskDestroyables;
    private final TaskLocalStateInternal taskLocalState;
    private final Class<? extends Task> publicType;
    private LoggingManagerInternal loggingManager;
    private String toStringValue;

    protected AbstractTask() {
        this(AbstractTask.taskInfo());
    }

    private static TaskInfo taskInfo() {
        return NEXT_INSTANCE.get();
    }

    private AbstractTask(TaskInfo taskInfo) {
        if (taskInfo == null) {
            throw new TaskInstantiationException(String.format("Task of type '%s' has been instantiated directly which is not supported. Tasks can only be created using the DSL.", this.getClass().getName()));
        }
        this.project = taskInfo.project;
        this.name = taskInfo.name;
        this.publicType = taskInfo.publicType;
        assert (this.project != null);
        assert (this.name != null);
        this.state = new TaskStateInternal();
        TaskContainerInternal tasks = this.project.getTasks();
        this.dependencies = new DefaultTaskDependency(tasks);
        this.mustRunAfter = new DefaultTaskDependency(tasks);
        this.finalizedBy = new DefaultTaskDependency(tasks);
        this.shouldRunAfter = new DefaultTaskDependency(tasks);
        this.services = this.project.getServices();
        FileResolver fileResolver = this.project.getFileResolver();
        this.taskMutator = new TaskMutator(this);
        this.taskInputs = new DefaultTaskInputs(fileResolver, this, this.taskMutator);
        this.taskOutputs = new DefaultTaskOutputs(fileResolver, this, this.taskMutator);
        this.taskDestroyables = new DefaultTaskDestroyables(fileResolver, this, this.taskMutator);
        this.taskLocalState = new DefaultTaskLocalState(fileResolver, this, this.taskMutator);
    }

    private void assertDynamicObject() {
        if (this.extensibleDynamicObject == null) {
            this.extensibleDynamicObject = new ExtensibleDynamicObject((Object)this, this.publicType, this.services.get(Instantiator.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Task> T injectIntoNewInstance(ProjectInternal project, String name, Class<? extends Task> publicType, Callable<T> factory) {
        NEXT_INSTANCE.set(new TaskInfo(project, name, publicType));
        try {
            Task task = (Task)GUtil.uncheckedCall(factory);
            return (T)task;
        }
        finally {
            NEXT_INSTANCE.set(null);
        }
    }

    @Override
    public TaskStateInternal getState() {
        return this.state;
    }

    @Override
    public AntBuilder getAnt() {
        return this.project.getAnt();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Action<? super Task>> getActions() {
        if (this.observableActionList == null) {
            this.observableActionList = new ObservableActionWrapperList(this.getTaskActions());
            this.observableActionList.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractTask.this.taskMutator.assertMutable("Task.getActions()", evt);
                }
            });
        }
        return this.observableActionList;
    }

    @Override
    public List<ContextAwareTaskAction> getTaskActions() {
        if (this.actions == null) {
            this.actions = new ArrayList<ContextAwareTaskAction>();
        }
        return this.actions;
    }

    @Override
    public void setActions(final List<Action<? super Task>> replacements) {
        this.taskMutator.mutate("Task.setActions(List<Action>)", new Runnable(){

            public void run() {
                AbstractTask.this.getTaskActions().clear();
                for (Action action : replacements) {
                    AbstractTask.this.doLast(action);
                }
            }
        });
    }

    @Override
    public TaskDependencyInternal getTaskDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<Object> getDependsOn() {
        return this.dependencies.getValues();
    }

    @Override
    public void setDependsOn(final Iterable<?> dependsOn) {
        this.taskMutator.mutate("Task.setDependsOn(Iterable)", new Runnable(){

            public void run() {
                AbstractTask.this.dependencies.setValues(dependsOn);
            }
        });
    }

    @Override
    public void onlyIf(final Closure onlyIfClosure) {
        this.taskMutator.mutate("Task.onlyIf(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.onlyIfSpec.and(onlyIfClosure);
            }
        });
    }

    @Override
    public void onlyIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.onlyIf(Spec)", new Runnable(){

            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.onlyIfSpec.and(spec);
            }
        });
    }

    @Override
    public void setOnlyIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.setOnlyIf(Spec)", new Runnable(){

            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.createNewOnlyIfSpec().and(spec);
            }
        });
    }

    @Override
    public void setOnlyIf(final Closure onlyIfClosure) {
        this.taskMutator.mutate("Task.setOnlyIf(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.createNewOnlyIfSpec().and(onlyIfClosure);
            }
        });
    }

    private AndSpec<Task> createNewOnlyIfSpec() {
        return new AndSpec<Task>(new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                return element == AbstractTask.this && AbstractTask.this.enabled;
            }
        });
    }

    @Override
    public Spec<? super TaskInternal> getOnlyIf() {
        return this.onlyIfSpec;
    }

    @Override
    public boolean getDidWork() {
        return this.state.getDidWork();
    }

    @Override
    public void setDidWork(boolean didWork) {
        this.state.setDidWork(didWork);
    }

    @Internal
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(final boolean enabled) {
        this.taskMutator.mutate("Task.setEnabled(boolean)", new Runnable(){

            public void run() {
                AbstractTask.this.enabled = enabled;
            }
        });
    }

    @Override
    public boolean getImpliesSubProjects() {
        return this.impliesSubProjects;
    }

    @Override
    public void setImpliesSubProjects(boolean impliesSubProjects) {
        this.impliesSubProjects = impliesSubProjects;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = this.project.getProjectPath().child(this.name);
        }
        return this.path.getPath();
    }

    @Override
    public Path getIdentityPath() {
        if (this.identityPath == null) {
            this.identityPath = this.project.getIdentityPath().child(this.name);
        }
        return this.identityPath;
    }

    @Override
    public Task deleteAllActions() {
        this.taskMutator.mutate("Task.deleteAllActions()", new Runnable(){

            public void run() {
                AbstractTask.this.getTaskActions().clear();
            }
        });
        return this;
    }

    @Override
    public final void execute() {
        DeprecationLogger.nagUserOfDiscontinuedMethod("TaskInternal.execute()", this.getReuseTaskLogicAdvice());
        TaskExecuter executer = DeprecationLogger.whileDisabled(new Factory<TaskExecuter>(){

            @Override
            public TaskExecuter create() {
                return AbstractTask.this.getExecuter();
            }
        });
        executer.execute(this, this.state, new DefaultTaskExecutionContext());
        this.state.rethrowFailure();
    }

    @Override
    public TaskExecuter getExecuter() {
        DeprecationLogger.nagUserOfDiscontinuedProperty("TaskInternal.executer", this.getReuseTaskLogicAdvice());
        if (this.executer == null) {
            this.executer = this.services.get(TaskExecuter.class);
        }
        return this.executer;
    }

    @Override
    public void setExecuter(TaskExecuter executer) {
        DeprecationLogger.nagUserOfDiscontinuedProperty("TaskInternal.executer", this.getReuseTaskLogicAdvice());
        this.executer = executer;
    }

    private String getReuseTaskLogicAdvice() {
        String reuseTaskLogicUrl = this.services.get(DocumentationRegistry.class).getDocumentationFor("custom_tasks", "sec:reusing_task_logic");
        return "There are better ways to re-use task logic, see " + reuseTaskLogicUrl + ".";
    }

    @Override
    public Task dependsOn(final Object ... paths) {
        this.taskMutator.mutate("Task.dependsOn(Object...)", new Runnable(){

            public void run() {
                AbstractTask.this.dependencies.add(paths);
            }
        });
        return this;
    }

    @Override
    public Task doFirst(Action<? super Task> action) {
        return this.doFirst("doFirst {} action", action);
    }

    @Override
    public Task doFirst(final String actionName, final Action<? super Task> action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doFirst(Action)", new Runnable(){

            public void run() {
                AbstractTask.this.getTaskActions().add(0, AbstractTask.this.wrap(action, actionName));
            }
        });
        return this;
    }

    @Override
    public Task doLast(Action<? super Task> action) {
        return this.doLast("doLast {} action", action);
    }

    @Override
    public Task doLast(final String actionName, final Action<? super Task> action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doLast(Action)", new Runnable(){

            public void run() {
                AbstractTask.this.getTaskActions().add(AbstractTask.this.wrap(action, actionName));
            }
        });
        return this;
    }

    @Override
    public int compareTo(Task otherTask) {
        int depthCompare = this.project.compareTo(otherTask.getProject());
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherTask.getPath());
        }
        return depthCompare;
    }

    public String toString() {
        if (this.toStringValue == null) {
            this.toStringValue = "task '" + this.getIdentityPath() + "'";
        }
        return this.toStringValue;
    }

    @Override
    public Logger getLogger() {
        return BUILD_LOGGER;
    }

    @Override
    public LoggingManagerInternal getLogging() {
        if (this.loggingManager == null) {
            this.loggingManager = new LoggingManagerInternalCompatibilityBridge(this.services.getFactory(org.gradle.internal.logging.LoggingManagerInternal.class).create());
        }
        return this.loggingManager;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.getLogging();
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        this.assertDynamicObject();
        return this.extensibleDynamicObject.getProperty(propertyName);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        this.assertDynamicObject();
        return this.extensibleDynamicObject.hasProperty(propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.assertDynamicObject();
        this.extensibleDynamicObject.setProperty(name, value);
    }

    @Override
    public Convention getConvention() {
        this.assertDynamicObject();
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    @Internal
    public ExtensionContainer getExtensions() {
        return this.getConvention();
    }

    @Override
    @Internal
    public DynamicObject getAsDynamicObject() {
        this.assertDynamicObject();
        return this.extensibleDynamicObject;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public TaskInputsInternal getInputs() {
        return this.taskInputs;
    }

    @Override
    public TaskOutputsInternal getOutputs() {
        return this.taskOutputs;
    }

    @Override
    public TaskDestroyables getDestroyables() {
        return this.taskDestroyables;
    }

    @Override
    public TaskLocalState getLocalState() {
        return this.taskLocalState;
    }

    @Internal
    protected ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public boolean dependsOnTaskDidWork() {
        DeprecationLogger.nagUserOfDiscontinuedMethod("Task.dependsOnTaskDidWork()", "Instead, check the value of \"didWork()\" for each task, or declare the task inputs and outputs and let Gradle decide what needs to be run.");
        TaskDependencyInternal dependency = this.getTaskDependencies();
        for (Task task : dependency.getDependencies(this)) {
            if (!task.getDidWork()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Task doFirst(final Closure action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doFirst(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.getTaskActions().add(0, AbstractTask.this.convertClosureToAction(action, "doFirst {} action"));
            }
        });
        return this;
    }

    @Override
    public Task doLast(final Closure action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doLast(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.getTaskActions().add(AbstractTask.this.convertClosureToAction(action, "doLast {} action"));
            }
        });
        return this;
    }

    @Override
    public Task leftShift(final Closure action) {
        DeprecationLogger.nagUserWith("The Task.leftShift(Closure) method has been deprecated and is scheduled to be removed in Gradle 5.0. Please use Task.doLast(Action) instead.");
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.leftShift(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.getTaskActions().add(AbstractTask.this.taskMutator.leftShift(AbstractTask.this.convertClosureToAction(action, "doLast {} action")));
            }
        });
        return this;
    }

    @Override
    public Task configure(Closure closure) {
        return ConfigureUtil.configureSelf(closure, this);
    }

    @Override
    public File getTemporaryDir() {
        File dir = this.getServices().get(TemporaryFileProvider.class).newTemporaryFile(this.getName());
        GFileUtils.mkdirs(dir);
        return dir;
    }

    @Override
    public Factory<File> getTemporaryDirFactory() {
        return new Factory<File>(){

            @Override
            public File create() {
                return AbstractTask.this.getTemporaryDir();
            }
        };
    }

    @Override
    public void addValidator(TaskValidator validator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TaskValidator> getValidators() {
        throw new UnsupportedOperationException();
    }

    private ContextAwareTaskAction convertClosureToAction(Closure actionClosure, String actionName) {
        return new ClosureTaskAction(actionClosure, actionName);
    }

    private ContextAwareTaskAction wrap(Action<? super Task> action) {
        return this.wrap(action, "unnamed action");
    }

    private ContextAwareTaskAction wrap(Action<? super Task> action, String actionName) {
        if (action instanceof ContextAwareTaskAction) {
            return (ContextAwareTaskAction)action;
        }
        return new TaskActionWrapper(action, actionName);
    }

    private static String getActionClassName(Object action) {
        if (action instanceof ScriptOrigin) {
            ScriptOrigin origin = (ScriptOrigin)action;
            return origin.getOriginalClassName() + "_" + origin.getContentHash();
        }
        return action.getClass().getName();
    }

    @Override
    public void setMustRunAfter(final Iterable<?> mustRunAfterTasks) {
        this.taskMutator.mutate("Task.setMustRunAfter(Iterable)", new Runnable(){

            public void run() {
                AbstractTask.this.mustRunAfter.setValues(mustRunAfterTasks);
            }
        });
    }

    @Override
    public Task mustRunAfter(final Object ... paths) {
        this.taskMutator.mutate("Task.mustRunAfter(Object...)", new Runnable(){

            public void run() {
                AbstractTask.this.mustRunAfter.add(paths);
            }
        });
        return this;
    }

    @Override
    public TaskDependency getMustRunAfter() {
        return this.mustRunAfter;
    }

    @Override
    public void setFinalizedBy(final Iterable<?> finalizedByTasks) {
        this.taskMutator.mutate("Task.setFinalizedBy(Iterable)", new Runnable(){

            public void run() {
                AbstractTask.this.finalizedBy.setValues(finalizedByTasks);
            }
        });
    }

    @Override
    public Task finalizedBy(final Object ... paths) {
        this.taskMutator.mutate("Task.finalizedBy(Object...)", new Runnable(){

            public void run() {
                AbstractTask.this.finalizedBy.add(paths);
            }
        });
        return this;
    }

    @Override
    public TaskDependency getFinalizedBy() {
        return this.finalizedBy;
    }

    @Override
    public TaskDependency shouldRunAfter(final Object ... paths) {
        this.taskMutator.mutate("Task.shouldRunAfter(Object...)", new Runnable(){

            public void run() {
                AbstractTask.this.shouldRunAfter.add(paths);
            }
        });
        return this.shouldRunAfter;
    }

    @Override
    public void setShouldRunAfter(final Iterable<?> shouldRunAfterTasks) {
        this.taskMutator.mutate("Task.setShouldRunAfter(Iterable)", new Runnable(){

            public void run() {
                AbstractTask.this.shouldRunAfter.setValues(shouldRunAfterTasks);
            }
        });
    }

    @Override
    public TaskDependency getShouldRunAfter() {
        return this.shouldRunAfter;
    }

    @Override
    public void prependParallelSafeAction(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.getTaskActions().add(0, this.wrap(action));
    }

    @Override
    public void appendParallelSafeAction(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.getTaskActions().add(this.wrap(action));
    }

    @Override
    public boolean isHasCustomActions() {
        return this.hasCustomActions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObservableActionWrapperList
    extends ObservableList {
        public ObservableActionWrapperList(List delegate) {
            super(delegate);
        }

        public boolean add(Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            return super.add((Object)AbstractTask.this.wrap((Action)action));
        }

        public void add(int index, Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            super.add(index, (Object)AbstractTask.this.wrap((Action)action));
        }

        public boolean addAll(Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(this.transformToContextAwareTaskActions(actions));
        }

        public boolean addAll(int index, Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(index, this.transformToContextAwareTaskActions(actions));
        }

        public boolean removeAll(Collection actions) {
            return super.removeAll(this.transformToContextAwareTaskActions(actions));
        }

        public boolean remove(Object action) {
            return super.remove((Object)AbstractTask.this.wrap((Action)action));
        }

        private Collection<ContextAwareTaskAction> transformToContextAwareTaskActions(Collection<Object> c) {
            return Collections2.transform(c, (Function)new Function<Object, ContextAwareTaskAction>(){

                public ContextAwareTaskAction apply(@Nullable Object input) {
                    return AbstractTask.this.wrap((Action)input);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskActionWrapper
    implements ContextAwareTaskAction {
        private final Action<? super Task> action;
        private final String maybeActionName;

        public TaskActionWrapper(Action<? super Task> action, String maybeActionName) {
            this.action = action;
            this.maybeActionName = maybeActionName;
        }

        @Override
        public void contextualise(TaskExecutionContext context) {
            if (this.action instanceof ContextAwareTaskAction) {
                ((ContextAwareTaskAction)this.action).contextualise(context);
            }
        }

        @Override
        public void releaseContext() {
            if (this.action instanceof ContextAwareTaskAction) {
                ((ContextAwareTaskAction)this.action).releaseContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Task task) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
            try {
                this.action.execute(task);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        @Override
        public ClassLoader getClassLoader() {
            if (this.action instanceof ClassLoaderAwareTaskAction) {
                return ((ClassLoaderAwareTaskAction)this.action).getClassLoader();
            }
            return this.action.getClass().getClassLoader();
        }

        @Override
        public String getActionClassName() {
            if (this.action instanceof ClassLoaderAwareTaskAction) {
                return ((ClassLoaderAwareTaskAction)this.action).getActionClassName();
            }
            return AbstractTask.getActionClassName(this.action);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TaskActionWrapper)) {
                return false;
            }
            TaskActionWrapper that = (TaskActionWrapper)o;
            return !(this.action != null ? !this.action.equals(that.action) : that.action != null);
        }

        public int hashCode() {
            return this.action != null ? this.action.hashCode() : 0;
        }

        @Override
        public String getDisplayName() {
            if (this.action instanceof Describable) {
                return ((Describable)((Object)this.action)).getDisplayName();
            }
            return "Execute " + this.maybeActionName;
        }
    }

    private static class ClosureTaskAction
    implements ContextAwareTaskAction {
        private final Closure closure;
        private final String actionName;

        private ClosureTaskAction(Closure closure, String actionName) {
            this.closure = closure;
            this.actionName = actionName;
        }

        public void contextualise(TaskExecutionContext context) {
        }

        public void releaseContext() {
        }

        public void execute(Task task) {
            this.closure.setDelegate((Object)task);
            this.closure.setResolveStrategy(1);
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.closure.getClass().getClassLoader());
            try {
                if (this.closure.getMaximumNumberOfParameters() == 0) {
                    this.closure.call();
                } else {
                    this.closure.call((Object)task);
                }
            }
            catch (InvokerInvocationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        public ClassLoader getClassLoader() {
            return this.closure.getClass().getClassLoader();
        }

        public String getActionClassName() {
            return AbstractTask.getActionClassName(this.closure);
        }

        public String getDisplayName() {
            return "Execute " + this.actionName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskInfo {
        private final ProjectInternal project;
        private final Class<? extends Task> publicType;
        private final String name;

        private TaskInfo(ProjectInternal project, String name, Class<? extends Task> publicType) {
            this.name = name;
            this.project = project;
            this.publicType = publicType;
        }
    }
}

