/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.internal.SetIterator;
import org.gradle.api.internal.WithEstimatedSize;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Actions;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDomainObjectSet<T>
extends DelegatingDomainObjectSet<T>
implements WithEstimatedSize {
    private final Spec<T> uniqueSpec = new ItemIsUniqueInCompositeSpec();
    private final Spec<T> notInSpec = new ItemNotInCompositeSpec();
    private final DefaultDomainObjectSet<T> backingSet;

    public static <T> CompositeDomainObjectSet<T> create(Class<T> type, DomainObjectCollection<? extends T> ... collections) {
        DefaultDomainObjectSet<T> backingSet = new DefaultDomainObjectSet<T>(type, new DomainObjectCompositeCollection());
        CompositeDomainObjectSet<? extends T> out = new CompositeDomainObjectSet<T>(backingSet);
        for (DomainObjectCollection<? extends T> c : collections) {
            out.addCollection(c);
        }
        return out;
    }

    CompositeDomainObjectSet(DefaultDomainObjectSet<T> backingSet) {
        super(backingSet);
        this.backingSet = backingSet;
    }

    protected DomainObjectCompositeCollection getStore() {
        return (DomainObjectCompositeCollection)this.backingSet.getStore();
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return super.whenObjectAdded(Actions.filter(action, this.uniqueSpec));
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return super.whenObjectRemoved(Actions.filter(action, this.notInSpec));
    }

    public void addCollection(DomainObjectCollection<? extends T> collection) {
        if (!this.getStore().containsCollection(collection)) {
            this.getStore().addComposited(collection);
            collection.all(this.backingSet.getEventRegister().getAddAction());
            collection.whenObjectRemoved(this.backingSet.getEventRegister().getRemoveAction());
        }
    }

    public void removeCollection(DomainObjectCollection<? extends T> collection) {
        this.getStore().removeComposited(collection);
        Action action = this.backingSet.getEventRegister().getRemoveAction();
        for (Object item : collection) {
            action.execute(item);
        }
    }

    @Override
    public Iterator<T> iterator() {
        DomainObjectCompositeCollection store = this.getStore();
        if (store.isEmpty()) {
            return Iterators.emptyIterator();
        }
        return SetIterator.of(store);
    }

    @Override
    public int size() {
        DomainObjectCompositeCollection store = this.getStore();
        if (store.isEmpty()) {
            return 0;
        }
        HashSet tmp = Sets.newHashSetWithExpectedSize((int)this.estimatedSize());
        tmp.addAll(store);
        return tmp.size();
    }

    @Override
    public int estimatedSize() {
        return this.getStore().estimatedSize();
    }

    @Override
    public void all(Action<? super T> action) {
        this.whenObjectAdded(action);
        for (T t : this) {
            action.execute(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DomainObjectCompositeCollection<T>
    implements Collection<T>,
    WithEstimatedSize {
        private final List<DomainObjectCollection<? extends T>> store = Lists.newLinkedList();

        private DomainObjectCompositeCollection() {
        }

        public boolean containsCollection(DomainObjectCollection<? extends T> collection) {
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                if (domainObjectCollection != collection) continue;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            int size = 0;
            for (DomainObjectCollection<T> ts : this.store) {
                size += ts.size();
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            for (DomainObjectCollection<T> ts : this.store) {
                if (ts.isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object o) {
            for (DomainObjectCollection<T> ts : this.store) {
                if (!ts.contains(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.store.isEmpty()) {
                return Iterators.emptyIterator();
            }
            if (this.store.size() == 1) {
                return this.store.get(0).iterator();
            }
            Iterator[] iterators = new Iterator[this.store.size()];
            int i = 0;
            for (DomainObjectCollection<T> ts : this.store) {
                iterators[i++] = ts.iterator();
            }
            return Iterators.concat((Iterator[])iterators);
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> V[] toArray(V[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void addComposited(DomainObjectCollection<? extends T> collection) {
            this.store.add(collection);
        }

        public void removeComposited(DomainObjectCollection<? extends T> collection) {
            Iterator<DomainObjectCollection<T>> iterator = this.store.iterator();
            while (iterator.hasNext()) {
                DomainObjectCollection<? extends T> next = iterator.next();
                if (next != collection) continue;
                iterator.remove();
                break;
            }
        }

        @Override
        public int estimatedSize() {
            int size = 0;
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                size += WithEstimatedSize.Estimates.estimateSizeOf(domainObjectCollection);
            }
            return size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemNotInCompositeSpec
    implements Spec<T> {
        @Override
        public boolean isSatisfiedBy(T element) {
            return !CompositeDomainObjectSet.this.getStore().contains(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemIsUniqueInCompositeSpec
    implements Spec<T> {
        @Override
        public boolean isSatisfiedBy(T element) {
            int matches = 0;
            for (Object collection : CompositeDomainObjectSet.this.getStore().store) {
                if (!((Collection)collection).contains(element) || ++matches <= 1) continue;
                return false;
            }
            return true;
        }
    }
}

