/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.CachedModuleVersionResult;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;

class InMemoryMetaDataCache {
    private final Map<ModuleComponentSelector, Set<String>> moduleVersionListing = Maps.newConcurrentMap();
    private final Map<ModuleComponentIdentifier, CachedModuleVersionResult> metaData = Maps.newConcurrentMap();
    private final Map<ModuleComponentIdentifier, MetadataFetchingCost> fetchingCosts = Maps.newConcurrentMap();

    InMemoryMetaDataCache() {
    }

    public boolean supplyModuleVersions(ModuleComponentSelector requested, BuildableModuleVersionListingResolveResult result) {
        Set<String> versions = this.moduleVersionListing.get(requested);
        if (versions == null) {
            return false;
        }
        result.listed(versions);
        return true;
    }

    public void newModuleVersions(ModuleComponentSelector requested, BuildableModuleVersionListingResolveResult result) {
        if (result.getState() == BuildableModuleVersionListingResolveResult.State.Listed) {
            this.moduleVersionListing.put(requested, result.getVersions());
        }
    }

    boolean supplyMetaData(ModuleComponentIdentifier requested, BuildableModuleComponentMetaDataResolveResult result) {
        CachedModuleVersionResult fromCache = this.metaData.get(requested);
        if (fromCache == null) {
            return false;
        }
        fromCache.supply(result);
        return true;
    }

    void newDependencyResult(ModuleComponentIdentifier requested, BuildableModuleComponentMetaDataResolveResult result) {
        CachedModuleVersionResult cachedResult = new CachedModuleVersionResult(result);
        if (cachedResult.isCacheable()) {
            this.metaData.put(requested, cachedResult);
        }
    }

    MetadataFetchingCost getOrCacheFetchingCost(ModuleComponentIdentifier id, Factory<MetadataFetchingCost> costFactory) {
        MetadataFetchingCost cost = this.fetchingCosts.get(id);
        if (cost == null) {
            cost = costFactory.create();
            this.fetchingCosts.put(id, cost);
        }
        return cost;
    }

    void cacheFetchingCost(ModuleComponentIdentifier id, MetadataFetchingCost cost) {
        this.fetchingCosts.put(id, cost);
    }
}

