/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.DefaultResolvedDependency;
import org.gradle.api.internal.artifacts.DependencyGraphNodeResult;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.DefaultTransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.BinaryStore;
import org.gradle.cache.internal.Store;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class TransientConfigurationResultsBuilder {
    private static final Logger LOG = Logging.getLogger(TransientConfigurationResultsBuilder.class);
    private static final byte NODE = 1;
    private static final byte ROOT = 2;
    private static final byte FIRST_LEVEL = 3;
    private static final byte EDGE = 4;
    private static final byte NODE_ARTIFACTS = 5;
    private final Object lock = new Object();
    private BinaryStore binaryStore;
    private Store<TransientConfigurationResults> cache;
    private final BuildOperationExecutor buildOperationProcessor;
    private final ResolvedConfigurationIdentifierSerializer resolvedConfigurationIdentifierSerializer;
    private BinaryStore.BinaryData binaryData;

    public TransientConfigurationResultsBuilder(BinaryStore binaryStore, Store<TransientConfigurationResults> cache, ImmutableModuleIdentifierFactory moduleIdentifierFactory, BuildOperationExecutor buildOperationProcessor) {
        this.resolvedConfigurationIdentifierSerializer = new ResolvedConfigurationIdentifierSerializer(moduleIdentifierFactory);
        this.binaryStore = binaryStore;
        this.cache = cache;
        this.buildOperationProcessor = buildOperationProcessor;
    }

    public void resolvedDependency(final Long id, final ResolvedConfigurationIdentifier details) {
        this.binaryStore.write(new BinaryStore.WriteAction(){

            @Override
            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)1);
                encoder.writeSmallLong(id);
                TransientConfigurationResultsBuilder.this.resolvedConfigurationIdentifierSerializer.write(encoder, details);
            }
        });
    }

    public void done(final Long id) {
        this.binaryStore.write(new BinaryStore.WriteAction(){

            @Override
            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)2);
                encoder.writeSmallLong(id);
            }
        });
        LOG.debug("Flushing resolved configuration data in {}. Wrote root {}.", this.binaryStore, id);
        this.binaryData = this.binaryStore.done();
    }

    public void firstLevelDependency(final Long id) {
        this.binaryStore.write(new BinaryStore.WriteAction(){

            @Override
            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)3);
                encoder.writeSmallLong(id);
            }
        });
    }

    public void parentChildMapping(final Long parent, final Long child, final int artifactId) {
        this.binaryStore.write(new BinaryStore.WriteAction(){

            @Override
            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)4);
                encoder.writeSmallLong(parent);
                encoder.writeSmallLong(child);
                encoder.writeSmallInt(artifactId);
            }
        });
    }

    public void nodeArtifacts(final Long node, final int artifactId) {
        this.binaryStore.write(new BinaryStore.WriteAction(){

            @Override
            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)5);
                encoder.writeSmallLong(node);
                encoder.writeSmallInt(artifactId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransientConfigurationResults load(final ResolvedGraphResults graphResults, final SelectedArtifactResults artifactResults) {
        Object object = this.lock;
        synchronized (object) {
            return this.cache.load(new Factory<TransientConfigurationResults>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public TransientConfigurationResults create() {
                    try {
                        TransientConfigurationResults transientConfigurationResults = TransientConfigurationResultsBuilder.this.binaryData.read(new BinaryStore.ReadAction<TransientConfigurationResults>(){

                            @Override
                            public TransientConfigurationResults read(Decoder decoder) throws IOException {
                                return TransientConfigurationResultsBuilder.this.deserialize(decoder, graphResults, artifactResults, TransientConfigurationResultsBuilder.this.buildOperationProcessor);
                            }
                        });
                        return transientConfigurationResults;
                    }
                    finally {
                        try {
                            TransientConfigurationResultsBuilder.this.binaryData.close();
                        }
                        catch (IOException e) {
                            throw UncheckedException.throwAsUncheckedException(e);
                        }
                    }
                }
            });
        }
    }

    private TransientConfigurationResults deserialize(Decoder decoder, ResolvedGraphResults graphResults, SelectedArtifactResults artifactResults, BuildOperationExecutor buildOperationProcessor) {
        Timer clock = Time.startTimer();
        HashMap<Long, DefaultResolvedDependency> allDependencies = new HashMap<Long, DefaultResolvedDependency>();
        LinkedHashMap<ModuleDependency, DependencyGraphNodeResult> firstLevelDependencies = new LinkedHashMap<ModuleDependency, DependencyGraphNodeResult>();
        int valuesRead = 0;
        int type = -1;
        try {
            block9: while (true) {
                type = decoder.readByte();
                ++valuesRead;
                switch (type) {
                    case 1: {
                        long id = decoder.readSmallLong();
                        ResolvedConfigurationIdentifier details = this.resolvedConfigurationIdentifierSerializer.read(decoder);
                        allDependencies.put(id, new DefaultResolvedDependency(id, details, buildOperationProcessor));
                        continue block9;
                    }
                    case 2: {
                        long id = decoder.readSmallLong();
                        DependencyGraphNodeResult root = (DependencyGraphNodeResult)allDependencies.get(id);
                        if (root == null) {
                            throw new IllegalStateException(String.format("Unexpected root id %s. Seen ids: %s", id, allDependencies.keySet()));
                        }
                        LOG.debug("Loaded resolved configuration results ({}) from {}", clock.getElapsed(), this.binaryStore);
                        return new DefaultTransientConfigurationResults(root, firstLevelDependencies);
                    }
                    case 3: {
                        long id = decoder.readSmallLong();
                        DefaultResolvedDependency dependency = (DefaultResolvedDependency)allDependencies.get(id);
                        if (dependency == null) {
                            throw new IllegalStateException(String.format("Unexpected first level id %s. Seen ids: %s", id, allDependencies.keySet()));
                        }
                        firstLevelDependencies.put(graphResults.getModuleDependency(id), dependency);
                        continue block9;
                    }
                    case 4: {
                        long parentId = decoder.readSmallLong();
                        long childId = decoder.readSmallLong();
                        DefaultResolvedDependency parent = (DefaultResolvedDependency)allDependencies.get(parentId);
                        DefaultResolvedDependency child = (DefaultResolvedDependency)allDependencies.get(childId);
                        if (parent == null) {
                            throw new IllegalStateException(String.format("Unexpected parent dependency id %s. Seen ids: %s", parentId, allDependencies.keySet()));
                        }
                        if (child == null) {
                            throw new IllegalStateException(String.format("Unexpected child dependency id %s. Seen ids: %s", childId, allDependencies.keySet()));
                        }
                        parent.addChild(child);
                        ResolvedArtifactSet artifacts = artifactResults.getArtifactsWithId(decoder.readSmallInt());
                        child.addParentSpecificArtifacts(parent, artifacts);
                        continue block9;
                    }
                    case 5: {
                        long id = decoder.readSmallLong();
                        DefaultResolvedDependency node = (DefaultResolvedDependency)allDependencies.get(id);
                        if (node == null) {
                            throw new IllegalStateException(String.format("Unexpected node id %s. Seen ids: %s", node, allDependencies.keySet()));
                        }
                        ResolvedArtifactSet artifacts = artifactResults.getArtifactsWithId(decoder.readSmallInt());
                        node.addModuleArtifacts(artifacts);
                        continue block9;
                    }
                }
                break;
            }
            throw new IOException("Unknown value type read from stream: " + type);
        }
        catch (IOException e) {
            throw new RuntimeException("Problems loading the resolved configuration. Read " + valuesRead + " values, last was: " + type, e);
        }
    }
}

