/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependenciesMetadata;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.repositories.resolver.DependencyMetadataAdapter;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.model.GradleDependencyMetadata;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class DependenciesMetadataAdapter
extends AbstractList<DependencyMetadata>
implements DependenciesMetadata {
    private final List<org.gradle.internal.component.model.DependencyMetadata> dependenciesMetadata;
    private final Map<Integer, DependencyMetadata> dependencyMetadataAdapters;
    private final Instantiator instantiator;
    private final NotationParser<Object, DependencyMetadata> dependencyNotationParser;

    public DependenciesMetadataAdapter(List<org.gradle.internal.component.model.DependencyMetadata> dependenciesMetadata, Instantiator instantiator, NotationParser<Object, DependencyMetadata> dependencyNotationParser) {
        this.dependenciesMetadata = dependenciesMetadata;
        this.dependencyMetadataAdapters = Maps.newHashMap();
        this.instantiator = instantiator;
        this.dependencyNotationParser = dependencyNotationParser;
    }

    @Override
    public DependencyMetadata get(int index) {
        if (!this.dependencyMetadataAdapters.containsKey(index)) {
            this.dependencyMetadataAdapters.put(index, this.instantiator.newInstance(DependencyMetadataAdapter.class, this.dependenciesMetadata, index));
        }
        return this.dependencyMetadataAdapters.get(index);
    }

    @Override
    public int size() {
        return this.dependenciesMetadata.size();
    }

    @Override
    public DependencyMetadata remove(int index) {
        DependencyMetadata componentDependencyMetadata = this.get(index);
        this.dependenciesMetadata.remove(index);
        this.dependencyMetadataAdapters.remove(index);
        return componentDependencyMetadata;
    }

    @Override
    public void add(String dependencyNotation) {
        this.doAdd(dependencyNotation, null);
    }

    @Override
    public void add(Map<String, String> dependencyNotation) {
        this.doAdd(dependencyNotation, null);
    }

    @Override
    public void add(String dependencyNotation, Action<DependencyMetadata> configureAction) {
        this.doAdd(dependencyNotation, configureAction);
    }

    @Override
    public void add(Map<String, String> dependencyNotation, Action<DependencyMetadata> configureAction) {
        this.doAdd(dependencyNotation, configureAction);
    }

    private void doAdd(Object dependencyNotation, @Nullable Action<DependencyMetadata> configureAction) {
        DependencyMetadata dependencyMetadata = this.dependencyNotationParser.parseNotation(dependencyNotation);
        if (configureAction != null) {
            configureAction.execute(dependencyMetadata);
        }
        this.dependenciesMetadata.add(this.toDependencyMetadata(dependencyMetadata));
    }

    private org.gradle.internal.component.model.DependencyMetadata toDependencyMetadata(DependencyMetadata details) {
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(details.getGroup(), details.getName(), DefaultImmutableVersionConstraint.of(details.getVersion()));
        return new GradleDependencyMetadata(selector);
    }
}

