/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ChangesOnlyIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskUpToDateState;
import org.gradle.api.internal.changedetection.state.CurrentTaskExecution;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.HistoricalTaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.TaskOutputFilesRepository;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.caching.internal.tasks.TaskCacheKeyCalculator;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.Instantiator;

@NonNullApi
public class DefaultTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final TaskHistoryRepository taskHistoryRepository;
    private final Instantiator instantiator;
    private final TaskOutputFilesRepository taskOutputFilesRepository;

    public DefaultTaskArtifactStateRepository(TaskHistoryRepository taskHistoryRepository, Instantiator instantiator, TaskOutputFilesRepository taskOutputFilesRepository) {
        this.taskHistoryRepository = taskHistoryRepository;
        this.instantiator = instantiator;
        this.taskOutputFilesRepository = taskOutputFilesRepository;
    }

    public TaskArtifactState getStateFor(TaskInternal task) {
        return new TaskArtifactStateImpl(task, this.taskHistoryRepository.getHistory(task));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskArtifactStateImpl
    implements TaskArtifactState,
    TaskExecutionHistory {
        private final TaskInternal task;
        private final TaskHistoryRepository.History history;
        private boolean upToDate;
        private boolean outputsRemoved;
        private TaskUpToDateState states;
        private IncrementalTaskInputsInternal taskInputs;

        public TaskArtifactStateImpl(TaskInternal task, TaskHistoryRepository.History history) {
            this.task = task;
            this.history = history;
        }

        @Override
        public boolean isUpToDate(Collection<String> messages) {
            this.upToDate = true;
            for (TaskStateChange stateChange : this.getStates().getAllTaskChanges()) {
                messages.add(stateChange.getMessage());
                this.upToDate = false;
            }
            return this.upToDate;
        }

        @Override
        public IncrementalTaskInputs getInputChanges() {
            assert (!this.upToDate) : "Should not be here if the task is up-to-date";
            this.taskInputs = !this.outputsRemoved && this.canPerformIncrementalBuild() ? (IncrementalTaskInputsInternal)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(ChangesOnlyIncrementalTaskInputs.class, this.getStates().getInputFilesChanges()) : (IncrementalTaskInputsInternal)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, this.task);
            return this.taskInputs;
        }

        private boolean canPerformIncrementalBuild() {
            return Iterables.isEmpty((Iterable)this.getStates().getRebuildChanges());
        }

        @Override
        public boolean isAllowedToUseCachedResults() {
            return true;
        }

        @Override
        @Nullable
        public OverlappingOutputs getOverlappingOutputs() {
            return this.history.getCurrentExecution().getDetectedOverlappingOutputs();
        }

        @Override
        public TaskOutputCachingBuildCacheKey calculateCacheKey() {
            return TaskCacheKeyCalculator.calculate(this.task, this.history.getCurrentExecution());
        }

        @Override
        public Set<File> getOutputFiles() {
            HistoricalTaskExecution previousExecution = this.history.getPreviousExecution();
            if (previousExecution == null) {
                return Collections.emptySet();
            }
            ImmutableCollection outputFilesSnapshot = previousExecution.getOutputFilesSnapshot().values();
            HashSet<File> outputs = new HashSet<File>();
            for (FileCollectionSnapshot fileCollectionSnapshot : outputFilesSnapshot) {
                outputs.addAll(fileCollectionSnapshot.getElements());
            }
            return outputs;
        }

        @Override
        public Map<String, Map<String, FileContentSnapshot>> getOutputContentSnapshots() {
            ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesSnapshot = this.history.getCurrentExecution().getOutputFilesSnapshot();
            return Maps.transformValues(outputFilesSnapshot, (Function)new Function<FileCollectionSnapshot, Map<String, FileContentSnapshot>>(){

                public Map<String, FileContentSnapshot> apply(FileCollectionSnapshot fileCollectionSnapshot) {
                    return fileCollectionSnapshot.getContentSnapshots();
                }
            });
        }

        @Override
        public TaskExecutionHistory getExecutionHistory() {
            return this;
        }

        @Override
        @Nullable
        public UniqueId getOriginBuildInvocationId() {
            HistoricalTaskExecution previousExecution = this.history.getPreviousExecution();
            if (previousExecution == null) {
                return null;
            }
            return previousExecution.getBuildInvocationId();
        }

        @Override
        public void ensureSnapshotBeforeTask() {
            this.history.getCurrentExecution();
        }

        @Override
        public void afterOutputsRemovedBeforeTask() {
            this.outputsRemoved = true;
        }

        @Override
        public void snapshotAfterTaskExecution(Throwable failure) {
            this.history.updateCurrentExecution(this.taskInputs);
            this.snapshotAfterOutputsWereGenerated(this.history, failure);
        }

        @Override
        public void snapshotAfterLoadedFromCache(ImmutableSortedMap<String, FileCollectionSnapshot> newOutputSnapshot) {
            this.history.updateCurrentExecutionWithOutputs(this.taskInputs, newOutputSnapshot);
            this.snapshotAfterOutputsWereGenerated(this.history, null);
        }

        private void snapshotAfterOutputsWereGenerated(TaskHistoryRepository.History history, @Nullable Throwable failure) {
            if (failure == null || this.getStates().hasAnyOutputFileChanges()) {
                history.persist();
                ImmutableSet<String> outputFilePaths = history.getCurrentExecution().getDeclaredOutputFilePaths();
                DefaultTaskArtifactStateRepository.this.taskOutputFilesRepository.recordOutputs((Iterable<String>)outputFilePaths);
            }
        }

        private TaskUpToDateState getStates() {
            if (this.states == null) {
                HistoricalTaskExecution previousExecution = this.history.getPreviousExecution();
                CurrentTaskExecution currentExecution = this.history.getCurrentExecution();
                this.states = new TaskUpToDateState(previousExecution, currentExecution, this.task);
            }
            return this.states;
        }
    }
}

