/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.CollectingFileCollectionSnapshotBuilder;
import org.gradle.api.internal.changedetection.state.DefaultNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.InputPathNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceWithContentsVisitor;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.MultimapBuilder;
import org.gradle.internal.impldep.com.google.common.collect.Ordering;

public class ClasspathEntrySnapshotBuilder
implements ResourceWithContentsVisitor {
    private static final Ordering<Map.Entry<String, NormalizedFileSnapshot>> SNAPSHOT_ENTRY_ORDERING = Ordering.natural().onResultOf((Function)new Function<Map.Entry<String, NormalizedFileSnapshot>, Comparable<NormalizedFileSnapshot>>(){

        public NormalizedFileSnapshot apply(Map.Entry<String, NormalizedFileSnapshot> input) {
            return input.getValue();
        }
    });
    private final StringInterner stringInterner;
    private final Multimap<String, NormalizedFileSnapshot> normalizedSnapshots;
    private final ResourceHasher classpathResourceHasher;

    public ClasspathEntrySnapshotBuilder(ResourceHasher classpathResourceHasher, StringInterner stringInterner) {
        this.classpathResourceHasher = classpathResourceHasher;
        this.stringInterner = stringInterner;
        this.normalizedSnapshots = MultimapBuilder.hashKeys().arrayListValues().build();
    }

    public void visitFileSnapshot(RegularFileSnapshot file) {
        HashCode hash = this.classpathResourceHasher.hash(file);
        if (hash != null) {
            this.normalizedSnapshots.put((Object)file.getPath(), (Object)InputPathNormalizationStrategy.RELATIVE.getNormalizedSnapshot(file.withContentHash(hash), this.stringInterner));
        }
    }

    public void visitZipFileEntry(ZipEntry zipEntry, InputStream zipInput) throws IOException {
        HashCode hash = this.classpathResourceHasher.hash(zipEntry, zipInput);
        if (hash != null) {
            this.normalizedSnapshots.put((Object)zipEntry.getName(), (Object)new DefaultNormalizedFileSnapshot(zipEntry.getName(), new FileHashSnapshot(hash)));
        }
    }

    public HashCode getHash() {
        if (this.normalizedSnapshots.isEmpty()) {
            return null;
        }
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        Collection values = this.normalizedSnapshots.values();
        TaskFilePropertyCompareStrategy.UNORDERED.appendToHasher(hasher, values);
        return hasher.hash();
    }

    public void collectNormalizedSnapshots(CollectingFileCollectionSnapshotBuilder builder) {
        if (this.normalizedSnapshots.isEmpty()) {
            return;
        }
        ArrayList sorted = new ArrayList(this.normalizedSnapshots.entries());
        Collections.sort(sorted, SNAPSHOT_ENTRY_ORDERING);
        for (Map.Entry normalizedFileSnapshotEntry : sorted) {
            builder.collectNormalizedFileSnapshot((String)normalizedFileSnapshotEntry.getKey(), (NormalizedFileSnapshot)normalizedFileSnapshotEntry.getValue());
        }
    }
}

