/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.file.PathToFileResolver;

public class FileCopyAction
implements CopyAction {
    private final PathToFileResolver fileResolver;

    public FileCopyAction(PathToFileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public WorkResult execute(CopyActionProcessingStream stream) {
        FileCopyDetailsInternalAction action = new FileCopyDetailsInternalAction();
        stream.process(action);
        return WorkResults.didWork(action.didWork);
    }

    private class FileCopyDetailsInternalAction
    implements CopyActionProcessingStreamAction {
        private boolean didWork;

        private FileCopyDetailsInternalAction() {
        }

        public void processFile(FileCopyDetailsInternal details) {
            File target = FileCopyAction.this.fileResolver.resolve(details.getRelativePath().getPathString());
            boolean copied = details.copyTo(target);
            if (copied) {
                this.didWork = true;
            }
        }
    }
}

