/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.AnythingMatcher;
import org.gradle.api.internal.file.pattern.EndOfPathMatcher;
import org.gradle.api.internal.file.pattern.FixedStepPathMatcher;
import org.gradle.api.internal.file.pattern.GreedyPathMatcher;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternStepFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternMatcherFactory {
    private static final EndOfPathMatcher END_OF_PATH_MATCHER = new EndOfPathMatcher();
    private static final String PATH_SEPARATORS = "\\/";

    public static Spec<RelativePath> getPatternMatcher(boolean partialMatchDirs, boolean caseSensitive, String pattern) {
        PathMatcher pathMatcher = PatternMatcherFactory.compile(caseSensitive, pattern);
        return new PathMatcherBackedSpec(partialMatchDirs, pathMatcher);
    }

    public static PathMatcher compile(boolean caseSensitive, String pattern) {
        if (pattern.length() == 0) {
            return END_OF_PATH_MATCHER;
        }
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            pattern = pattern + "**";
        }
        String[] parts = StringUtils.split((String)pattern, (String)PATH_SEPARATORS);
        return PatternMatcherFactory.compile(parts, 0, caseSensitive);
    }

    private static PathMatcher compile(String[] parts, int startIndex, boolean caseSensitive) {
        int pos;
        if (startIndex >= parts.length) {
            return END_OF_PATH_MATCHER;
        }
        for (pos = startIndex; pos < parts.length && parts[pos].equals("**"); ++pos) {
        }
        if (pos > startIndex) {
            if (pos == parts.length) {
                return new AnythingMatcher();
            }
            return new GreedyPathMatcher(PatternMatcherFactory.compile(parts, pos, caseSensitive));
        }
        return new FixedStepPathMatcher(PatternStepFactory.getStep(parts[pos], caseSensitive), PatternMatcherFactory.compile(parts, pos + 1, caseSensitive));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PathMatcherBackedSpec
    implements Spec<RelativePath> {
        private final boolean partialMatchDirs;
        private final PathMatcher pathMatcher;

        PathMatcherBackedSpec(boolean partialMatchDirs, PathMatcher pathMatcher) {
            this.partialMatchDirs = partialMatchDirs;
            this.pathMatcher = pathMatcher;
        }

        PathMatcher getPathMatcher() {
            return this.pathMatcher;
        }

        @Override
        public boolean isSatisfiedBy(RelativePath element) {
            if (element.isFile() || !this.partialMatchDirs) {
                return this.pathMatcher.matches(element.getSegments(), 0);
            }
            return this.pathMatcher.isPrefix(element.getSegments(), 0);
        }
    }
}

