/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.tasks.TaskPropertyValue;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.util.DeferredUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPropertyInfo
implements Comparable<TaskPropertyInfo> {
    private static final UpdateAction NO_OP_CONFIGURATION_ACTION = new UpdateAction(){

        public void update(TaskInternal task, TaskPropertyValue futureValue) {
        }
    };
    private final TaskPropertyInfo parent;
    private final String propertyName;
    private final Class<? extends Annotation> propertyType;
    private final Method method;
    private final UpdateAction configureAction;

    TaskPropertyInfo(TaskPropertyInfo parent, String propertyName, Class<? extends Annotation> propertyType, Method method, UpdateAction configureAction) {
        this.parent = parent;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.method = method;
        method.setAccessible(true);
        this.configureAction = configureAction == null ? NO_OP_CONFIGURATION_ACTION : configureAction;
    }

    public String toString() {
        return String.format("@%s %s", this.propertyType.getSimpleName(), this.propertyName);
    }

    public String getName() {
        return this.propertyName;
    }

    public Class<? extends Annotation> getPropertyType() {
        return this.propertyType;
    }

    public UpdateAction getConfigureAction() {
        return this.configureAction;
    }

    public PropertyValue getValue(Object rootObject) {
        Object bean;
        if (this.parent != null) {
            PropertyValue parentValue = this.parent.getValue(rootObject);
            if (parentValue.getValue() == null) {
                return PropertyValue.NO_OP;
            }
            bean = parentValue.getValue();
        } else {
            bean = rootObject;
        }
        final Object value = DeprecationLogger.whileDisabled(new Factory<Object>(){

            @Override
            public Object create() {
                try {
                    return TaskPropertyInfo.this.method.invoke(bean, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw UncheckedException.throwAsUncheckedException(e.getCause());
                }
                catch (Exception e) {
                    throw new GradleException(String.format("Could not call %s.%s() on %s", TaskPropertyInfo.this.method.getDeclaringClass().getSimpleName(), TaskPropertyInfo.this.method.getName(), bean), e);
                }
            }
        });
        return new PropertyValue(){

            public Object getValue() {
                return value instanceof Provider ? ((Provider)value).getOrNull() : value;
            }

            public void validate(boolean optional, ValidationAction valueValidator, TaskValidationContext context, TaskValidationContext.Severity severity) {
                Object unpacked = DeferredUtil.unpack(this.getValue());
                if (unpacked == null) {
                    if (!optional) {
                        context.recordValidationMessage(severity, String.format("No value has been specified for property '%s'.", TaskPropertyInfo.this.propertyName));
                    }
                } else {
                    valueValidator.validate(TaskPropertyInfo.this.propertyName, unpacked, context, severity);
                }
            }
        };
    }

    @Override
    public int compareTo(@Nonnull TaskPropertyInfo o) {
        return this.propertyName.compareTo(o.getName());
    }

    public static interface PropertyValue {
        public static final PropertyValue NO_OP = new PropertyValue(){

            public Object getValue() {
                return null;
            }

            public void validate(boolean optional, ValidationAction valueValidator, TaskValidationContext context, TaskValidationContext.Severity severity) {
            }
        };

        public Object getValue();

        public void validate(boolean var1, ValidationAction var2, TaskValidationContext var3, TaskValidationContext.Severity var4);
    }
}

